/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.ofx4j.io.v2;

import com.webcohesion.ofx4j.io.v1.OFXV1Writer;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Map;

public class OFXV2Writer
extends OFXV1Writer {
    public OFXV2Writer(OutputStream out) {
        super(out);
    }

    public OFXV2Writer(Writer writer) {
        super(writer);
    }

    @Override
    protected OutputStreamWriter newWriter(OutputStream out) throws UnsupportedEncodingException {
        return new OutputStreamWriter(out, "UTF-8");
    }

    @Override
    public void writeHeaders(Map<String, String> headers) throws IOException {
        String uid;
        String olduid;
        if (this.headersWritten) {
            throw new IllegalStateException("Headers have already been written!");
        }
        this.print("<?xml version=\"1.0\" encoding=\"utf-8\" ?>");
        String security = headers.get("SECURITY");
        if (security == null) {
            security = "NONE";
        }
        if ((olduid = headers.get("OLDFILEUID")) == null) {
            olduid = "NONE";
        }
        if ((uid = headers.get("NEWFILEUID")) == null) {
            uid = "NONE";
        }
        this.print(String.format("<?OFX OFXHEADER=\"200\" VERSION=\"202\" SECURITY=\"%s\" OLDFILEUID=\"%s\" NEWFILEUID=\"%s\"?>", security, olduid, uid));
        this.headersWritten = true;
    }

    @Override
    public void writeElement(String name, String value) throws IOException {
        super.writeElement(name, value);
        this.print("</");
        this.print(name);
        this.print('>');
    }

    @Override
    public boolean isWriteAttributesOnNewLine() {
        return false;
    }
}

