/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.ofx4j.server;

import com.webcohesion.ofx4j.domain.data.RequestEnvelope;
import com.webcohesion.ofx4j.domain.data.RequestMessageSet;
import com.webcohesion.ofx4j.domain.data.signon.FinancialInstitution;
import com.webcohesion.ofx4j.domain.data.signon.SignonRequestMessageSet;
import com.webcohesion.ofx4j.io.AggregateMarshaller;
import com.webcohesion.ofx4j.io.AggregateUnmarshaller;
import com.webcohesion.ofx4j.io.OFXParseException;
import com.webcohesion.ofx4j.io.OFXWriter;
import com.webcohesion.ofx4j.io.v1.OFXV1Writer;
import com.webcohesion.ofx4j.io.v2.OFXV2Writer;
import com.webcohesion.ofx4j.server.OFXRequestException;
import com.webcohesion.ofx4j.server.OFXServer;
import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class OFXServlet
extends HttpServlet {
    private OFXServer server;
    private boolean OFXVersion2;

    public void init() throws ServletException {
        super.init();
        this.server = this.loadOFXServer();
        String version = this.getServletConfig().getInitParameter("ofx-version");
        this.OFXVersion2 = "2".equals(version);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            RequestEnvelope requestEnvelope;
            if (!request.getContentType().toLowerCase().equals("application/x-ofx")) {
                throw new OFXRequestException("Unsupported content type: " + request.getContentType());
            }
            AggregateUnmarshaller<RequestEnvelope> unmarshaller = this.createUnmarshaller();
            try {
                requestEnvelope = unmarshaller.unmarshal(request.getReader());
            }
            catch (OFXParseException e) {
                throw new OFXRequestException("Unable to parse client request: " + e.getMessage());
            }
            String orgFid = request.getParameter("ORGFID");
            String org = orgFid.substring(0, orgFid.indexOf(44));
            String fid = orgFid.substring(orgFid.indexOf(44) + 1);
            RequestMessageSet messageSet = requestEnvelope.getMessageSets().first();
            SignonRequestMessageSet signonRequestMessageSet = (SignonRequestMessageSet)messageSet;
            FinancialInstitution fi = new FinancialInstitution();
            fi.setId(fid);
            fi.setOrganization(org);
            signonRequestMessageSet.getSignonRequest().setFinancialInstitution(fi);
            AggregateMarshaller marshaller = new AggregateMarshaller();
            OFXWriter writer = this.createOFXWriter((OutputStream)response.getOutputStream());
            marshaller.marshal(this.getServer().getResponse(requestEnvelope), writer);
            writer.close();
        }
        catch (OFXRequestException e) {
            String message = e.getMessage();
            if (message == null) {
                message = "Problem with client request.";
            }
            response.sendError(400, message);
        }
    }

    protected OFXWriter createOFXWriter(OutputStream out) {
        return this.isOFXVersion2() ? new OFXV2Writer(out) : new OFXV1Writer(out);
    }

    protected AggregateUnmarshaller<RequestEnvelope> createUnmarshaller() {
        return new AggregateUnmarshaller<RequestEnvelope>(RequestEnvelope.class);
    }

    protected OFXServer loadOFXServer() throws ServletException {
        String serverClassname = this.getServletConfig().getInitParameter("ofx-server-class");
        if (serverClassname == null) {
            throw new ServletException("Missing init parameter: ofx-server-class");
        }
        try {
            return (OFXServer)Class.forName(serverClassname).newInstance();
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    public OFXServer getServer() {
        return this.server;
    }

    public boolean isOFXVersion2() {
        return this.OFXVersion2;
    }
}

