/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.util;

import io.sentry.SentryLevel;
import io.sentry.SentryOptions;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DebugMetaPropertiesApplier {
    @NotNull
    public static String DEBUG_META_PROPERTIES_FILENAME = "sentry-debug-meta.properties";

    public static void applyToOptions(@NotNull SentryOptions options, @Nullable Properties debugMetaProperties) {
        if (debugMetaProperties != null) {
            DebugMetaPropertiesApplier.applyProguardUuid(options, debugMetaProperties);
            DebugMetaPropertiesApplier.applyBundleIds(options, debugMetaProperties);
        }
    }

    private static void applyBundleIds(@NotNull SentryOptions options, @NotNull Properties debugMetaProperties) {
        if (options.getBundleIds().isEmpty()) {
            @Nullable String bundleIdStrings = debugMetaProperties.getProperty("io.sentry.bundle-ids");
            options.getLogger().log(SentryLevel.DEBUG, "Bundle IDs found: %s", bundleIdStrings);
            if (bundleIdStrings != null) {
                String[] bundleIds;
                for (String bundleId : bundleIds = bundleIdStrings.split(",", -1)) {
                    options.addBundleId(bundleId);
                }
            }
        }
    }

    private static void applyProguardUuid(@NotNull SentryOptions options, @NotNull Properties debugMetaProperties) {
        if (options.getProguardUuid() == null) {
            @Nullable String proguardUuid = debugMetaProperties.getProperty("io.sentry.ProguardUuids");
            options.getLogger().log(SentryLevel.DEBUG, "Proguard UUID found: %s", proguardUuid);
            options.setProguardUuid(proguardUuid);
        }
    }
}

