/*
 * Decompiled with CFR 0.152.
 */
package net.atlanticbb.tantlinger.i18n;

import java.io.File;
import java.io.FileFilter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;

public class I18n {
    private static final File LANG_PACK_DIR = new File(System.getProperty("user.dir"), "languages");
    private static final String DEFAULT_BUNDLE_NAME = "messages";
    private static final String MNEM_POSTFIX = ".mnemonic";
    public static final Properties BUNDLE_PROPS = new Properties();
    public static final Map I18NS = new HashMap();
    public static Locale locale = Locale.getDefault();
    private ResourceBundle bundle;
    private String _package;

    private I18n(String _package) {
        this._package = _package;
    }

    public String str(String key) {
        try {
            if (this.bundle == null) {
                this.bundle = this.createBundle(I18n.getLocale());
            }
            return this.bundle.getString(key);
        }
        catch (Exception ex) {
            return '!' + key + '!';
        }
    }

    public String str(String key, Locale locale) {
        try {
            return this.createBundle(locale).getString(key);
        }
        catch (Exception ex) {
            return '!' + key + '!';
        }
    }

    public char mnem(String key) {
        String s = this.str(key + MNEM_POSTFIX);
        if (s != null && s.length() > 0) {
            return s.charAt(0);
        }
        return '!';
    }

    public char mnem(String key, Locale loc) {
        String s = this.str(key + MNEM_POSTFIX, loc);
        if (s != null && s.length() > 0) {
            return s.charAt(0);
        }
        return '!';
    }

    private ResourceBundle createBundle(Locale loc) {
        String bun = I18n.getBundleForPackage(this._package);
        File[] packs = I18n.getAvailableLanguagePacks();
        if (packs != null && packs.length > 0) {
            URL[] urls = new URL[packs.length];
            try {
                for (int i = 0; i < urls.length; ++i) {
                    urls[i] = packs[i].toURL();
                }
                return ResourceBundle.getBundle(bun, loc, URLClassLoader.newInstance(urls));
            }
            catch (MalformedURLException muex) {
            }
            catch (MissingResourceException rex) {
                // empty catch block
            }
        }
        return ResourceBundle.getBundle(bun, loc);
    }

    public static I18n getInstance(String _package) {
        I18n i18n = (I18n)I18NS.get(_package);
        if (i18n == null) {
            i18n = new I18n(_package);
            I18NS.put(_package, i18n);
        }
        return i18n;
    }

    public static void setLocale(Locale loc) {
        locale = loc;
        for (I18n i18n : I18NS.values()) {
            i18n.bundle = null;
        }
    }

    public static void setLocale(String locStr) throws IllegalArgumentException {
        Locale loc = I18n.localeFromString(locStr);
        if (loc == null) {
            throw new IllegalArgumentException("The locale " + locStr + " was not properly formatted");
        }
        I18n.setLocale(loc);
    }

    public static Locale getLocale() {
        if (locale == null) {
            Locale.getDefault();
        }
        return locale;
    }

    private static String slashesToDots(String path) {
        StringBuffer sb = new StringBuffer();
        StringTokenizer st = new StringTokenizer(path, "/");
        while (st.hasMoreTokens()) {
            sb.append(".");
            sb.append(st.nextToken());
        }
        if (sb.toString().startsWith(".")) {
            sb.deleteCharAt(0);
        }
        return sb.toString();
    }

    private static String createBundleName(String bundlePackage, String bundleName) {
        StringBuffer sb = new StringBuffer(I18n.slashesToDots(bundlePackage));
        if (!sb.toString().endsWith(".")) {
            sb.append('.');
        }
        sb.append(bundleName);
        return sb.toString();
    }

    public static void setBundleForPackage(String _package, String bundle) {
        if (bundle == null) {
            BUNDLE_PROPS.remove(_package);
        } else {
            BUNDLE_PROPS.setProperty(_package, bundle);
        }
        I18n i18n = (I18n)I18NS.get(_package);
        if (i18n != null) {
            i18n.bundle = null;
        }
    }

    public static String getBundleForPackage(String _package) {
        String bun = BUNDLE_PROPS.getProperty(_package);
        if (bun == null) {
            bun = I18n.createBundleName(_package, DEFAULT_BUNDLE_NAME);
        }
        return bun;
    }

    public static File getLanguagePackDirectory() {
        return LANG_PACK_DIR;
    }

    public static File[] getAvailableLanguagePacks() {
        Locale[] locs = I18n.getAvailableLanguagePackLocales();
        ArrayList<File> packs = new ArrayList<File>();
        for (int i = 0; i < locs.length; ++i) {
            String name = locs[i].toString() + ".zip";
            File f = new File(LANG_PACK_DIR, name);
            if (!f.isFile() || !f.canRead()) continue;
            packs.add(f);
        }
        return packs.toArray(new File[packs.size()]);
    }

    public static Locale[] getAvailableLanguagePackLocales() {
        File[] packs;
        ArrayList<Locale> locs = new ArrayList<Locale>();
        File dir = I18n.getLanguagePackDirectory();
        if (dir.isDirectory() && dir.canRead() && (packs = dir.listFiles(new ZipFileFilter())) != null) {
            for (int i = 0; i < packs.length; ++i) {
                String locStr;
                Locale loc;
                String name = packs[i].getName();
                int p = name.lastIndexOf(".");
                if (p == -1 || (loc = I18n.localeFromString(locStr = name.substring(0, p))) == null) continue;
                locs.add(loc);
            }
        }
        return locs.toArray(new Locale[locs.size()]);
    }

    public static Locale localeFromString(String locStr) {
        String[] parts = locStr.split("_");
        if (parts.length > 0 || parts.length <= 3) {
            String lang = parts[0];
            String country = parts.length > 1 ? parts[1] : "";
            String varient = parts.length > 2 ? parts[2] : "";
            return new Locale(lang, country, varient);
        }
        return null;
    }

    private static class ZipFileFilter
    implements FileFilter {
        private ZipFileFilter() {
        }

        public boolean accept(File f) {
            String name;
            return f.isFile() && f.canRead() && (name = f.getName().toLowerCase()).endsWith(".zip");
        }
    }
}

