/*
 * Decompiled with CFR 0.152.
 */
package net.atlanticbb.tantlinger.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.atlanticbb.tantlinger.io.CopyMonitor;
import net.atlanticbb.tantlinger.io.FileCopyMonitor;

public class IOUtils {
    private static final int BUFFER_SIZE = 4096;
    private static final NullCopyMonitor nullMon = new NullCopyMonitor();

    private static void getDirectoryContents(List onlyFiles, File rootdir) {
        File[] list = rootdir.listFiles();
        for (int i = 0; i < list.length; ++i) {
            File eachFile = list[i];
            if (eachFile.isDirectory()) {
                IOUtils.getDirectoryContents(onlyFiles, eachFile);
                continue;
            }
            if (!eachFile.isFile()) continue;
            onlyFiles.add(eachFile);
        }
    }

    public static File[] getDirectoryContents(File rootdir) {
        ArrayList list = new ArrayList();
        IOUtils.getDirectoryContents(list, rootdir);
        return list.toArray(new File[list.size()]);
    }

    public static String sanitize(String x) {
        return x.replaceAll("[^\\w\\.\\-\\:\\;\\#\\_]", "_");
    }

    public static String getExtension(File f) {
        String name = f.getName();
        int i = name.lastIndexOf(".");
        if (i == -1 || i == name.length() - 1) {
            return "";
        }
        return name.substring(i + 1, name.length());
    }

    public static String getName(File f) {
        String name = f.getName();
        int i = name.lastIndexOf(".");
        if (i == -1) {
            return name;
        }
        return name.substring(0, i);
    }

    public static File createUniqueFile(File f) {
        while (f.exists()) {
            String ext = IOUtils.getExtension(f);
            String name = IOUtils.getName(f);
            int dashPos = name.lastIndexOf(45);
            if (dashPos == -1) {
                name = name + "-1";
            } else {
                String num = name.substring(dashPos + 1, name.length());
                String temp = name.substring(0, dashPos);
                try {
                    int cur = Integer.parseInt(num) + 1;
                    name = temp + "-" + cur;
                }
                catch (NumberFormatException nfe) {
                    name = name + "-1";
                }
            }
            String uniqueName = name;
            if (!ext.equals("")) {
                uniqueName = uniqueName + "." + ext;
            }
            String parent = "";
            if (f.getParent() != null) {
                parent = f.getParent();
            }
            f = new File(parent, uniqueName);
        }
        return f;
    }

    public static void copy(Reader src, Writer dst) throws IOException {
        char[] buffer = new char[4096];
        int n = 0;
        while ((n = src.read(buffer)) != -1) {
            dst.write(buffer, 0, n);
        }
    }

    public static void copy(InputStream src, OutputStream dst) throws IOException {
        IOUtils.copy(src, dst, (CopyMonitor)nullMon);
    }

    public static void copy(InputStream src, OutputStream dst, CopyMonitor mon) throws IOException {
        byte[] buffer = new byte[4096];
        int n = 0;
        while ((n = src.read(buffer)) != -1 && !mon.isCopyAborted()) {
            dst.write(buffer, 0, n);
            mon.bytesCopied(n);
        }
    }

    public static void copy(File src, File dst) throws FileNotFoundException, IOException {
        IOUtils.copy(src, dst, (FileCopyMonitor)nullMon);
    }

    public static void copy(File src, File dst, boolean overwrite) throws FileNotFoundException, IOException {
        IOUtils.copy(src, dst, (FileCopyMonitor)nullMon, overwrite);
    }

    public static void copy(File src, File dst, FileCopyMonitor mon) throws FileNotFoundException, IOException {
        IOUtils.copy(src, dst, mon, true);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void copy(File src, File dst, FileCopyMonitor mon, boolean overwrite) throws FileNotFoundException, IOException {
        if (!overwrite) {
            dst = IOUtils.createUniqueFile(dst);
        }
        mon.copyingFile(src);
        FileInputStream in = null;
        FileOutputStream out = null;
        try {
            in = new FileInputStream(src);
            out = new FileOutputStream(dst);
            IOUtils.copy(in, out, (CopyMonitor)mon);
        }
        catch (FileNotFoundException nfe) {
            try {
                throw nfe;
                catch (IOException ioe) {
                    throw ioe;
                }
            }
            catch (Throwable throwable) {
                IOUtils.close(in);
                IOUtils.close(out);
                throw throwable;
            }
        }
        IOUtils.close(in);
        IOUtils.close(out);
    }

    public static void copy(String srcPath, String dstPath) throws FileNotFoundException, IOException {
        IOUtils.copy(new File(srcPath), new File(dstPath));
    }

    public static void copy(String srcPath, String dstPath, FileCopyMonitor mon) throws FileNotFoundException, IOException {
        IOUtils.copy(new File(srcPath), new File(dstPath), mon);
    }

    public static void copy(String srcPath, String dstPath, boolean overwrite) throws FileNotFoundException, IOException {
        IOUtils.copy(new File(srcPath), new File(dstPath), overwrite);
    }

    public static void copy(String srcPath, String dstPath, FileCopyMonitor mon, boolean overwrite) throws FileNotFoundException, IOException {
        IOUtils.copy(new File(srcPath), new File(dstPath), mon, overwrite);
    }

    public static void copyFiles(File src, File dest) throws IOException, FileNotFoundException {
        IOUtils.copyFiles(src, dest, nullMon);
    }

    public static void copyFiles(File src, File dest, FileCopyMonitor mon) throws FileNotFoundException, IOException {
        IOUtils.copyFilesRecursively(src, dest, mon);
    }

    private static void copyFilesRecursively(File src, File dest, FileCopyMonitor mon) throws FileNotFoundException, IOException {
        if (mon.isCopyAborted()) {
            return;
        }
        if (!src.exists()) {
            throw new FileNotFoundException("File not found:" + src);
        }
        if (src.isDirectory()) {
            if (!dest.exists()) {
                dest.mkdirs();
            }
            Object[] list = src.list();
            Arrays.sort(list);
            for (int i = 0; i < list.length; ++i) {
                IOUtils.copyFilesRecursively(new File(src, (String)list[i]), new File(dest, (String)list[i]), mon);
            }
        } else {
            IOUtils.copy(src, dest, mon, true);
        }
    }

    public static long getTotalBytes(File file) {
        long bytes = 0L;
        if (file.isDirectory()) {
            File[] f = file.listFiles();
            for (int i = 0; i < f.length; ++i) {
                bytes += IOUtils.getTotalBytes(f[i]);
            }
        } else {
            bytes = file.length();
        }
        return bytes;
    }

    public static String read(InputStream input) throws IOException {
        return IOUtils.read(new InputStreamReader(input));
    }

    public static String read(File file) throws FileNotFoundException, IOException {
        return IOUtils.read(new FileReader(file));
    }

    public static String read(Reader input) throws IOException {
        int ch;
        BufferedReader reader = new BufferedReader(input);
        StringBuffer sb = new StringBuffer();
        while ((ch = reader.read()) != -1) {
            sb.append((char)ch);
        }
        IOUtils.close(reader);
        return sb.toString();
    }

    public static void write(File file, String str) throws FileNotFoundException, IOException {
        PrintWriter out = new PrintWriter(new FileOutputStream(file));
        out.print(str);
        IOUtils.close(out);
    }

    public static void write(File file, InputStream input) throws FileNotFoundException, IOException {
        int ch;
        BufferedInputStream in = new BufferedInputStream(input);
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));
        while ((ch = ((InputStream)in).read()) != -1) {
            ((OutputStream)out).write(ch);
        }
        IOUtils.close(in);
        IOUtils.close(out);
    }

    public static boolean deleteRecursively(File file) {
        if (file.isDirectory()) {
            File[] children = file.listFiles();
            for (int i = 0; i < children.length; ++i) {
                boolean success = IOUtils.deleteRecursively(children[i]);
                if (success) continue;
                return false;
            }
        }
        return file.delete();
    }

    public static void close(InputStream c) {
        if (c != null) {
            try {
                c.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void close(OutputStream c) {
        if (c != null) {
            try {
                c.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void close(Reader c) {
        if (c != null) {
            try {
                c.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void close(Writer c) {
        if (c != null) {
            try {
                c.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static class NullCopyMonitor
    implements FileCopyMonitor {
        private NullCopyMonitor() {
        }

        public void bytesCopied(int numBytes) {
        }

        public void copyingFile(File f) {
        }

        public boolean isCopyAborted() {
            return false;
        }
    }
}

