/*
 * Decompiled with CFR 0.152.
 */
package net.atlanticbb.tantlinger.print;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.util.ArrayList;
import javax.print.PrintService;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.text.Position;
import javax.swing.text.View;
import net.atlanticbb.tantlinger.print.PrintApp;

public class EditorPanePrinter
extends JPanel
implements Pageable,
Printable {
    JEditorPane sourcePane;
    Paper paper;
    Insets margins;
    ArrayList<PagePanel> pages;
    int pageWidth;
    int pageHeight;
    View rootView;
    public static int PAGE_SHIFT = 20;
    PageFormat pageFormat;

    public EditorPanePrinter(JEditorPane pane, Paper paper, Insets margins) {
        this.initData(pane, paper, margins);
    }

    public void initData(JEditorPane pane, Paper paper, Insets margins) {
        JEditorPane tmpPane = new JEditorPane();
        tmpPane.setEditorKit(pane.getEditorKit());
        tmpPane.setContentType(pane.getContentType());
        tmpPane.setText(pane.getText());
        this.sourcePane = tmpPane;
        this.paper = paper;
        this.margins = margins;
        this.pageWidth = (int)paper.getWidth();
        this.pageHeight = (int)paper.getHeight();
        this.pageFormat = new PageFormat();
        paper.setImageableArea(0.0, 0.0, paper.getWidth(), paper.getHeight());
        this.pageFormat.setPaper(paper);
        this.doPagesLayout();
    }

    public void doPagesLayout() {
        this.setLayout(null);
        this.removeAll();
        this.rootView = this.sourcePane.getUI().getRootView(this.sourcePane);
        this.sourcePane.setSize(this.pageWidth - this.margins.top - this.margins.bottom, Integer.MAX_VALUE);
        Dimension d = this.sourcePane.getPreferredSize();
        this.sourcePane.setSize(this.pageWidth - this.margins.top - this.margins.bottom, d.height);
        this.calculatePageInfo();
        int count = this.pages.size();
        this.setPreferredSize(new Dimension(this.pageWidth * 2 + 50, PAGE_SHIFT + count * (this.pageHeight + PAGE_SHIFT)));
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        AffineTransform old = ((Graphics2D)g).getTransform();
        ((Graphics2D)g).setTransform(old);
    }

    protected void calculatePageInfo() {
        Shape pageShape;
        this.pages = new ArrayList();
        int startY = 0;
        int endPageY = this.getEndPageY(startY);
        while (startY + this.pageHeight - this.margins.top - this.margins.bottom < this.sourcePane.getHeight()) {
            pageShape = EditorPanePrinter.getPageShape(startY, this.pageWidth - this.margins.left - this.margins.right, this.pageHeight - this.margins.top - this.margins.bottom, this.sourcePane);
            this.pages.add(new PagePanel(startY, endPageY, pageShape));
            startY = endPageY;
            endPageY = this.getEndPageY(startY);
        }
        pageShape = EditorPanePrinter.getPageShape(startY, this.pageWidth - this.margins.left - this.margins.right, this.pageHeight - this.margins.top - this.margins.bottom, this.sourcePane);
        this.pages.add(new PagePanel(startY, endPageY, pageShape));
        int count = 0;
        for (PagePanel pi : this.pages) {
            this.add(pi);
            pi.setLocation(PAGE_SHIFT, PAGE_SHIFT + count * (this.pageHeight + PAGE_SHIFT));
            ++count;
        }
    }

    protected int getEndPageY(int startY) {
        int desiredY;
        int realY = desiredY = startY + this.pageHeight - this.margins.top - this.margins.bottom;
        for (int x = 1; x < this.pageWidth; ++x) {
            View v = this.getLeafViewAtPoint(new Point(x, realY), this.rootView);
            if (v == null) continue;
            Rectangle alloc = PrintApp.getAllocation(v, this.sourcePane).getBounds();
            if (alloc.height > this.pageHeight - this.margins.top - this.margins.bottom || alloc.y + alloc.height <= desiredY) continue;
            realY = Math.min(realY, alloc.y);
        }
        return realY;
    }

    protected View getLeafViewAtPoint(Point p, View root) {
        return EditorPanePrinter.getLeafViewAtPoint(p, root, this.sourcePane);
    }

    public static View getLeafViewAtPoint(Point p, View root, JEditorPane sourcePane) {
        int pos = sourcePane.viewToModel(p);
        View v = sourcePane.getUI().getRootView(sourcePane);
        while (v.getViewCount() > 0) {
            int i = v.getViewIndex(pos, Position.Bias.Forward);
            v = v.getView(i);
        }
        Shape alloc = PrintApp.getAllocation(root, sourcePane);
        if (alloc.contains(p)) {
            return v;
        }
        return null;
    }

    public static Shape getPageShape(int pageStartY, int pageWidth, int pageHeight, JEditorPane sourcePane) {
        Rectangle r;
        Rectangle alloc;
        View v;
        int x;
        Area result = new Area(new Rectangle(0, 0, pageWidth, pageHeight));
        View rootView = sourcePane.getUI().getRootView(sourcePane);
        Rectangle last = new Rectangle();
        for (x = 1; x < pageWidth; ++x) {
            v = EditorPanePrinter.getLeafViewAtPoint(new Point(x, pageStartY), rootView, sourcePane);
            if (v == null) continue;
            alloc = PrintApp.getAllocation(v, sourcePane).getBounds();
            if (alloc.y < pageStartY && alloc.y + alloc.height > pageStartY && !alloc.equals(last)) {
                r = new Rectangle(alloc);
                r.y -= pageStartY;
                result.subtract(new Area(r));
            }
            last = alloc;
        }
        last = new Rectangle();
        for (x = 1; x < pageWidth; ++x) {
            v = EditorPanePrinter.getLeafViewAtPoint(new Point(x, pageStartY + pageHeight), rootView, sourcePane);
            if (v == null) continue;
            alloc = PrintApp.getAllocation(v, sourcePane).getBounds();
            if (alloc.y < pageStartY + pageHeight && alloc.y + alloc.height > pageStartY + pageHeight && !alloc.equals(last)) {
                r = new Rectangle(alloc);
                r.y -= pageStartY;
                result.subtract(new Area(r));
            }
            last = alloc;
        }
        return result;
    }

    public int getNumberOfPages() {
        return this.pages.size();
    }

    public PageFormat getPageFormat(int pageIndex) throws IndexOutOfBoundsException {
        return this.pageFormat;
    }

    public Printable getPrintable(int pageIndex) throws IndexOutOfBoundsException {
        return this;
    }

    public int print(Graphics g, PageFormat pageFormat, int pageIndex) throws PrinterException {
        if (pageIndex < this.pages.size()) {
            pageFormat.getPaper().setImageableArea(0.0, 0.0, this.paper.getWidth(), this.paper.getHeight());
            this.pages.get((int)pageIndex).isPrinting = true;
            this.pages.get(pageIndex).paint(g);
            this.pages.get((int)pageIndex).isPrinting = false;
            return 0;
        }
        return 1;
    }

    public void print() {
        this.print((PrintService)null);
    }

    public void print(PrintService ps) {
        try {
            PrinterJob pj = PrinterJob.getPrinterJob();
            JFrame tmp = null;
            if (this.getParent() == null) {
                tmp = new JFrame();
                tmp.getContentPane().add(new JScrollPane(this));
                tmp.pack();
                tmp.setVisible(false);
            }
            pj.setPageable(this);
            if (ps != null) {
                pj.setPrintService(ps);
            }
            pj.print();
            if (tmp != null) {
                tmp.dispose();
            }
        }
        catch (PrinterException e1) {
            e1.printStackTrace();
        }
    }

    class PagePanel
    extends JPanel {
        int pageStartY;
        int pageEndY;
        Shape pageShape;
        boolean isPrinting = false;
        JPanel innerPage = new JPanel(){

            public void paintComponent(Graphics g) {
                super.paintComponent(g);
                AffineTransform old = ((Graphics2D)g).getTransform();
                Shape oldClip = g.getClip();
                Area newClip = new Area(oldClip);
                if (PagePanel.this.isPrinting) {
                    newClip = new Area(PagePanel.this.pageShape);
                } else {
                    newClip.intersect(new Area(PagePanel.this.pageShape));
                }
                g.setClip(newClip);
                g.translate(0, -PagePanel.this.pageStartY);
                EditorPanePrinter.this.sourcePane.paint(g);
                for (Component c : EditorPanePrinter.this.sourcePane.getComponents()) {
                    AffineTransform tmp = ((Graphics2D)g).getTransform();
                    g.translate(c.getX(), c.getY());
                    ((Container)c).getComponent(0).paint(g);
                    ((Graphics2D)g).setTransform(tmp);
                }
                ((Graphics2D)g).setTransform(old);
                g.setClip(oldClip);
            }
        };

        public PagePanel() {
            this(0, 0, null);
        }

        public PagePanel(int pageStartY, int pageEndY, Shape pageShape) {
            this.pageStartY = pageStartY;
            this.pageEndY = pageEndY;
            this.pageShape = pageShape;
            this.setSize(EditorPanePrinter.this.pageWidth, EditorPanePrinter.this.pageHeight);
            this.setBackground(Color.white);
            this.setLayout(null);
            this.add(this.innerPage);
            this.innerPage.setBounds(EditorPanePrinter.this.margins.left, EditorPanePrinter.this.margins.top, EditorPanePrinter.this.pageWidth - EditorPanePrinter.this.margins.left - EditorPanePrinter.this.margins.right, EditorPanePrinter.this.pageHeight - EditorPanePrinter.this.margins.top - EditorPanePrinter.this.margins.bottom);
        }

        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            g.setColor(Color.black);
            g.drawRect(0, 0, this.getWidth() - 2, this.getHeight() - 2);
        }
    }
}

