/*
 * Decompiled with CFR 0.152.
 */
package net.atlanticbb.tantlinger.print;

import java.awt.Component;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.Paper;
import java.awt.print.PrinterJob;
import javax.print.PrintService;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import net.atlanticbb.tantlinger.print.EditorPanePrinter;
import net.atlanticbb.tantlinger.print.PageSetupPanel;

public class PreviewDialog
extends JDialog {
    EditorPanePrinter pnlPreview;
    PageSetupPanel pnlPageSetupPanel;
    JButton btnPrint = new JButton("Imprimir");
    JComboBox printers = new JComboBox();
    String source;

    public PreviewDialog(JFrame parent, JEditorPane src) {
        super((Frame)parent, "Visualizar");
        Paper p = new Paper();
        p.setImageableArea(0.0, 0.0, p.getWidth(), p.getHeight());
        this.pnlPreview = new EditorPanePrinter(src, p, new Insets(18, 18, 18, 18));
        this.pnlPageSetupPanel = new PageSetupPanel();
        this.getContentPane().add((Component)new JScrollPane(this.pnlPreview), "Center");
        this.getContentPane().add(this.getPanelPrint(), "North");
        this.getContentPane().add((Component)this.pnlPageSetupPanel, "East");
        this.initListeners();
        this.setSize(1000, 800);
        this.setLocationRelativeTo(null);
        this.setDefaultCloseOperation(2);
    }

    protected void initListeners() {
        this.pnlPageSetupPanel.btnApply.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PreviewDialog.this.pnlPreview = new EditorPanePrinter(PreviewDialog.this.pnlPreview.sourcePane, PreviewDialog.this.pnlPageSetupPanel.getPaper(), PreviewDialog.this.pnlPageSetupPanel.getMargins());
                PreviewDialog.this.getContentPane().removeAll();
                PreviewDialog.this.getContentPane().add((Component)new JScrollPane(PreviewDialog.this.pnlPreview), "Center");
                PreviewDialog.this.getContentPane().add(PreviewDialog.this.getPanelPrint(), "North");
                PreviewDialog.this.getContentPane().add((Component)PreviewDialog.this.pnlPageSetupPanel, "East");
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        PreviewDialog.this.getContentPane().invalidate();
                        PreviewDialog.this.getContentPane().validate();
                        PreviewDialog.this.getContentPane().repaint();
                    }
                });
            }
        });
        this.btnPrint.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (PreviewDialog.this.printers.getSelectedItem() != null) {
                    PreviewDialog.this.pnlPreview.print((PrintService)PreviewDialog.this.printers.getSelectedItem());
                    JOptionPane.showMessageDialog(null, "O documento foi enviado a impressora.");
                } else {
                    JOptionPane.showMessageDialog(null, "Primeiro selecione uma impressora.");
                }
            }
        });
    }

    private Component getPanelPrint() {
        JPanel j = new JPanel();
        this.printers.setModel(this.getModel());
        j.add((Component)this.printers, "East");
        j.add((Component)this.btnPrint, "West");
        return j;
    }

    private DefaultComboBoxModel getModel() {
        PrintService[] p = PrinterJob.lookupPrintServices();
        return new DefaultComboBoxModel<PrintService>(p);
    }
}

