/*
 * Decompiled with CFR 0.152.
 */
package net.atlanticbb.tantlinger.shef;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.Document;
import javax.swing.text.DocumentFilter;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.undo.UndoManager;
import net.atlanticbb.tantlinger.i18n.I18n;
import net.atlanticbb.tantlinger.ui.DefaultAction;
import net.atlanticbb.tantlinger.ui.UIUtils;
import net.atlanticbb.tantlinger.ui.text.CompoundUndoManager;
import net.atlanticbb.tantlinger.ui.text.Entities;
import net.atlanticbb.tantlinger.ui.text.HTMLUtils;
import net.atlanticbb.tantlinger.ui.text.IndentationFilter;
import net.atlanticbb.tantlinger.ui.text.SourceCodeEditor;
import net.atlanticbb.tantlinger.ui.text.WysiwygHTMLEditorKit;
import net.atlanticbb.tantlinger.ui.text.actions.ClearStylesAction;
import net.atlanticbb.tantlinger.ui.text.actions.FindReplaceAction;
import net.atlanticbb.tantlinger.ui.text.actions.HTMLEditorActionFactory;
import net.atlanticbb.tantlinger.ui.text.actions.HTMLElementPropertiesAction;
import net.atlanticbb.tantlinger.ui.text.actions.HTMLFontAction;
import net.atlanticbb.tantlinger.ui.text.actions.HTMLFontColorAction;
import net.atlanticbb.tantlinger.ui.text.actions.HTMLHorizontalRuleAction;
import net.atlanticbb.tantlinger.ui.text.actions.HTMLImageAction;
import net.atlanticbb.tantlinger.ui.text.actions.HTMLInlineAction;
import net.atlanticbb.tantlinger.ui.text.actions.HTMLLineBreakAction;
import net.atlanticbb.tantlinger.ui.text.actions.HTMLLinkAction;
import net.atlanticbb.tantlinger.ui.text.actions.HTMLTableAction;
import net.atlanticbb.tantlinger.ui.text.actions.SpecialCharAction;
import novaworx.syntax.SyntaxFactory;
import novaworx.textpane.SyntaxDocument;
import novaworx.textpane.SyntaxGutter;
import novaworx.textpane.SyntaxGutterBase;
import novaworx.textpane.SyntaxTextPane;
import org.bushe.swing.action.ActionList;
import org.bushe.swing.action.ActionUIFactory;

public class HTMLEditorPane
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final I18n i18n = I18n.getInstance("net.atlanticbb.tantlinger.shef");
    private static final String[] INVALID_TAGS = new String[]{"html", "head", "body", "title"};
    private JEditorPane wysEditor;
    private SourceCodeEditor srcEditor;
    private JEditorPane focusedEditor;
    private JComboBox fontFamilyCombo;
    private JComboBox paragraphCombo;
    private JTabbedPane tabs;
    private JToolBar formatToolBar;
    private JMenu editMenu;
    private JMenu formatMenu;
    private JMenu insertMenu;
    private JPopupMenu wysPopupMenu;
    private JPopupMenu srcPopupMenu;
    private ActionList actionList;
    private FocusListener focusHandler = new FocusHandler();
    private DocumentListener textChangedHandler = new TextChangedHandler();
    private ActionListener fontChangeHandler = new FontChangeHandler();
    private ActionListener paragraphComboHandler = new ParagraphComboHandler();
    private CaretListener caretHandler = new CaretHandler();
    private MouseListener popupHandler = new PopupHandler();
    private boolean isWysTextChanged;

    public HTMLEditorPane() {
        this.initUI();
    }

    public void setCaretPosition(int pos) {
        if (this.tabs.getSelectedIndex() == 0) {
            this.getWysEditor().setCaretPosition(pos);
            this.getWysEditor().requestFocusInWindow();
        } else if (this.tabs.getSelectedIndex() == 1) {
            this.srcEditor.setCaretPosition(pos);
            this.srcEditor.requestFocusInWindow();
        }
    }

    public void setSelectedTab(int i) {
        this.tabs.setSelectedIndex(i);
    }

    private void initUI() {
        this.createEditorTabs();
        this.createEditorActions();
        this.setLayout(new BorderLayout());
        this.add((Component)this.formatToolBar, "North");
        this.add((Component)this.tabs, "Center");
    }

    public JMenu getEditMenu() {
        return this.editMenu;
    }

    public JMenu getFormatMenu() {
        return this.formatMenu;
    }

    public JMenu getInsertMenu() {
        return this.insertMenu;
    }

    private void createEditorActions() {
        this.actionList = new ActionList((Object)"editor-actions");
        ActionList paraActions = new ActionList((Object)"paraActions");
        ActionList fontSizeActions = new ActionList((Object)"fontSizeActions");
        ActionList editActions = HTMLEditorActionFactory.createEditActionList();
        HTMLElementPropertiesAction objectPropertiesAction = new HTMLElementPropertiesAction();
        this.wysPopupMenu = ActionUIFactory.getInstance().createPopupMenu(editActions);
        this.wysPopupMenu.addSeparator();
        this.wysPopupMenu.add((Action)((Object)objectPropertiesAction));
        this.srcPopupMenu = ActionUIFactory.getInstance().createPopupMenu(editActions);
        JMenu fileMenu = new JMenu(i18n.str("file"));
        ActionList lst = new ActionList((Object)"edits");
        DefaultAction act = new ChangeTabAction(0);
        lst.add((Object)act);
        act = new ChangeTabAction(1);
        lst.add((Object)act);
        lst.add(null);
        lst.addAll((Collection)editActions);
        lst.add(null);
        lst.add((Object)new FindReplaceAction(false));
        this.actionList.addAll((Collection)lst);
        this.editMenu = ActionUIFactory.getInstance().createMenu(lst);
        this.editMenu.setText(i18n.str("edit"));
        this.formatMenu = new JMenu(i18n.str("format"));
        lst = HTMLEditorActionFactory.createFontSizeActionList();
        this.actionList.addAll((Collection)lst);
        this.formatMenu.add(this.createMenu(lst, i18n.str("size")));
        fontSizeActions.addAll((Collection)lst);
        lst = HTMLEditorActionFactory.createInlineActionList();
        this.actionList.addAll((Collection)lst);
        this.formatMenu.add(this.createMenu(lst, i18n.str("style")));
        act = new HTMLFontColorAction();
        this.actionList.add((Object)act);
        this.formatMenu.add((Action)((Object)act));
        act = new HTMLFontAction();
        this.actionList.add((Object)act);
        this.formatMenu.add((Action)((Object)act));
        act = new ClearStylesAction();
        this.actionList.add((Object)act);
        this.formatMenu.add((Action)((Object)act));
        this.formatMenu.addSeparator();
        lst = HTMLEditorActionFactory.createBlockElementActionList();
        this.actionList.addAll((Collection)lst);
        this.formatMenu.add(this.createMenu(lst, i18n.str("paragraph")));
        paraActions.addAll((Collection)lst);
        lst = HTMLEditorActionFactory.createListElementActionList();
        this.actionList.addAll((Collection)lst);
        this.formatMenu.add(this.createMenu(lst, i18n.str("list")));
        this.formatMenu.addSeparator();
        paraActions.addAll((Collection)lst);
        lst = HTMLEditorActionFactory.createAlignActionList();
        this.actionList.addAll((Collection)lst);
        this.formatMenu.add(this.createMenu(lst, i18n.str("align")));
        JMenu tableMenu = new JMenu(i18n.str("table"));
        lst = HTMLEditorActionFactory.createInsertTableElementActionList();
        this.actionList.addAll((Collection)lst);
        tableMenu.add(this.createMenu(lst, i18n.str("insert")));
        lst = HTMLEditorActionFactory.createDeleteTableElementActionList();
        this.actionList.addAll((Collection)lst);
        tableMenu.add(this.createMenu(lst, i18n.str("delete")));
        this.formatMenu.add(tableMenu);
        this.formatMenu.addSeparator();
        this.actionList.add((Object)objectPropertiesAction);
        this.formatMenu.add((Action)((Object)objectPropertiesAction));
        this.insertMenu = new JMenu(i18n.str("insert"));
        act = new HTMLLinkAction();
        this.actionList.add((Object)act);
        this.insertMenu.add((Action)((Object)act));
        act = new HTMLImageAction();
        this.actionList.add((Object)act);
        this.insertMenu.add((Action)((Object)act));
        act = new HTMLTableAction();
        this.actionList.add((Object)act);
        this.insertMenu.add((Action)((Object)act));
        this.insertMenu.addSeparator();
        act = new HTMLLineBreakAction();
        this.actionList.add((Object)act);
        this.insertMenu.add((Action)((Object)act));
        act = new HTMLHorizontalRuleAction();
        this.actionList.add((Object)act);
        this.insertMenu.add((Action)((Object)act));
        act = new SpecialCharAction();
        this.actionList.add((Object)act);
        this.insertMenu.add((Action)((Object)act));
        this.createFormatToolBar(paraActions, fontSizeActions);
    }

    private void createFormatToolBar(ActionList blockActs, ActionList fontSizeActs) {
        this.formatToolBar = new JToolBar();
        this.formatToolBar.setFloatable(false);
        this.formatToolBar.setFocusable(false);
        Font comboFont = new Font("Dialog", 0, 12);
        PropertyChangeListener propLst = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("selected") && evt.getNewValue().equals(Boolean.TRUE)) {
                    HTMLEditorPane.this.paragraphCombo.removeActionListener(HTMLEditorPane.this.paragraphComboHandler);
                    HTMLEditorPane.this.paragraphCombo.setSelectedItem(evt.getSource());
                    HTMLEditorPane.this.paragraphCombo.addActionListener(HTMLEditorPane.this.paragraphComboHandler);
                }
            }
        };
        for (Object o : blockActs) {
            if (!(o instanceof DefaultAction)) continue;
            ((DefaultAction)((Object)o)).addPropertyChangeListener(propLst);
        }
        this.paragraphCombo = new JComboBox<Action>(this.toArray(blockActs));
        this.paragraphCombo.setPreferredSize(new Dimension(120, 22));
        this.paragraphCombo.setMinimumSize(new Dimension(120, 22));
        this.paragraphCombo.setMaximumSize(new Dimension(120, 22));
        this.paragraphCombo.setFont(comboFont);
        this.paragraphCombo.addActionListener(this.paragraphComboHandler);
        this.paragraphCombo.setRenderer(new ParagraphComboRenderer());
        this.formatToolBar.add(this.paragraphCombo);
        this.formatToolBar.addSeparator();
        Vector<String> fonts = new Vector<String>();
        fonts.add("Default");
        fonts.add("serif");
        fonts.add("sans-serif");
        fonts.add("monospaced");
        GraphicsEnvironment gEnv = GraphicsEnvironment.getLocalGraphicsEnvironment();
        fonts.addAll(Arrays.asList(gEnv.getAvailableFontFamilyNames()));
        this.fontFamilyCombo = new JComboBox(fonts);
        this.fontFamilyCombo.setPreferredSize(new Dimension(150, 22));
        this.fontFamilyCombo.setMinimumSize(new Dimension(150, 22));
        this.fontFamilyCombo.setMaximumSize(new Dimension(150, 22));
        this.fontFamilyCombo.setFont(comboFont);
        this.fontFamilyCombo.addActionListener(this.fontChangeHandler);
        this.formatToolBar.add(this.fontFamilyCombo);
        final JButton fontSizeButton = new JButton(UIUtils.getIcon("resources/images/x16/", "fontsize.png"));
        final JPopupMenu sizePopup = ActionUIFactory.getInstance().createPopupMenu(fontSizeActs);
        ActionListener al = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                sizePopup.show(fontSizeButton, 0, fontSizeButton.getHeight());
            }
        };
        fontSizeButton.addActionListener(al);
        this.configToolbarButton(fontSizeButton);
        this.formatToolBar.add(fontSizeButton);
        Object act2 = new HTMLFontColorAction();
        this.actionList.add(act2);
        this.addToToolBar(this.formatToolBar, (Action)act2);
        this.formatToolBar.addSeparator();
        act2 = new HTMLInlineAction(6);
        act2.putValue("BUTTON_TYPE", "toggle");
        this.actionList.add(act2);
        this.addToToolBar(this.formatToolBar, (Action)act2);
        act2 = new HTMLInlineAction(7);
        act2.putValue("BUTTON_TYPE", "toggle");
        this.actionList.add(act2);
        this.addToToolBar(this.formatToolBar, (Action)act2);
        act2 = new HTMLInlineAction(8);
        act2.putValue("BUTTON_TYPE", "toggle");
        this.actionList.add(act2);
        this.addToToolBar(this.formatToolBar, (Action)act2);
        this.formatToolBar.addSeparator();
        ActionList alst = HTMLEditorActionFactory.createListElementActionList();
        for (Object act2 : alst) {
            act2.putValue("BUTTON_TYPE", "toggle");
            this.actionList.add(act2);
            this.addToToolBar(this.formatToolBar, (Action)act2);
        }
        this.formatToolBar.addSeparator();
        alst = HTMLEditorActionFactory.createAlignActionList();
        for (Object act2 : alst) {
            act2.putValue("BUTTON_TYPE", "toggle");
            this.actionList.add(act2);
            this.addToToolBar(this.formatToolBar, (Action)act2);
        }
        this.formatToolBar.addSeparator();
        act2 = new HTMLLinkAction();
        this.actionList.add(act2);
        this.addToToolBar(this.formatToolBar, (Action)act2);
        act2 = new HTMLImageAction();
        this.actionList.add(act2);
        this.addToToolBar(this.formatToolBar, (Action)act2);
        act2 = new HTMLTableAction();
        this.actionList.add(act2);
        this.addToToolBar(this.formatToolBar, (Action)act2);
    }

    private void addToToolBar(JToolBar toolbar, Action act) {
        AbstractButton button = ActionUIFactory.getInstance().createButton(act);
        this.configToolbarButton(button);
        toolbar.add(button);
    }

    private Action[] toArray(ActionList lst) {
        ArrayList acts = new ArrayList();
        for (Object v : lst) {
            if (v == null || !(v instanceof Action)) continue;
            acts.add(v);
        }
        return acts.toArray(new Action[acts.size()]);
    }

    private void configToolbarButton(AbstractButton button) {
        button.setText(null);
        button.setMnemonic(0);
        button.setMargin(new Insets(1, 1, 1, 1));
        button.setMaximumSize(new Dimension(22, 22));
        button.setMinimumSize(new Dimension(22, 22));
        button.setPreferredSize(new Dimension(22, 22));
        button.setFocusable(false);
        button.setFocusPainted(false);
        Action a = button.getAction();
        if (a != null) {
            button.setToolTipText(a.getValue("Name").toString());
        }
    }

    private JMenu createMenu(ActionList lst, String menuName) {
        JMenu m = ActionUIFactory.getInstance().createMenu(lst);
        m.setText(menuName);
        return m;
    }

    private void createEditorTabs() {
        this.tabs = new JTabbedPane(3);
        this.wysEditor = this.createWysiwygEditor();
        this.srcEditor = this.createSourceEditor();
        this.tabs.addTab("Edit", new JScrollPane(this.getWysEditor()));
        JScrollPane scrollPane = new JScrollPane((Component)((Object)this.srcEditor));
        SyntaxGutter gutter = new SyntaxGutter((SyntaxTextPane)this.srcEditor);
        SyntaxGutterBase gutterBase = new SyntaxGutterBase(gutter);
        scrollPane.setRowHeaderView((Component)gutter);
        scrollPane.setCorner("LOWER_LEFT_CORNER", (Component)gutterBase);
        this.tabs.addTab("HTML", scrollPane);
        this.tabs.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                HTMLEditorPane.this.updateEditView();
            }
        });
    }

    private SourceCodeEditor createSourceEditor() {
        SourceCodeEditor ed = new SourceCodeEditor();
        SyntaxDocument doc = new SyntaxDocument();
        doc.setSyntax(SyntaxFactory.getSyntax((String)"html"));
        CompoundUndoManager cuh = new CompoundUndoManager((Document)doc, new UndoManager());
        doc.addUndoableEditListener((UndoableEditListener)cuh);
        doc.setDocumentFilter((DocumentFilter)new IndentationFilter());
        doc.addDocumentListener(this.textChangedHandler);
        ed.setDocument((Document)doc);
        ed.addFocusListener(this.focusHandler);
        ed.addCaretListener(this.caretHandler);
        ed.addMouseListener(this.popupHandler);
        return ed;
    }

    private JEditorPane createWysiwygEditor() {
        JEditorPane ed = new JEditorPane();
        ed.setEditorKitForContentType("text/html", new WysiwygHTMLEditorKit());
        ed.setContentType("text/html");
        this.insertHTML(ed, "<p></p>", 0);
        ed.addCaretListener(this.caretHandler);
        ed.addFocusListener(this.focusHandler);
        ed.addMouseListener(this.popupHandler);
        HTMLDocument document = (HTMLDocument)ed.getDocument();
        CompoundUndoManager cuh = new CompoundUndoManager(document, new UndoManager());
        document.addUndoableEditListener(cuh);
        document.addDocumentListener(this.textChangedHandler);
        return ed;
    }

    private void insertHTML(JEditorPane editor, String html, int location) {
        try {
            HTMLEditorKit kit = (HTMLEditorKit)editor.getEditorKit();
            Document doc = editor.getDocument();
            StringReader reader = new StringReader(HTMLUtils.jEditorPaneizeHTML(html));
            kit.read(reader, doc, location);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void updateEditView() {
        if (this.tabs.getSelectedIndex() == 0) {
            String topText = this.removeInvalidTags(this.srcEditor.getText());
            this.getWysEditor().setText("");
            this.insertHTML(this.getWysEditor(), topText, 0);
            CompoundUndoManager.discardAllEdits(this.getWysEditor().getDocument());
        } else {
            String topText = this.removeInvalidTags(this.getWysEditor().getText());
            if (this.isWysTextChanged || this.srcEditor.getText().equals("")) {
                String t = this.deIndent(this.removeInvalidTags(topText));
                t = Entities.HTML40.unescapeUnknownEntities(t);
                this.srcEditor.setText(t);
            }
            CompoundUndoManager.discardAllEdits(this.srcEditor.getDocument());
        }
        this.isWysTextChanged = false;
        this.paragraphCombo.setEnabled(this.tabs.getSelectedIndex() == 0);
        this.fontFamilyCombo.setEnabled(this.tabs.getSelectedIndex() == 0);
        this.updateState();
    }

    public void setText(String text) {
        String topText = this.removeInvalidTags(text);
        if (this.tabs.getSelectedIndex() == 0) {
            this.getWysEditor().setText("");
            this.insertHTML(this.getWysEditor(), topText, 0);
            CompoundUndoManager.discardAllEdits(this.getWysEditor().getDocument());
        } else {
            String t = this.deIndent(this.removeInvalidTags(topText));
            t = Entities.HTML40.unescapeUnknownEntities(t);
            this.srcEditor.setText(t);
            CompoundUndoManager.discardAllEdits(this.srcEditor.getDocument());
        }
    }

    public String getText() {
        String topText;
        if (this.tabs.getSelectedIndex() == 0) {
            topText = this.removeInvalidTags(this.getWysEditor().getText());
        } else {
            topText = this.removeInvalidTags(this.srcEditor.getText());
            topText = this.deIndent(this.removeInvalidTags(topText));
            topText = Entities.HTML40.unescapeUnknownEntities(topText);
        }
        return topText;
    }

    private String deIndent(String html) {
        String ws = "\n    ";
        StringBuffer sb = new StringBuffer(html);
        while (sb.indexOf(ws) != -1) {
            int s = sb.indexOf(ws);
            int e = s + ws.length();
            sb.delete(s, e);
            sb.insert(s, "\n");
        }
        return sb.toString();
    }

    private String removeInvalidTags(String html) {
        for (int i = 0; i < INVALID_TAGS.length; ++i) {
            html = this.deleteOccurance(html, '<' + INVALID_TAGS[i] + '>');
            html = this.deleteOccurance(html, "</" + INVALID_TAGS[i] + '>');
        }
        return html.trim();
    }

    private String deleteOccurance(String text, String word) {
        int p;
        StringBuffer sb = new StringBuffer(text);
        while ((p = sb.toString().toLowerCase().indexOf(word.toLowerCase())) != -1) {
            sb.delete(p, p + word.length());
        }
        return sb.toString();
    }

    private void updateState() {
        if (this.focusedEditor == this.getWysEditor()) {
            this.fontFamilyCombo.removeActionListener(this.fontChangeHandler);
            String fontName = HTMLUtils.getFontFamily(this.getWysEditor());
            if (fontName == null) {
                this.fontFamilyCombo.setSelectedIndex(0);
            } else {
                this.fontFamilyCombo.setSelectedItem(fontName);
            }
            this.fontFamilyCombo.addActionListener(this.fontChangeHandler);
        }
        this.actionList.putContextValueForAll((Object)"editor", (Object)this.focusedEditor);
        this.actionList.updateEnabledForAll();
    }

    public JEditorPane getWysEditor() {
        return this.wysEditor;
    }

    private class FontChangeHandler
    implements ActionListener {
        private FontChangeHandler() {
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == HTMLEditorPane.this.fontFamilyCombo && HTMLEditorPane.this.focusedEditor == HTMLEditorPane.this.getWysEditor()) {
                HTMLDocument document = (HTMLDocument)HTMLEditorPane.this.focusedEditor.getDocument();
                CompoundUndoManager.beginCompoundEdit(document);
                if (HTMLEditorPane.this.fontFamilyCombo.getSelectedIndex() != 0) {
                    HTMLUtils.setFontFamily(HTMLEditorPane.this.getWysEditor(), HTMLEditorPane.this.fontFamilyCombo.getSelectedItem().toString());
                } else {
                    HTMLUtils.setFontFamily(HTMLEditorPane.this.getWysEditor(), null);
                }
                CompoundUndoManager.endCompoundEdit(document);
            }
        }

        public void itemStateChanged(ItemEvent e) {
        }
    }

    private class ParagraphComboRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = 1L;

        private ParagraphComboRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value instanceof Action) {
                value = ((Action)value).getValue("Name");
            }
            return super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        }
    }

    private class ParagraphComboHandler
    implements ActionListener {
        private ParagraphComboHandler() {
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == HTMLEditorPane.this.paragraphCombo) {
                Action a = (Action)HTMLEditorPane.this.paragraphCombo.getSelectedItem();
                a.actionPerformed(e);
            }
        }
    }

    private class ChangeTabAction
    extends DefaultAction {
        private static final long serialVersionUID = 1L;
        int tab;

        public ChangeTabAction(int tab) {
            super(tab == 0 ? i18n.str("rich_text") : i18n.str("source"));
            this.tab = tab;
            this.putValue("BUTTON_TYPE", "radio");
        }

        protected void execute(ActionEvent e) {
            HTMLEditorPane.this.tabs.setSelectedIndex(this.tab);
            this.setSelected(true);
        }

        protected void contextChanged() {
            this.setSelected(HTMLEditorPane.this.tabs.getSelectedIndex() == this.tab);
        }
    }

    private class TextChangedHandler
    implements DocumentListener {
        private TextChangedHandler() {
        }

        public void insertUpdate(DocumentEvent e) {
            this.textChanged();
        }

        public void removeUpdate(DocumentEvent e) {
            this.textChanged();
        }

        public void changedUpdate(DocumentEvent e) {
            this.textChanged();
        }

        private void textChanged() {
            if (HTMLEditorPane.this.tabs.getSelectedIndex() == 0) {
                HTMLEditorPane.this.isWysTextChanged = true;
            }
        }
    }

    private class FocusHandler
    implements FocusListener {
        private FocusHandler() {
        }

        public void focusGained(FocusEvent e) {
            if (e.getComponent() instanceof JEditorPane) {
                JEditorPane ed = (JEditorPane)e.getComponent();
                CompoundUndoManager.updateUndo(ed.getDocument());
                HTMLEditorPane.this.focusedEditor = ed;
                HTMLEditorPane.this.updateState();
            }
        }

        public void focusLost(FocusEvent e) {
            if (e.getComponent() instanceof JEditorPane) {
                // empty if block
            }
        }
    }

    private class PopupHandler
    extends MouseAdapter {
        private PopupHandler() {
        }

        public void mousePressed(MouseEvent e) {
            this.checkForPopupTrigger(e);
        }

        public void mouseReleased(MouseEvent e) {
            this.checkForPopupTrigger(e);
        }

        private void checkForPopupTrigger(MouseEvent e) {
            if (e.isPopupTrigger()) {
                JPopupMenu p = null;
                if (e.getSource() == HTMLEditorPane.this.getWysEditor()) {
                    p = HTMLEditorPane.this.wysPopupMenu;
                } else if (e.getSource() == HTMLEditorPane.this.srcEditor) {
                    p = HTMLEditorPane.this.srcPopupMenu;
                } else {
                    return;
                }
                p.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }

    private class CaretHandler
    implements CaretListener {
        private CaretHandler() {
        }

        public void caretUpdate(CaretEvent e) {
            HTMLEditorPane.this.updateState();
        }
    }
}

