/*
 * Decompiled with CFR 0.152.
 */
package net.atlanticbb.tantlinger.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import net.atlanticbb.tantlinger.i18n.I18n;

public class StandardDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private static final I18n i18n = I18n.getInstance("net.atlanticbb.tantlinger.ui");
    public static final int BUTTONS_CENTER = 1;
    public static final int BUTTONS_LEFT = 0;
    public static final int BUTTONS_RIGHT = 2;
    private static final int COMPONENT_SPACING = 5;
    private boolean myIsDialogCancelled = true;
    private Container myUserContentPane;

    public StandardDialog() {
        this.init(1, 5);
    }

    public StandardDialog(Frame parent, String title) {
        super(parent, title);
        this.init(1, 5);
    }

    public StandardDialog(Dialog parent, String title) {
        super(parent, title);
        this.init(1, 5);
    }

    public StandardDialog(Dialog parent, String title, int orientation, int spacing) {
        super(parent, title);
        this.init(orientation, spacing);
    }

    public StandardDialog(Frame parent, String title, int orientation, int spacing) {
        super(parent, title);
        this.init(orientation, spacing);
    }

    public StandardDialog(Frame parent, String title, int orientation) {
        super(parent, title);
        this.init(orientation, 5);
    }

    public StandardDialog(Dialog parent, String title, int orientation) {
        super(parent, title);
        this.init(orientation, 5);
    }

    private void init(int orientation, int spacing) {
        this.setModal(true);
        this.setDefaultCloseOperation(0);
        JPanel internalContentPane = new JPanel();
        internalContentPane.setLayout(new BorderLayout(5, 5));
        AbstractAction okAction = new AbstractAction(i18n.str("ok")){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent actionEvent) {
                if (StandardDialog.this.isValidData()) {
                    StandardDialog.this.myIsDialogCancelled = false;
                    StandardDialog.this.dispose();
                }
            }
        };
        AbstractAction cancelAction = new AbstractAction(i18n.str("cancel")){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent actionEvent) {
                StandardDialog.this.myIsDialogCancelled = true;
                StandardDialog.this.dispose();
            }
        };
        JPanel buttonPanel = new JPanel(new GridLayout(1, 2, 5, 5));
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(0, 5, 5, 5));
        JButton okB = new JButton(okAction);
        buttonPanel.add(okB);
        buttonPanel.add(new JButton(cancelAction));
        this.getRootPane().setDefaultButton(okB);
        JPanel spacer = new JPanel(new FlowLayout(orientation));
        spacer.add(buttonPanel);
        internalContentPane.add((Component)spacer, "South");
        this.myUserContentPane = new JPanel(new BorderLayout());
        super.setContentPane(internalContentPane);
        WindowAdapter windowAdapter = new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                StandardDialog.this.myIsDialogCancelled = true;
                StandardDialog.this.dispose();
            }
        };
        this.addWindowListener(windowAdapter);
    }

    public Container getContentPane() {
        return this.myUserContentPane;
    }

    public void setContentPane(Container contentPane) {
        this.myUserContentPane = contentPane;
        super.getContentPane().add((Component)this.myUserContentPane, "Center");
    }

    public boolean hasUserCancelled() {
        return this.myIsDialogCancelled;
    }

    protected boolean isValidData() {
        return true;
    }
}

