/*
 * Decompiled with CFR 0.152.
 */
package net.atlanticbb.tantlinger.ui.text;

import java.awt.Color;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.JEditorPane;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.text.StyledEditorKit;
import javax.swing.text.html.CSS;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.atlanticbb.tantlinger.ui.text.ElementWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.tidy.Tidy;

public class HTMLUtils {
    private static final Tidy tidy = new Tidy();

    public static boolean isImplied(Element el) {
        return el.getName().equals("p-implied");
    }

    public static String createTag(HTML.Tag enclTag, String innerHTML) {
        return HTMLUtils.createTag(enclTag, new SimpleAttributeSet(), innerHTML);
    }

    public static String createTag(HTML.Tag enclTag, AttributeSet set, String innerHTML) {
        String t = HTMLUtils.tagOpen(enclTag, set) + innerHTML + HTMLUtils.tagClose(enclTag);
        return t;
    }

    private static String tagOpen(HTML.Tag enclTag, AttributeSet set) {
        String t = "<" + enclTag;
        Enumeration<?> e = set.getAttributeNames();
        while (e.hasMoreElements()) {
            Object name = e.nextElement();
            if (name.toString().equals("name")) continue;
            Object val = set.getAttribute(name);
            t = t + " " + name + "=\"" + val + "\"";
        }
        return t + ">";
    }

    private static String tagClose(HTML.Tag t) {
        return "</" + t + ">";
    }

    public static List getParagraphElements(JEditorPane editor) {
        LinkedList<Element> elems = new LinkedList<Element>();
        try {
            HTMLDocument doc = (HTMLDocument)editor.getDocument();
            Element curE = HTMLUtils.getParaElement(doc, editor.getSelectionStart());
            Element endE = HTMLUtils.getParaElement(doc, editor.getSelectionEnd());
            while (curE.getEndOffset() <= endE.getEndOffset()) {
                elems.add(curE);
                if ((curE = HTMLUtils.getParaElement(doc, curE.getEndOffset() + 1)).getEndOffset() < doc.getLength()) continue;
                break;
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return elems;
    }

    private static Element getParaElement(HTMLDocument doc, int pos) {
        Element curE = doc.getParagraphElement(pos);
        while (HTMLUtils.isImplied(curE)) {
            curE = curE.getParentElement();
        }
        Element lp = HTMLUtils.getListParent(curE);
        if (lp != null) {
            curE = lp;
        }
        return curE;
    }

    public static Element getParent(Element curElem, HTML.Tag parentTag) {
        for (Element parent = curElem; parent != null; parent = parent.getParentElement()) {
            if (!parent.getName().equals(parentTag.toString())) continue;
            return parent;
        }
        return null;
    }

    public static boolean isElementEmpty(Element el) {
        String s = HTMLUtils.getElementHTML(el, false).trim();
        return s.length() == 0;
    }

    public static Element getListParent(Element elem) {
        for (Element parent = elem; parent != null; parent = parent.getParentElement()) {
            if (!parent.getName().toUpperCase().equals("UL") && !parent.getName().toUpperCase().equals("OL") && !parent.getName().equals("dl") && !parent.getName().equals("menu") && !parent.getName().equals("dir")) continue;
            return parent;
        }
        return null;
    }

    public static Element getPreviousElement(HTMLDocument doc, Element el) {
        if (el.getStartOffset() > 0) {
            return doc.getParagraphElement(el.getStartOffset() - 1);
        }
        return el;
    }

    public static Element getNextElement(HTMLDocument doc, Element el) {
        if (el.getEndOffset() < doc.getLength()) {
            return doc.getParagraphElement(el.getEndOffset() + 1);
        }
        return el;
    }

    public static String removeEnclosingTags(Element elem, String txt) {
        HTML.Tag t = HTML.getTag(elem.getName());
        return HTMLUtils.removeEnclosingTags(t, txt);
    }

    public static String removeEnclosingTags(HTML.Tag t, String txt) {
        int n;
        String openStart = "<" + t;
        String closeTag = "</" + t + ">";
        if ((txt = txt.trim()).startsWith(openStart) && (n = txt.indexOf(">")) != -1) {
            txt = txt.substring(n + 1, txt.length());
        }
        if (txt.endsWith(closeTag)) {
            txt = txt.substring(0, txt.length() - closeTag.length());
        }
        return txt;
    }

    public static String getElementHTML(Element el, boolean includeEnclosingTags) {
        String txt = "";
        try {
            StringWriter out = new StringWriter();
            ElementWriter w = new ElementWriter((Writer)out, el);
            w.write();
            txt = out.toString();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (includeEnclosingTags) {
            return txt;
        }
        return HTMLUtils.removeEnclosingTags(el, txt);
    }

    public static void removeElement(Element el) throws BadLocationException {
        HTMLDocument document = (HTMLDocument)el.getDocument();
        int start = el.getStartOffset();
        int len = el.getEndOffset() - start;
        Element tdEle = HTMLUtils.getParent(el, HTML.Tag.TD);
        if (tdEle != null && el.getEndOffset() == tdEle.getEndOffset()) {
            document.remove(start, len - 1);
        } else {
            if (el.getEndOffset() > document.getLength()) {
                len = document.getLength() - start;
            }
            document.remove(start, len);
        }
    }

    public static HTML.Tag getStartTag(String text) {
        String html = text.trim();
        int s = html.indexOf(60);
        if (s != 0) {
            return null;
        }
        int e = html.indexOf(62);
        if (e == -1) {
            return null;
        }
        String tagName = html.substring(1, e).trim();
        if (tagName.indexOf(32) != -1) {
            tagName = tagName.split("\\s")[0];
        }
        return HTML.getTag(tagName);
    }

    private static int depthFromRoot(Element curElem) {
        Element parent = curElem;
        int depth = 0;
        while (parent != null && !parent.getName().equals("body") && !parent.getName().equals("td")) {
            parent = parent.getParentElement();
            ++depth;
        }
        return depth;
    }

    public static void insertArbitraryHTML(String rawHtml, JEditorPane editor) {
        tidy.setOutputEncoding("UTF-8");
        tidy.setInputEncoding("UTF-8");
        try {
            ByteArrayInputStream bin = new ByteArrayInputStream(rawHtml.getBytes("UTF-8"));
            Document doc = tidy.parseDOM((InputStream)bin, null);
            NodeList nodelist = doc.getElementsByTagName("body");
            if (nodelist != null) {
                Node body = nodelist.item(0);
                NodeList bodyChildren = body.getChildNodes();
                int len = bodyChildren.getLength();
                for (int i = 0; i < len; ++i) {
                    String ml = HTMLUtils.xmlToString(bodyChildren.item(i));
                    if (ml == null) continue;
                    HTML.Tag tag = HTMLUtils.getStartTag(ml);
                    if (tag == null) {
                        tag = HTML.Tag.SPAN;
                        ml = "<span>" + ml + "</span>";
                    }
                    HTMLUtils.insertHTML(ml, tag, editor);
                }
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    private static String xmlToString(Node node) {
        try {
            DOMSource source = new DOMSource(node);
            StringWriter stringWriter = new StringWriter();
            StreamResult result = new StreamResult(stringWriter);
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.transform(source, result);
            return stringWriter.getBuffer().toString();
        }
        catch (TransformerConfigurationException e) {
            e.printStackTrace();
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static void insertHTML(String html, HTML.Tag tag, JEditorPane editor) {
        HTMLDocument document;
        HTMLEditorKit editorKit;
        try {
            editorKit = (HTMLEditorKit)editor.getEditorKit();
            document = (HTMLDocument)editor.getDocument();
        }
        catch (ClassCastException ex) {
            return;
        }
        int caret = editor.getCaretPosition();
        Element pElem = document.getParagraphElement(caret);
        boolean breakParagraph = tag.breaksFlow() || tag.isBlock();
        boolean beginParagraph = caret == pElem.getStartOffset();
        html = HTMLUtils.jEditorPaneizeHTML(html);
        try {
            if (breakParagraph && beginParagraph) {
                document.insertBeforeStart(pElem, "<p></p>");
                Element nextEl = document.getParagraphElement(caret + 1);
                editorKit.insertHTML(document, caret + 1, html, HTMLUtils.depthFromRoot(nextEl), 0, tag);
                document.remove(caret, 1);
            } else if (breakParagraph && !beginParagraph) {
                editorKit.insertHTML(document, caret, html, HTMLUtils.depthFromRoot(pElem), 0, tag);
            } else if (!breakParagraph && beginParagraph) {
                document.insertAfterStart(pElem, "&nbsp;");
                editorKit.insertHTML(document, caret + 1, html, 0, 0, tag);
                document.remove(caret, 1);
            } else if (!breakParagraph && !beginParagraph) {
                editorKit.insertHTML(document, caret, html, 0, 0, tag);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static AttributeSet getCharacterAttributes(JEditorPane editor) {
        int p = editor.getSelectedText() != null ? editor.getSelectionEnd() - 1 : (editor.getCaretPosition() > 0 ? editor.getCaretPosition() - 1 : 0);
        try {
            StyledDocument doc = (StyledDocument)editor.getDocument();
            return doc.getCharacterElement(p).getAttributes();
        }
        catch (ClassCastException classCastException) {
            return null;
        }
    }

    public static String getFontFamily(JEditorPane editor) {
        AttributeSet attr = HTMLUtils.getCharacterAttributes(editor);
        if (attr != null) {
            AttributeSet set;
            Object val = attr.getAttribute(StyleConstants.FontFamily);
            if (val != null) {
                return val.toString();
            }
            val = attr.getAttribute(CSS.Attribute.FONT_FAMILY);
            if (val != null) {
                return val.toString();
            }
            val = attr.getAttribute(HTML.Tag.FONT);
            if (val != null && val instanceof AttributeSet && (val = (set = (AttributeSet)val).getAttribute(HTML.Attribute.FACE)) != null) {
                return val.toString();
            }
        }
        return null;
    }

    public static void setFontFamily(JEditorPane editor, String fontName) {
        AttributeSet attr = HTMLUtils.getCharacterAttributes(editor);
        if (attr == null) {
            return;
        }
        HTMLUtils.printAttribs(attr);
        if (fontName == null) {
            SimpleAttributeSet set;
            Object val = attr.getAttribute(HTML.Tag.FONT);
            if (val != null && val instanceof AttributeSet && (val = (set = new SimpleAttributeSet((AttributeSet)val)).getAttribute(HTML.Attribute.FACE)) != null) {
                set.removeAttribute(HTML.Attribute.FACE);
                HTMLUtils.removeCharacterAttribute(editor, HTML.Tag.FONT);
                if (set.getAttributeCount() > 0) {
                    SimpleAttributeSet fontSet = new SimpleAttributeSet();
                    fontSet.addAttribute(HTML.Tag.FONT, set);
                    HTMLUtils.setCharacterAttributes(editor, set);
                }
            }
            HTMLUtils.removeCharacterAttribute(editor, StyleConstants.FontFamily);
            HTMLUtils.removeCharacterAttribute(editor, CSS.Attribute.FONT_FAMILY);
        } else {
            SimpleAttributeSet tagAttrs = new SimpleAttributeSet();
            tagAttrs.addAttribute(StyleConstants.FontFamily, fontName);
            HTMLUtils.setCharacterAttributes(editor, tagAttrs);
        }
        HTMLUtils.printAttribs(attr);
    }

    public static void removeCharacterAttribute(JEditorPane editor, CSS.Attribute atr, String val) {
        MutableAttributeSet attr;
        HTMLDocument doc;
        try {
            doc = (HTMLDocument)editor.getDocument();
            attr = ((HTMLEditorKit)editor.getEditorKit()).getInputAttributes();
        }
        catch (ClassCastException cce) {
            return;
        }
        List tokens = HTMLUtils.tokenizeCharAttribs(doc, editor.getSelectionStart(), editor.getSelectionEnd());
        for (CharStyleToken t : tokens) {
            if (!t.attrs.isDefined(atr) || !t.attrs.getAttribute(atr).toString().equals(val)) continue;
            SimpleAttributeSet sas = new SimpleAttributeSet();
            sas.addAttributes(t.attrs);
            sas.addAttribute(StyleConstants.NameAttribute, HTML.Tag.CONTENT);
            sas.removeAttribute(atr);
            doc.setCharacterAttributes(t.offs, t.len, sas, true);
        }
        int pos = editor.getCaretPosition();
        attr.addAttributes(doc.getCharacterElement(pos).getAttributes());
        attr.removeAttribute(atr);
    }

    public static void removeCharacterAttribute(JEditorPane editor, Object atr) {
        MutableAttributeSet attr;
        HTMLDocument doc;
        try {
            doc = (HTMLDocument)editor.getDocument();
            attr = ((HTMLEditorKit)editor.getEditorKit()).getInputAttributes();
        }
        catch (ClassCastException cce) {
            return;
        }
        List tokens = HTMLUtils.tokenizeCharAttribs(doc, editor.getSelectionStart(), editor.getSelectionEnd());
        for (CharStyleToken t : tokens) {
            if (!t.attrs.isDefined(atr)) continue;
            SimpleAttributeSet sas = new SimpleAttributeSet();
            sas.addAttributes(t.attrs);
            sas.addAttribute(StyleConstants.NameAttribute, HTML.Tag.CONTENT);
            sas.removeAttribute(atr);
            doc.setCharacterAttributes(t.offs, t.len, sas, true);
        }
        int pos = editor.getCaretPosition();
        attr.addAttributes(doc.getCharacterElement(pos).getAttributes());
        attr.removeAttribute(atr);
    }

    private static List tokenizeCharAttribs(HTMLDocument doc, int s, int e) {
        LinkedList<CharStyleToken> tokens = new LinkedList<CharStyleToken>();
        CharStyleToken tok = new CharStyleToken();
        while (s <= e) {
            AttributeSet as = doc.getCharacterElement(s).getAttributes();
            if (tok.attrs == null || s + 1 <= e && !as.isEqual(tok.attrs)) {
                tok = new CharStyleToken();
                tok.offs = s;
                tokens.add(tok);
                tok.attrs = as;
            }
            if (s + 1 <= e) {
                ++tok.len;
            }
            ++s;
        }
        return tokens;
    }

    public static void setCharacterAttributes(JEditorPane editor, AttributeSet attr, boolean replace) {
        StyledEditorKit k;
        HTMLDocument doc;
        try {
            doc = (HTMLDocument)editor.getDocument();
            k = (StyledEditorKit)editor.getEditorKit();
        }
        catch (ClassCastException ex) {
            return;
        }
        MutableAttributeSet inputAttributes = k.getInputAttributes();
        SimpleAttributeSet sas = new SimpleAttributeSet(attr);
        sas.removeAttribute("CR");
        attr = sas;
        int p0 = editor.getSelectionStart();
        int p1 = editor.getSelectionEnd();
        if (p0 != p1) {
            doc.setCharacterAttributes(p0, p1 - p0, attr, replace);
        } else {
            if (replace) {
                attr = attr.copyAttributes();
                inputAttributes.removeAttributes(inputAttributes);
                inputAttributes.addAttribute(StyleConstants.NameAttribute, HTML.Tag.CONTENT);
            }
            inputAttributes.addAttributes(attr);
        }
    }

    public static void setCharacterAttributes(JEditorPane editor, AttributeSet attrs) {
        HTMLUtils.setCharacterAttributes(editor, attrs, false);
    }

    public static Map tagAttribsToMap(String atts) {
        HashMap<String, String> attribs = new HashMap<String, String>();
        StringTokenizer st = new StringTokenizer(atts.trim(), " ");
        String lastAtt = null;
        while (st.hasMoreTokens()) {
            String atVal = st.nextToken().trim();
            int equalPos = atVal.indexOf(61);
            if (equalPos == -1) {
                if (lastAtt == null) break;
                String lastVal = attribs.get(lastAtt).toString();
                attribs.put(lastAtt, lastVal + " " + atVal);
                continue;
            }
            String at = atVal.substring(0, equalPos);
            String val = atVal.substring(atVal.indexOf(61) + 1, atVal.length());
            if (val.startsWith("\"")) {
                val = val.substring(1, val.length());
            }
            if (val.endsWith("\"")) {
                val = val.substring(0, val.length() - 1);
            }
            attribs.put(at, val);
            lastAtt = at;
        }
        return attribs;
    }

    public static String colorToHex(Color color) {
        String colorstr = new String("#");
        String str = Integer.toHexString(color.getRed());
        if (str.length() > 2) {
            str = str.substring(0, 2);
        } else {
            colorstr = str.length() < 2 ? colorstr + "0" + str : colorstr + str;
        }
        str = Integer.toHexString(color.getGreen());
        if (str.length() > 2) {
            str = str.substring(0, 2);
        } else {
            colorstr = str.length() < 2 ? colorstr + "0" + str : colorstr + str;
        }
        str = Integer.toHexString(color.getBlue());
        if (str.length() > 2) {
            str = str.substring(0, 2);
        } else {
            colorstr = str.length() < 2 ? colorstr + "0" + str : colorstr + str;
        }
        return colorstr;
    }

    public static Color hexToColor(String value) {
        Color c;
        String digits = value.startsWith("#") ? value.substring(1, Math.min(value.length(), 7)) : value;
        String hstr = "0x" + digits;
        try {
            c = Color.decode(hstr);
        }
        catch (NumberFormatException nfe) {
            c = Color.BLACK;
        }
        return c;
    }

    public static Color stringToColor(String str) {
        Color color = null;
        color = str.length() == 0 ? Color.black : (str.charAt(0) == '#' ? HTMLUtils.hexToColor(str) : (str.equalsIgnoreCase("Black") ? HTMLUtils.hexToColor("#000000") : (str.equalsIgnoreCase("Silver") ? HTMLUtils.hexToColor("#C0C0C0") : (str.equalsIgnoreCase("Gray") ? HTMLUtils.hexToColor("#808080") : (str.equalsIgnoreCase("White") ? HTMLUtils.hexToColor("#FFFFFF") : (str.equalsIgnoreCase("Maroon") ? HTMLUtils.hexToColor("#800000") : (str.equalsIgnoreCase("Red") ? HTMLUtils.hexToColor("#FF0000") : (str.equalsIgnoreCase("Purple") ? HTMLUtils.hexToColor("#800080") : (str.equalsIgnoreCase("Fuchsia") ? HTMLUtils.hexToColor("#FF00FF") : (str.equalsIgnoreCase("Green") ? HTMLUtils.hexToColor("#008000") : (str.equalsIgnoreCase("Lime") ? HTMLUtils.hexToColor("#00FF00") : (str.equalsIgnoreCase("Olive") ? HTMLUtils.hexToColor("#808000") : (str.equalsIgnoreCase("Yellow") ? HTMLUtils.hexToColor("#FFFF00") : (str.equalsIgnoreCase("Navy") ? HTMLUtils.hexToColor("#000080") : (str.equalsIgnoreCase("Blue") ? HTMLUtils.hexToColor("#0000FF") : (str.equalsIgnoreCase("Teal") ? HTMLUtils.hexToColor("#008080") : (str.equalsIgnoreCase("Aqua") ? HTMLUtils.hexToColor("#00FFFF") : HTMLUtils.hexToColor(str))))))))))))))))));
        return color;
    }

    public static String jEditorPaneizeHTML(String html) {
        return html.replaceAll("(<\\s*\\w+\\b[^>]*)/(\\s*>)", "$1$2");
    }

    public static void printAttribs(AttributeSet attr) {
        System.err.println("----------------------------------------------------------------");
        System.err.println(attr);
        Enumeration<?> ee = attr.getAttributeNames();
        while (ee.hasMoreElements()) {
            Object name = ee.nextElement();
            Object atr = attr.getAttribute(name);
            System.err.println(name + " " + name.getClass().getName() + " | " + atr + " " + atr.getClass().getName());
        }
        System.err.println("----------------------------------------------------------------");
    }

    static {
        tidy.setQuiet(true);
        tidy.setShowWarnings(false);
        tidy.setForceOutput(true);
        tidy.setFixComments(true);
        tidy.setFixUri(true);
        tidy.setDropEmptyParas(true);
        tidy.setLiteralAttribs(true);
        tidy.setTrimEmptyElements(true);
        tidy.setXHTML(true);
    }

    private static class CharStyleToken {
        int offs;
        int len;
        AttributeSet attrs;

        private CharStyleToken() {
        }
    }
}

