/*
 * Decompiled with CFR 0.152.
 */
package net.atlanticbb.tantlinger.ui.text;

import java.awt.Color;
import java.awt.Font;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import java.util.StringTokenizer;
import novaworx.syntax.SyntaxFactory;
import novaworx.textpane.SyntaxDocument;
import novaworx.textpane.SyntaxStyle;
import novaworx.textpane.SyntaxTextPane;

public class SourceCodeEditor
extends SyntaxTextPane {
    private static final long serialVersionUID = 1L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SourceCodeEditor() {
        SyntaxFactory.setSyntaxCatalog((URL)((Object)((Object)this)).getClass().getResource("/resources/syntax.catalog.xml"));
        SyntaxFactory.loadSyntaxes();
        this.setLineHighlight(true);
        this.setBracketHighlight(true);
        this.setAntiAlias(true);
        this.setOpaque(true);
        this.setCaretOnDelay(500);
        this.setCaretOffDelay(500);
        this.setFont(new Font("Default", 0, 12));
        Properties themes = new Properties();
        InputStream in = null;
        try {
            in = ((Object)((Object)this)).getClass().getResource("/net/atlanticbb/tantlinger/ui/text/syntax.properties").openStream();
            themes.load(in);
            this.setTheme(themes, "default");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                in.close();
            }
            catch (Exception exception) {}
        }
    }

    public void setTheme(Properties props) {
        String prefix = "default";
        try {
            SyntaxDocument d = (SyntaxDocument)this.getDocument();
            prefix = d.getSyntax().getName();
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        this.setTheme(props, prefix);
    }

    public void setTheme(Properties props, String prefix) {
        SyntaxStyle[] aStyles = this.getSyntaxStyles();
        aStyles[1].setForeground(this.parseColor(props.getProperty(prefix + ".comment1.fg")));
        aStyles[1].setBackground(this.parseColor(props.getProperty(prefix + ".comment1.bg")));
        aStyles[1].setFontStyle(this.parseFont(props.getProperty(prefix + ".comment1.font")));
        aStyles[2].setForeground(this.parseColor(props.getProperty(prefix + ".comment2.fg")));
        aStyles[2].setBackground(this.parseColor(props.getProperty(prefix + ".comment2.bg")));
        aStyles[2].setFontStyle(this.parseFont(props.getProperty(prefix + ".comment2.font")));
        aStyles[3].setForeground(this.parseColor(props.getProperty(prefix + ".comment3.fg")));
        aStyles[3].setBackground(this.parseColor(props.getProperty(prefix + ".comment3.bg")));
        aStyles[3].setFontStyle(this.parseFont(props.getProperty(prefix + ".comment3.font")));
        aStyles[4].setForeground(this.parseColor(props.getProperty(prefix + ".digit.fg")));
        aStyles[4].setBackground(this.parseColor(props.getProperty(prefix + ".digit.bg")));
        aStyles[4].setFontStyle(this.parseFont(props.getProperty(prefix + ".digit.font")));
        aStyles[5].setForeground(this.parseColor(props.getProperty(prefix + ".literal1.fg")));
        aStyles[5].setBackground(this.parseColor(props.getProperty(prefix + ".literal1.bg")));
        aStyles[5].setFontStyle(this.parseFont(props.getProperty(prefix + ".literal1.font")));
        aStyles[6].setForeground(this.parseColor(props.getProperty(prefix + ".literal2.fg")));
        aStyles[6].setBackground(this.parseColor(props.getProperty(prefix + ".literal2.bg")));
        aStyles[6].setFontStyle(this.parseFont(props.getProperty(prefix + ".literal2.font")));
        aStyles[7].setForeground(this.parseColor(props.getProperty(prefix + ".keyword1.fg")));
        aStyles[7].setBackground(this.parseColor(props.getProperty(prefix + ".keyword1.bg")));
        aStyles[7].setFontStyle(this.parseFont(props.getProperty(prefix + ".keyword1.font")));
        aStyles[8].setForeground(this.parseColor(props.getProperty(prefix + ".keyword2.fg")));
        aStyles[8].setBackground(this.parseColor(props.getProperty(prefix + ".keyword2.bg")));
        aStyles[8].setFontStyle(this.parseFont(props.getProperty(prefix + ".keyword2.font")));
        aStyles[9].setForeground(this.parseColor(props.getProperty(prefix + ".keyword3.fg")));
        aStyles[9].setBackground(this.parseColor(props.getProperty(prefix + ".keyword3.bg")));
        aStyles[9].setFontStyle(this.parseFont(props.getProperty(prefix + ".keyword3.font")));
        aStyles[10].setForeground(this.parseColor(props.getProperty(prefix + ".keyword4.fg")));
        aStyles[10].setBackground(this.parseColor(props.getProperty(prefix + ".keyword4.bg")));
        aStyles[10].setFontStyle(this.parseFont(props.getProperty(prefix + ".keyword4.font")));
        aStyles[11].setForeground(this.parseColor(props.getProperty(prefix + ".keyword5.fg")));
        aStyles[11].setBackground(this.parseColor(props.getProperty(prefix + ".keyword5.bg")));
        aStyles[11].setFontStyle(this.parseFont(props.getProperty(prefix + ".keyword5.font")));
        aStyles[12].setForeground(this.parseColor(props.getProperty(prefix + ".function.fg")));
        aStyles[12].setBackground(this.parseColor(props.getProperty(prefix + ".function.bg")));
        aStyles[12].setFontStyle(this.parseFont(props.getProperty(prefix + ".function.font")));
        aStyles[13].setForeground(this.parseColor(props.getProperty(prefix + ".operator.fg")));
        aStyles[13].setBackground(this.parseColor(props.getProperty(prefix + ".operator.bg")));
        aStyles[13].setFontStyle(this.parseFont(props.getProperty(prefix + ".operator.font")));
        aStyles[14].setForeground(this.parseColor(props.getProperty(prefix + ".markup.fg")));
        aStyles[14].setBackground(this.parseColor(props.getProperty(prefix + ".markup.bg")));
        aStyles[14].setFontStyle(this.parseFont(props.getProperty(prefix + ".markup.font")));
        aStyles[15].setForeground(this.parseColor(props.getProperty(prefix + ".label.fg")));
        aStyles[15].setBackground(this.parseColor(props.getProperty(prefix + ".label.bg")));
        aStyles[15].setFontStyle(this.parseFont(props.getProperty(prefix + ".label.font")));
        aStyles[16].setForeground(this.parseColor(props.getProperty(prefix + ".invalid.fg")));
        aStyles[16].setBackground(this.parseColor(props.getProperty(prefix + ".invalid.bg")));
        aStyles[16].setFontStyle(this.parseFont(props.getProperty(prefix + ".invalid.font")));
        aStyles[0].setFontStyle(this.parseFont(props.getProperty(prefix + ".null.font")));
        this.setForeground(this.parseColor(props.getProperty(prefix + ".text.fg")));
        this.setBackground(this.parseColor(props.getProperty(prefix + ".text.bg")));
        this.setCaretColor(this.parseColor(props.getProperty(prefix + ".caret.fg")));
        this.setBracketHighlightColor(this.parseColor(props.getProperty(prefix + ".brackethighlight.fg")));
        this.setLineHighlightColor(this.parseColor(props.getProperty(prefix + ".linehighlight.fg")));
    }

    private Color parseColor(String color) {
        if (color == null) {
            return new Color(0, 0, 0, 0);
        }
        try {
            if (color.length() == 6) {
                int r = Integer.parseInt(color.substring(0, 2), 16);
                int g = Integer.parseInt(color.substring(2, 4), 16);
                int b = Integer.parseInt(color.substring(4, 6), 16);
                return new Color(r, g, b);
            }
            if (color.length() == 8) {
                int a = Integer.parseInt(color.substring(0, 2), 16);
                int r = Integer.parseInt(color.substring(2, 4), 16);
                int g = Integer.parseInt(color.substring(4, 6), 16);
                int b = Integer.parseInt(color.substring(6, 8), 16);
                return new Color(r, g, b, a);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return Color.black;
    }

    private int parseFont(String font) {
        int flags = 0;
        if (font != null) {
            StringTokenizer tokenizer = new StringTokenizer(font, ",");
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken().toLowerCase();
                if (token.equals("bold")) {
                    flags |= 1;
                    continue;
                }
                if (token.equals("italic")) {
                    flags |= 2;
                    continue;
                }
                if (!token.equals("plain")) continue;
            }
        }
        return flags;
    }
}

