/*
 * Decompiled with CFR 0.152.
 */
package net.atlanticbb.tantlinger.ui.text;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.MouseInputAdapter;
import javax.swing.text.AttributeSet;
import javax.swing.text.ComponentView;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.ObjectView;
import net.atlanticbb.tantlinger.ui.UIUtils;
import net.atlanticbb.tantlinger.ui.text.CompoundUndoManager;
import net.atlanticbb.tantlinger.ui.text.DelegateView;
import net.atlanticbb.tantlinger.ui.text.HTMLUtils;
import net.atlanticbb.tantlinger.ui.text.actions.DecoratedTextAction;
import net.atlanticbb.tantlinger.ui.text.actions.EnterKeyAction;
import net.atlanticbb.tantlinger.ui.text.actions.PasteAction;
import net.atlanticbb.tantlinger.ui.text.actions.RemoveAction;
import net.atlanticbb.tantlinger.ui.text.actions.TabAction;

public class WysiwygHTMLEditorKit
extends HTMLEditorKit {
    private static final long serialVersionUID = 1L;
    private ViewFactory wysFactory = new WysiwygHTMLFactory();
    private ArrayList monitoredViews = new ArrayList();
    private MouseInputAdapter resizeHandler = new ResizeHandler();
    private Map editorToActionsMap = new HashMap();
    private KeyStroke tabBackwardKS = KeyStroke.getKeyStroke(9, 64);

    public Document createDefaultDocument() {
        HTMLDocument doc = (HTMLDocument)super.createDefaultDocument();
        doc.putProperty("IgnoreCharsetDirective", Boolean.TRUE);
        return doc;
    }

    public void install(JEditorPane ed) {
        super.install(ed);
        if (this.editorToActionsMap.containsKey(ed)) {
            return;
        }
        ed.addMouseListener(this.resizeHandler);
        ed.addMouseMotionListener(this.resizeHandler);
        HashMap<String, Action> actions = new HashMap<String, Action>();
        InputMap inputMap = ed.getInputMap(0);
        ActionMap actionMap = ed.getActionMap();
        Action delegate = actionMap.get("insert-break");
        DecoratedTextAction action = new EnterKeyAction(delegate);
        actions.put("insert-break", action);
        actionMap.put("insert-break", action);
        delegate = actionMap.get("delete-previous");
        action = new RemoveAction(0, delegate);
        actions.put("delete-previous", action);
        actionMap.put("delete-previous", action);
        delegate = actionMap.get("delete-next");
        action = new RemoveAction(1, delegate);
        actions.put("delete-next", action);
        actionMap.put("delete-next", action);
        delegate = actionMap.get("insert-tab");
        action = new TabAction(0, delegate);
        actions.put("insert-tab", action);
        actionMap.put("insert-tab", action);
        delegate = actionMap.get("paste-from-clipboard");
        PasteAction hteAction = new PasteAction();
        hteAction.putContextValue("editor", ed);
        actions.put("paste-from-clipboard", delegate);
        actionMap.put("paste-from-clipboard", (Action)((Object)hteAction));
        inputMap.put(this.tabBackwardKS, "tab-backward");
        action = new TabAction(1, delegate);
        actions.put("tab-backward", action);
        actionMap.put("tab-backward", action);
        this.editorToActionsMap.put(ed, actions);
    }

    public void deinstall(JEditorPane ed) {
        super.deinstall(ed);
        if (!this.editorToActionsMap.containsKey(ed)) {
            return;
        }
        ed.removeMouseListener(this.resizeHandler);
        ed.removeMouseMotionListener(this.resizeHandler);
        ActionMap actionMap = ed.getActionMap();
        Map actions = (Map)this.editorToActionsMap.get(ed);
        Action curAct = actionMap.get("insert-break");
        if (curAct == actions.get("insert-break")) {
            actionMap.put("insert-break", ((DecoratedTextAction)curAct).getDelegate());
        }
        if ((curAct = actionMap.get("delete-previous")) == actions.get("delete-previous")) {
            actionMap.put("delete-previous", ((DecoratedTextAction)curAct).getDelegate());
        }
        if ((curAct = actionMap.get("delete-next")) == actions.get("delete-next")) {
            actionMap.put("delete-next", ((DecoratedTextAction)curAct).getDelegate());
        }
        if ((curAct = actionMap.get("insert-tab")) == actions.get("insert-tab")) {
            actionMap.put("insert-tab", ((DecoratedTextAction)curAct).getDelegate());
        }
        if ((curAct = actionMap.get("paste-from-clipboard")) instanceof PasteAction) {
            actionMap.put("paste-from-clipboard", (Action)actions.get("paste-from-clipboard"));
        }
        if ((curAct = actionMap.get("tab-backward")) == actions.get("insert-tab")) {
            actionMap.remove("tab-backward");
        }
        this.editorToActionsMap.remove(ed);
    }

    public ViewFactory getViewFactory() {
        return this.wysFactory;
    }

    private class UnknownElementView
    extends ComponentView {
        public UnknownElementView(Element e) {
            super(e);
        }

        protected Component createComponent() {
            JLabel p = new JLabel();
            if (this.getElement().getAttributes().getAttribute(StyleConstants.NameAttribute) == HTML.Tag.COMMENT) {
                Object comment;
                p.setText("<!-- -->");
                AttributeSet as = this.getElement().getAttributes();
                if (as != null && (comment = as.getAttribute(HTML.Attribute.COMMENT)) instanceof String) {
                    p.setToolTipText((String)comment);
                }
            } else {
                String text = this.getElement().getName();
                if (text == null || text.equals("")) {
                    text = "??";
                }
                text = this.isEndTag() ? "</" + text + ">" : "<" + text + ">";
                p.setText(text);
            }
            p.setBorder(BorderFactory.createRaisedBevelBorder());
            p.setBackground(Color.YELLOW);
            p.setForeground(Color.BLUE);
            p.setOpaque(true);
            return p;
        }

        boolean isEndTag() {
            Object end;
            AttributeSet as = this.getElement().getAttributes();
            return as != null && (end = as.getAttribute(HTML.Attribute.ENDTAG)) != null && end instanceof String && ((String)end).equals("true");
        }
    }

    private class BorderlessTableView
    extends DelegateView {
        public BorderlessTableView(View delegate) {
            super(delegate);
        }

        public void paint(Graphics g, Shape allocation) {
            if (this.shouldDrawDottedBorder()) {
                Color bgColor = this.getTableBgcolor();
                if (bgColor != null) {
                    Color cachedColor = g.getColor();
                    g.setColor(bgColor);
                    Rectangle tr = allocation.getBounds();
                    g.fillRect(tr.x, tr.y, tr.width, tr.height);
                    g.setColor(cachedColor);
                }
                this.delegate.paint(g, allocation);
                Graphics2D g2 = (Graphics2D)g;
                Stroke cachedStroke = g2.getStroke();
                float[] dash = new float[]{3.0f};
                BasicStroke stroke = new BasicStroke(1.0f, 0, 0, 10.0f, dash, 0.0f);
                g2.setStroke(stroke);
                g2.setColor(Color.DARK_GRAY);
                int rows = this.getViewCount();
                for (int r = 0; r < rows; ++r) {
                    Shape rowShape = this.getChildAllocation(r, allocation);
                    View rowView = this.getView(r);
                    int cells = rowView.getViewCount();
                    for (int c = 0; c < cells; ++c) {
                        Shape cellShape = rowView.getChildAllocation(c, rowShape);
                        Rectangle cr = cellShape.getBounds();
                        g2.drawRect(cr.x, cr.y, cr.width, cr.height);
                    }
                }
                g2.setStroke(cachedStroke);
            } else {
                this.delegate.paint(g, allocation);
            }
        }

        private Color getTableBgcolor() {
            AttributeSet atr = this.getElement().getAttributes();
            Object o = atr.getAttribute(HTML.Attribute.BGCOLOR);
            if (o != null) {
                Color c = HTMLUtils.stringToColor(o.toString());
                return c;
            }
            return null;
        }

        private boolean shouldDrawDottedBorder() {
            AttributeSet atr = this.getElement().getAttributes();
            boolean isBorderAttr = this.hasBorderAttr(atr);
            return !isBorderAttr || isBorderAttr && atr.getAttribute(HTML.Attribute.BORDER).toString().equals("0");
        }

        private boolean hasBorderAttr(AttributeSet atr) {
            Enumeration<?> e = atr.getAttributeNames();
            while (e.hasMoreElements()) {
                if (!e.nextElement().toString().equals("border")) continue;
                return true;
            }
            return false;
        }
    }

    private class ResizableView
    extends DelegateView {
        public static final int NW = 0;
        public static final int NE = 1;
        public static final int SW = 2;
        public static final int SE = 3;
        public static final int N = 4;
        public static final int S = 5;
        public static final int E = 6;
        public static final int W = 7;
        private Rectangle curBounds;
        private Rectangle selBounds;

        public ResizableView(View delegate) {
            super(delegate);
        }

        public void paint(Graphics g, Shape allocation) {
            this.curBounds = new Rectangle(allocation.getBounds());
            this.delegate.paint(g, allocation);
            this.drawSelectionHandles(g);
        }

        public void insertUpdate(DocumentEvent e, Shape a, ViewFactory f) {
            this.setSelectionEnabled(false);
            super.insertUpdate(e, a, f);
        }

        public void changedUpdate(DocumentEvent e, Shape a, ViewFactory f) {
            this.setSelectionEnabled(false);
            super.changedUpdate(e, a, f);
        }

        public void removeUpdate(DocumentEvent e, Shape a, ViewFactory f) {
            this.setSelectionEnabled(false);
            super.removeUpdate(e, a, f);
        }

        public Rectangle getBounds() {
            return this.curBounds;
        }

        public Rectangle getSelectionBounds() {
            return this.selBounds;
        }

        public void setSelectionEnabled(boolean b) {
            this.selBounds = b && this.curBounds != null ? new Rectangle(this.curBounds) : null;
        }

        public boolean isSelectionEnabled() {
            return this.selBounds != null;
        }

        public int getHandleForPoint(Point p) {
            if (this.isSelectionEnabled()) {
                Rectangle[] r = this.computeHandles(this.selBounds);
                for (int i = 0; i < r.length; ++i) {
                    if (!r[i].contains(p)) continue;
                    return i;
                }
            }
            return -1;
        }

        private void drawSelectionHandles(Graphics g) {
            if (!this.isSelectionEnabled()) {
                return;
            }
            Color cached = g.getColor();
            g.setColor(Color.DARK_GRAY);
            g.drawRect(this.selBounds.x, this.selBounds.y, this.selBounds.width, this.selBounds.height);
            Rectangle[] h = this.computeHandles(this.selBounds);
            for (int i = 0; i < h.length; ++i) {
                g.fillRect(h[i].x, h[i].y, h[i].width, h[i].height);
            }
            g.setColor(cached);
        }

        private Rectangle[] computeHandles(Rectangle sel) {
            Rectangle[] r = new Rectangle[8];
            int sq = 8;
            r[0] = new Rectangle(sel.x, sel.y, sq, sq);
            r[1] = new Rectangle(sel.x + sel.width - sq, sel.y, sq, sq);
            r[2] = new Rectangle(sel.x, sel.y + sel.height - sq, sq, sq);
            r[3] = new Rectangle(sel.x + sel.width - sq, sel.y + sel.height - sq, sq, sq);
            int midX = sel.x + (sel.width / 2 - sq / 2);
            int midY = sel.y + (sel.height / 2 - sq / 2);
            r[4] = new Rectangle(midX, sel.y, sq, sq);
            r[5] = new Rectangle(midX, sel.y + sel.height - sq, sq, sq);
            r[6] = new Rectangle(sel.x + sel.width - sq, midY, sq, sq);
            r[7] = new Rectangle(sel.x, midY, sq, sq);
            return r;
        }
    }

    private class ResizeHandler
    extends MouseInputAdapter {
        boolean dragStarted;
        boolean mouseDown;
        int dragDir = -1;

        private ResizeHandler() {
        }

        public void mousePressed(MouseEvent e) {
            this.mouseDown = true;
            boolean selected = false;
            for (int i = WysiwygHTMLEditorKit.this.monitoredViews.size() - 1; i >= 0; --i) {
                ResizableView v = (ResizableView)WysiwygHTMLEditorKit.this.monitoredViews.get(i);
                Rectangle r = v.getBounds();
                if (r != null && r.contains(e.getPoint()) && !selected) {
                    v.setSelectionEnabled(true);
                    this.dragDir = v.getHandleForPoint(e.getPoint());
                    this.setCursorForDir(this.dragDir, e.getComponent());
                    selected = true;
                    continue;
                }
                v.setSelectionEnabled(false);
            }
            e.getComponent().repaint();
        }

        public void mouseMoved(MouseEvent e) {
            if (!this.mouseDown) {
                ResizableView v = this.getSelectedView();
                if (v == null) {
                    return;
                }
                Component c = e.getComponent();
                this.setCursorForDir(v.getHandleForPoint(e.getPoint()), c);
            }
        }

        public void mouseDragged(MouseEvent e) {
            this.dragStarted = this.dragDir != -1;
            ResizableView v = this.getSelectedView();
            if (v == null || !this.dragStarted) {
                return;
            }
            Rectangle r = v.getSelectionBounds();
            if (this.dragDir == 3) {
                r.width = e.getX() - r.x;
                r.height = e.getY() - r.y;
            } else if (this.dragDir == 1) {
                r.width = e.getX() - r.x;
                r.height = r.y + r.height - e.getY();
                r.y = e.getY();
            } else if (this.dragDir == 2) {
                r.width = r.x + r.width - e.getX();
                r.height = e.getY() - r.y;
                r.x = e.getX();
            } else if (this.dragDir == 0) {
                r.width = r.x + r.width - e.getX();
                r.height = r.y + r.height - e.getY();
                r.x = e.getX();
                r.y = e.getY();
            } else if (this.dragDir == 4) {
                r.height = r.y + r.height - e.getY();
                r.y = e.getY();
            } else if (this.dragDir == 5) {
                r.height = e.getY() - r.y;
            } else if (this.dragDir == 6) {
                r.width = e.getX() - r.x;
            } else if (this.dragDir == 7) {
                r.width = r.x + r.width - e.getX();
                r.x = e.getX();
            }
            e.getComponent().repaint();
        }

        public void mouseReleased(MouseEvent e) {
            this.mouseDown = false;
            ResizableView v = this.getSelectedView();
            if (v != null && this.dragStarted) {
                Element elem = v.getElement();
                SimpleAttributeSet sas = new SimpleAttributeSet(elem.getAttributes());
                Integer w = new Integer(v.getSelectionBounds().width);
                Integer h = new Integer(v.getSelectionBounds().height);
                if (elem.getName().equals("table")) {
                    sas.addAttribute(HTML.Attribute.WIDTH, w);
                    String html = HTMLUtils.getElementHTML(elem, false);
                    html = HTMLUtils.createTag(HTML.Tag.TABLE, sas, html);
                    this.replace(elem, html);
                } else if (elem.getName().equals("img")) {
                    sas.addAttribute(HTML.Attribute.WIDTH, w);
                    sas.addAttribute(HTML.Attribute.HEIGHT, h);
                    String html = "<img";
                    Enumeration<?> ee = sas.getAttributeNames();
                    while (ee.hasMoreElements()) {
                        Object name = ee.nextElement();
                        if (name.toString().equals("name") || name.toString().equals("a")) continue;
                        Object val = sas.getAttribute(name);
                        html = html + " " + name + "=\"" + val + "\"";
                    }
                    html = html + ">";
                    if (sas.isDefined(HTML.Tag.A)) {
                        html = "<a " + sas.getAttribute(HTML.Tag.A) + ">" + html + "</a>";
                    }
                    this.replace(elem, html);
                }
                this.updateMonitoredViews((HTMLDocument)v.getDocument());
            }
            this.dragStarted = false;
        }

        private void setCursorForDir(int d, Component c) {
            if (d == 0) {
                c.setCursor(Cursor.getPredefinedCursor(6));
            } else if (d == 2) {
                c.setCursor(Cursor.getPredefinedCursor(4));
            } else if (d == 1) {
                c.setCursor(Cursor.getPredefinedCursor(7));
            } else if (d == 3) {
                c.setCursor(Cursor.getPredefinedCursor(5));
            } else if (d == 4) {
                c.setCursor(Cursor.getPredefinedCursor(8));
            } else if (d == 5) {
                c.setCursor(Cursor.getPredefinedCursor(9));
            } else if (d == 6) {
                c.setCursor(Cursor.getPredefinedCursor(11));
            } else if (d == 7) {
                c.setCursor(Cursor.getPredefinedCursor(10));
            } else if (c.getCursor().getType() != 0) {
                c.setCursor(Cursor.getDefaultCursor());
            }
        }

        private void updateMonitoredViews(HTMLDocument doc) {
            Iterator it = WysiwygHTMLEditorKit.this.monitoredViews.iterator();
            while (it.hasNext()) {
                Element el;
                View v = (View)it.next();
                Element vElem = v.getElement();
                if (vElem.getName().equals("img")) {
                    el = doc.getCharacterElement(vElem.getStartOffset());
                    if (el == vElem) continue;
                    it.remove();
                    continue;
                }
                if (!vElem.getName().equals("table")) continue;
                el = doc.getParagraphElement(vElem.getStartOffset());
                if ((el = HTMLUtils.getParent(el, HTML.Tag.TABLE)) == vElem) continue;
                it.remove();
            }
        }

        private ResizableView getSelectedView() {
            for (ResizableView v : WysiwygHTMLEditorKit.this.monitoredViews) {
                if (!v.isSelectionEnabled()) continue;
                return v;
            }
            return null;
        }

        private void replace(Element elem, String html) {
            HTMLDocument document = (HTMLDocument)elem.getDocument();
            CompoundUndoManager.beginCompoundEdit(document);
            try {
                document.setOuterHTML(elem, html);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            CompoundUndoManager.endCompoundEdit(document);
        }
    }

    public class WysiwygHTMLFactory
    extends HTMLEditorKit.HTMLFactory {
        public View create(Element elem) {
            Object o = elem.getAttributes().getAttribute(StyleConstants.NameAttribute);
            if (o instanceof HTML.Tag) {
                HTML.Tag kind = (HTML.Tag)o;
                if (kind == HTML.Tag.TABLE) {
                    ResizableView v = new ResizableView(new BorderlessTableView(super.create(elem)));
                    WysiwygHTMLEditorKit.this.monitoredViews.add(v);
                    return v;
                }
                if (kind == HTML.Tag.IMG) {
                    ResizableView v = new ResizableView(super.create(elem));
                    WysiwygHTMLEditorKit.this.monitoredViews.add(v);
                    return v;
                }
                if (kind == HTML.Tag.COMMENT) {
                    return new UnknownElementView(elem);
                }
                if (kind == HTML.Tag.OBJECT) {
                    ObjectView ov = new ObjectView(elem){

                        protected Component createComponent() {
                            JLabel l;
                            Component comp = super.createComponent();
                            if (comp instanceof JLabel && (l = (JLabel)comp).getText().equals("??") && l.getForeground().equals(Color.red)) {
                                l.setIcon(UIUtils.getIcon("resources/images/x24/", "cogs.png"));
                                l.setText(null);
                                l.setBackground(Color.YELLOW);
                                l.setOpaque(true);
                                l.setBorder(BorderFactory.createRaisedBevelBorder());
                                l.setToolTipText("<object></object>");
                            }
                            return comp;
                        }
                    };
                    return ov;
                }
                if (kind instanceof HTML.UnknownTag || kind == HTML.Tag.TITLE || kind == HTML.Tag.META || kind == HTML.Tag.LINK || kind == HTML.Tag.STYLE || kind == HTML.Tag.SCRIPT || kind == HTML.Tag.AREA || kind == HTML.Tag.MAP || kind == HTML.Tag.PARAM || kind == HTML.Tag.APPLET) {
                    return new UnknownElementView(elem);
                }
            }
            return super.create(elem);
        }
    }
}

