/*
 * Decompiled with CFR 0.152.
 */
package net.atlanticbb.tantlinger.ui.text.actions;

import java.awt.event.ActionEvent;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import javax.swing.JEditorPane;
import javax.swing.KeyStroke;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import net.atlanticbb.tantlinger.ui.UIUtils;
import net.atlanticbb.tantlinger.ui.text.CompoundUndoManager;
import net.atlanticbb.tantlinger.ui.text.ElementWriter;
import net.atlanticbb.tantlinger.ui.text.HTMLUtils;
import net.atlanticbb.tantlinger.ui.text.actions.HTMLTextEditAction;

public class HTMLBlockAction
extends HTMLTextEditAction {
    private static final long serialVersionUID = 1L;
    public static final int DIV = 0;
    public static final int P = 1;
    public static final int H1 = 2;
    public static final int H2 = 3;
    public static final int H3 = 4;
    public static final int H4 = 5;
    public static final int H5 = 6;
    public static final int H6 = 7;
    public static final int PRE = 8;
    public static final int BLOCKQUOTE = 9;
    public static final int OL = 10;
    public static final int UL = 11;
    private static final int[] KEYS = new int[]{68, 10, 49, 50, 51, 52, 53, 54, 82, 81, 78, 85};
    public static final String[] ELEMENT_TYPES = new String[]{i18n.str("body_text"), i18n.str("paragraph"), i18n.str("heading") + " 1", i18n.str("heading") + " 2", i18n.str("heading") + " 3", i18n.str("heading") + " 4", i18n.str("heading") + " 5", i18n.str("heading") + " 6", i18n.str("preformatted"), i18n.str("blockquote"), i18n.str("ordered_list"), i18n.str("unordered_list")};
    private int type;

    public HTMLBlockAction(int type) throws IllegalArgumentException {
        super("");
        if (type < 0 || type >= ELEMENT_TYPES.length) {
            throw new IllegalArgumentException("Illegal argument");
        }
        this.type = type;
        this.putValue("Name", ELEMENT_TYPES[type]);
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(KEYS[type], 8));
        if (type == 1) {
            this.putValue("MnemonicKey", new Integer(i18n.mnem("paragraph")));
        } else if (type == 8) {
            this.putValue("MnemonicKey", new Integer(i18n.mnem("preformatted")));
        } else if (type == 9) {
            this.putValue("MnemonicKey", new Integer(i18n.mnem("blockquote")));
        } else if (type == 10) {
            this.putValue("SmallIcon", UIUtils.getIcon("resources/images/x16/", "listordered.png"));
            this.putValue("MnemonicKey", new Integer(i18n.mnem("ordered_list")));
        } else if (type == 11) {
            this.putValue("SmallIcon", UIUtils.getIcon("resources/images/x16/", "listunordered.png"));
            this.putValue("MnemonicKey", new Integer(i18n.mnem("unordered_list")));
        } else {
            String s = type + "";
            this.putValue("MnemonicKey", new Integer(s.charAt(0)));
        }
        this.putValue("BUTTON_TYPE", "radio");
        this.putValue("ShortDescription", this.getValue("Name"));
    }

    protected void updateWysiwygContextState(JEditorPane ed) {
        HTMLDocument document = (HTMLDocument)ed.getDocument();
        Element elem = document.getParagraphElement(ed.getCaretPosition());
        String elemName = elem.getName();
        if (elemName.equals("p-implied")) {
            elemName = elem.getParentElement().getName();
        }
        if (this.type == 0 && (elemName.equals("div") || elemName.equals("body") || elemName.equals("td"))) {
            this.setSelected(true);
        } else if (this.type == 11) {
            Element listElem = HTMLUtils.getListParent(elem);
            this.setSelected(listElem != null && listElem.getName().equals("ul"));
        } else if (this.type == 10) {
            Element listElem = HTMLUtils.getListParent(elem);
            this.setSelected(listElem != null && listElem.getName().equals("ol"));
        } else if (elemName.equals(this.getTag().toString().toLowerCase())) {
            this.setSelected(true);
        } else {
            this.setSelected(false);
        }
    }

    protected void updateSourceContextState(JEditorPane ed) {
        this.setSelected(false);
    }

    protected void sourceEditPerformed(ActionEvent e, JEditorPane editor) {
        String sel;
        String tag = this.getTag().toString();
        String prefix = "\n<" + tag + ">\n\t";
        String postfix = "\n</" + tag + ">\n";
        if (this.type == 10 || this.type == 11) {
            prefix = prefix + "<li>";
            postfix = "</li>" + postfix;
        }
        if ((sel = editor.getSelectedText()) == null) {
            editor.replaceSelection(prefix + postfix);
            int pos = editor.getCaretPosition() - postfix.length();
            if (pos >= 0) {
                editor.setCaretPosition(pos);
            }
        } else {
            sel = prefix + sel + postfix;
            editor.replaceSelection(sel);
        }
    }

    protected void wysiwygEditPerformed(ActionEvent e, JEditorPane editor) {
        HTMLDocument document = (HTMLDocument)editor.getDocument();
        int caret = editor.getCaretPosition();
        CompoundUndoManager.beginCompoundEdit(document);
        try {
            if (this.type == 10 || this.type == 11) {
                this.insertList(editor, e);
            } else {
                this.changeBlockType(editor, e);
            }
            editor.setCaretPosition(caret);
        }
        catch (Exception awwCrap) {
            awwCrap.printStackTrace();
        }
        CompoundUndoManager.endCompoundEdit(document);
    }

    private HTML.Tag getRootTag(Element elem) {
        HTML.Tag root = HTML.Tag.BODY;
        if (HTMLUtils.getParent(elem, HTML.Tag.TD) != null) {
            root = HTML.Tag.TD;
        }
        return root;
    }

    private void insertHTML(String html, HTML.Tag tag, HTML.Tag root, ActionEvent e) {
        HTMLEditorKit.InsertHTMLTextAction a = new HTMLEditorKit.InsertHTMLTextAction("insertHTML", html, root, tag);
        a.actionPerformed(e);
    }

    private void changeListType(Element listParent, HTML.Tag replaceTag, HTMLDocument document) {
        StringWriter out = new StringWriter();
        ElementWriter w = new ElementWriter((Writer)out, listParent);
        try {
            w.write();
            String html = out.toString();
            html = html.substring(html.indexOf(62) + 1, html.length());
            html = html.substring(0, html.lastIndexOf(60));
            html = '<' + replaceTag.toString() + '>' + html + "</" + replaceTag.toString() + '>';
            document.setOuterHTML(listParent, html);
        }
        catch (Exception idiotic) {
            // empty catch block
        }
    }

    private void insertList(JEditorPane editor, ActionEvent e) throws BadLocationException {
        HTMLDocument document = (HTMLDocument)editor.getDocument();
        int caretPos = editor.getCaretPosition();
        Element elem = document.getParagraphElement(caretPos);
        HTML.Tag parentTag = HTML.getTag(elem.getParentElement().getName());
        Element listParent = elem.getParentElement().getParentElement();
        HTML.Tag listTag = HTML.getTag(listParent.getName());
        if (listTag.equals(HTML.Tag.UL) || listTag.equals(HTML.Tag.OL)) {
            HTML.Tag t = HTML.getTag(listParent.getName());
            if (this.type == 10 && t.equals(HTML.Tag.UL)) {
                this.changeListType(listParent, HTML.Tag.OL, document);
                return;
            }
            if (this.type == 11 && listTag.equals(HTML.Tag.OL)) {
                this.changeListType(listParent, HTML.Tag.UL, document);
                return;
            }
        }
        if (!parentTag.equals(HTML.Tag.LI)) {
            this.changeBlockType(editor, e);
        } else {
            HTML.Tag root = this.getRootTag(elem);
            String txt = HTMLUtils.getElementHTML(elem, false);
            editor.setCaretPosition(elem.getEndOffset());
            this.insertHTML("<p>" + txt + "</p>", HTML.Tag.P, root, e);
            HTMLUtils.removeElement(elem);
        }
    }

    private void changeBlockType(JEditorPane editor, ActionEvent e) throws BadLocationException {
        Element ckTD;
        HTMLDocument doc = (HTMLDocument)editor.getDocument();
        Element curE = doc.getParagraphElement(editor.getSelectionStart());
        Element endE = doc.getParagraphElement(editor.getSelectionEnd());
        Element curTD = HTMLUtils.getParent(curE, HTML.Tag.TD);
        HTML.Tag tag = this.getTag();
        HTML.Tag rootTag = this.getRootTag(curE);
        String html = "";
        if (this.isListType()) {
            html = "<" + this.getTag() + ">";
            tag = HTML.Tag.LI;
        }
        ArrayList<Element> elToRemove = new ArrayList<Element>();
        elToRemove.add(curE);
        do {
            html = html + HTMLUtils.createTag(tag, curE.getAttributes(), HTMLUtils.getElementHTML(curE, false));
            if (curE.getEndOffset() >= endE.getEndOffset() || curE.getEndOffset() >= doc.getLength()) break;
            curE = doc.getParagraphElement(curE.getEndOffset() + 1);
            elToRemove.add(curE);
        } while ((ckTD = HTMLUtils.getParent(curE, HTML.Tag.TD)) == null || ckTD.equals(curTD));
        if (this.isListType()) {
            html = html + "</" + this.getTag() + ">";
        }
        editor.setCaretPosition(curE.getStartOffset());
        this.insertHTML(html, this.getTag(), rootTag, e);
        for (Element c : elToRemove) {
            HTMLUtils.removeElement(c);
        }
    }

    private boolean isListType() {
        return this.type == 10 || this.type == 11;
    }

    public HTML.Tag getTag() {
        HTML.Tag tag = HTML.Tag.DIV;
        switch (this.type) {
            case 1: {
                tag = HTML.Tag.P;
                break;
            }
            case 2: {
                tag = HTML.Tag.H1;
                break;
            }
            case 3: {
                tag = HTML.Tag.H2;
                break;
            }
            case 4: {
                tag = HTML.Tag.H3;
                break;
            }
            case 5: {
                tag = HTML.Tag.H4;
                break;
            }
            case 6: {
                tag = HTML.Tag.H5;
                break;
            }
            case 7: {
                tag = HTML.Tag.H6;
                break;
            }
            case 8: {
                tag = HTML.Tag.PRE;
                break;
            }
            case 11: {
                tag = HTML.Tag.UL;
                break;
            }
            case 10: {
                tag = HTML.Tag.OL;
                break;
            }
            case 9: {
                tag = HTML.Tag.BLOCKQUOTE;
                break;
            }
            case 0: {
                tag = HTML.Tag.DIV;
            }
        }
        return tag;
    }
}

