/*
 * Decompiled with CFR 0.152.
 */
package net.atlanticbb.tantlinger.ui.text.actions;

import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import javax.swing.text.html.HTML;
import net.atlanticbb.tantlinger.ui.UIUtils;
import net.atlanticbb.tantlinger.ui.text.HTMLUtils;
import net.atlanticbb.tantlinger.ui.text.actions.HTMLTextEditAction;
import net.atlanticbb.tantlinger.ui.text.dialogs.ImageDialog;

public class HTMLImageAction
extends HTMLTextEditAction {
    private static final long serialVersionUID = 1L;

    public HTMLImageAction() {
        super(i18n.str("image_"));
        this.putValue("SmallIcon", UIUtils.getIcon("resources/images/x16/", "image.png"));
        this.putValue("ShortDescription", this.getValue("Name"));
    }

    protected void sourceEditPerformed(ActionEvent e, JEditorPane editor) {
        ImageDialog d = this.createDialog(editor);
        d.setLocationRelativeTo(d.getParent());
        d.setVisible(true);
        if (d.hasUserCancelled()) {
            return;
        }
        editor.requestFocusInWindow();
        editor.replaceSelection(d.getHTML());
    }

    protected void wysiwygEditPerformed(ActionEvent e, JEditorPane editor) {
        ImageDialog d = this.createDialog(editor);
        d.setLocationRelativeTo(d.getParent());
        d.setVisible(true);
        if (d.hasUserCancelled()) {
            return;
        }
        String tagText = d.getHTML();
        if (editor.getCaretPosition() == editor.getDocument().getLength()) {
            tagText = tagText + "&nbsp;";
        }
        editor.replaceSelection("");
        HTML.Tag tag = HTML.Tag.IMG;
        if (tagText.startsWith("<a")) {
            tag = HTML.Tag.A;
        }
        HTMLUtils.insertHTML(tagText, tag, editor);
    }

    protected ImageDialog createDialog(JTextComponent ed) {
        Window w = SwingUtilities.getWindowAncestor(ed);
        ImageDialog d = null;
        if (w != null && w instanceof Frame) {
            d = new ImageDialog((Frame)w);
        } else if (w != null && w instanceof Dialog) {
            d = new ImageDialog((Dialog)w);
        }
        return d;
    }
}

