/*
 * Decompiled with CFR 0.152.
 */
package net.atlanticbb.tantlinger.ui.text.actions;

import java.awt.event.ActionEvent;
import javax.swing.JEditorPane;
import javax.swing.KeyStroke;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import net.atlanticbb.tantlinger.ui.UIUtils;
import net.atlanticbb.tantlinger.ui.text.actions.HTMLTextEditAction;

public class HTMLLineBreakAction
extends HTMLTextEditAction {
    private static final long serialVersionUID = 1L;

    public HTMLLineBreakAction() {
        super(i18n.str("line_break"));
        this.putValue("MnemonicKey", new Integer(i18n.mnem("line_break")));
        this.putValue("SmallIcon", UIUtils.getIcon("resources/images/x16/", "br.png"));
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(10, 1));
        this.putValue("ShortDescription", this.getValue("Name"));
    }

    protected void sourceEditPerformed(ActionEvent e, JEditorPane editor) {
        editor.replaceSelection("<br>\n");
    }

    protected void wysiwygEditPerformed(ActionEvent e, JEditorPane editor) {
        HTMLDocument document = (HTMLDocument)editor.getDocument();
        int pos = editor.getCaretPosition();
        String elName = document.getParagraphElement(pos).getName();
        HTML.Tag tag = HTML.getTag(elName);
        if (elName.toUpperCase().equals("P-IMPLIED")) {
            tag = HTML.Tag.IMPLIED;
        }
        HTMLEditorKit.InsertHTMLTextAction hta = new HTMLEditorKit.InsertHTMLTextAction("insertBR", "<br>", tag, HTML.Tag.BR);
        hta.actionPerformed(e);
    }
}

