/*
 * Decompiled with CFR 0.152.
 */
package net.atlanticbb.tantlinger.ui.text.actions;

import java.awt.event.ActionEvent;
import javax.swing.Action;
import javax.swing.JEditorPane;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import net.atlanticbb.tantlinger.i18n.I18n;
import net.atlanticbb.tantlinger.ui.DefaultAction;
import org.bushe.swing.action.ShouldBeEnabledDelegate;

public abstract class HTMLTextEditAction
extends DefaultAction {
    static final I18n i18n = I18n.getInstance("net.atlanticbb.tantlinger.ui.text.actions");
    public static final String EDITOR = "editor";
    public static final int DISABLED = -1;
    public static final int WYSIWYG = 0;
    public static final int SOURCE = 1;

    public HTMLTextEditAction(String name) {
        super(name);
        this.addShouldBeEnabledDelegate(new ShouldBeEnabledDelegate(){

            public boolean shouldBeEnabled(Action a) {
                return HTMLTextEditAction.this.getEditMode() != -1;
            }
        });
        this.updateEnabledState();
    }

    public void execute(ActionEvent e) throws Exception {
        if (this.getEditMode() == 0) {
            this.wysiwygEditPerformed(e, this.getCurrentEditor());
        } else if (this.getEditMode() == 1) {
            this.sourceEditPerformed(e, this.getCurrentEditor());
        }
    }

    public int getEditMode() {
        JEditorPane ep = this.getCurrentEditor();
        if (ep == null) {
            return -1;
        }
        if (ep.getDocument() instanceof HTMLDocument && ep.getEditorKit() instanceof HTMLEditorKit) {
            return 0;
        }
        return 1;
    }

    protected JEditorPane getCurrentEditor() {
        try {
            JEditorPane ep = (JEditorPane)this.getContextValue(EDITOR);
            return ep;
        }
        catch (ClassCastException classCastException) {
            return null;
        }
    }

    protected void actionPerformedCatch(Throwable t) {
        t.printStackTrace();
    }

    protected void contextChanged() {
        if (this.getEditMode() == 0) {
            this.updateWysiwygContextState(this.getCurrentEditor());
        } else if (this.getEditMode() == 1) {
            this.updateSourceContextState(this.getCurrentEditor());
        }
    }

    protected void updateWysiwygContextState(JEditorPane wysEditor) {
    }

    protected void updateSourceContextState(JEditorPane srcEditor) {
    }

    protected abstract void wysiwygEditPerformed(ActionEvent var1, JEditorPane var2);

    protected abstract void sourceEditPerformed(ActionEvent var1, JEditorPane var2);
}

