/*
 * Decompiled with CFR 0.152.
 */
package net.atlanticbb.tantlinger.ui.text.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.JEditorPane;
import javax.swing.text.Element;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import net.atlanticbb.tantlinger.ui.text.CompoundUndoManager;
import net.atlanticbb.tantlinger.ui.text.HTMLUtils;
import net.atlanticbb.tantlinger.ui.text.actions.HTMLTextEditAction;

public class IndentAction
extends HTMLTextEditAction {
    private static final long serialVersionUID = 1L;
    public static final int INDENT = 0;
    public static final int OUTDENT = 1;
    protected int direction;

    public IndentAction(int direction) throws IllegalArgumentException {
        super("");
        if (direction == 0) {
            this.putValue("Name", "Indent");
        } else if (direction == 1) {
            this.putValue("Name", "Outdent");
        } else {
            throw new IllegalArgumentException("Invalid indentation direction");
        }
        this.direction = direction;
    }

    protected void sourceEditPerformed(ActionEvent e, JEditorPane editor) {
    }

    private void insertHTML(String html, HTML.Tag tag, HTML.Tag root, ActionEvent e) {
        HTMLEditorKit.InsertHTMLTextAction a = new HTMLEditorKit.InsertHTMLTextAction("insertHTML", html, root, tag);
        a.actionPerformed(e);
    }

    private HTML.Tag getRootTag(Element elem) {
        HTML.Tag root = HTML.Tag.BODY;
        if (HTMLUtils.getListParent(elem) != null) {
            root = HTML.Tag.UL;
        } else if (HTMLUtils.getParent(elem, HTML.Tag.TD) != null) {
            root = HTML.Tag.TD;
        } else if (HTMLUtils.getParent(elem, HTML.Tag.BLOCKQUOTE) != null) {
            root = HTML.Tag.BLOCKQUOTE;
        }
        return root;
    }

    private int getIndentationLevel(Element el) {
        int level = 0;
        while (!el.getName().equals("body") && !el.getName().equals("td")) {
            if (el.getName().equals("blockquote")) {
                ++level;
            }
            el = el.getParentElement();
        }
        return level;
    }

    private Map getListElems(List elems) {
        HashMap lis = new HashMap();
        Iterator it = elems.iterator();
        while (it.hasNext()) {
            Element li = HTMLUtils.getParent((Element)it.next(), HTML.Tag.LI);
            if (li == null) continue;
            Element listEl = HTMLUtils.getListParent(li);
            if (!lis.containsKey(listEl)) {
                lis.put(listEl, new ArrayList());
            }
            List elList = (List)lis.get(listEl);
            elList.add(li);
        }
        return lis;
    }

    private void unindent(ActionEvent e, JEditorPane editor) {
        List elems = this.getParagraphElements(editor);
        if (elems.size() == 0) {
            return;
        }
        List listElems = this.getLeadingTralingListElems(elems);
        elems.removeAll(listElems);
        HashSet<Element> elsToIndent = new HashSet<Element>();
        HashSet<Element> elsToOutdent = new HashSet<Element>();
        Element lastBqParent = null;
        for (int i = 0; i < elems.size(); ++i) {
            Element el = (Element)elems.get(i);
            Element bqParent = HTMLUtils.getParent(el, HTML.Tag.BLOCKQUOTE);
            if (bqParent == null) continue;
            if (lastBqParent == null || bqParent.getStartOffset() >= lastBqParent.getEndOffset()) {
                elsToOutdent.add(bqParent);
                lastBqParent = bqParent;
            }
            if (i != 0 && i != elems.size() - 1) continue;
            int c = bqParent.getElementCount();
            for (int j = 0; j < c; ++j) {
                Element bqChild = bqParent.getElement(j);
                int start = bqChild.getStartOffset();
                int end = bqChild.getEndOffset();
                if (end >= editor.getSelectionStart() && start <= editor.getSelectionEnd()) continue;
                elsToIndent.add(bqChild);
            }
        }
        HTMLDocument doc = (HTMLDocument)editor.getDocument();
        this.adjustListElemsIndent(listElems, doc);
        this.blockquoteElements(new ArrayList(elsToIndent), doc);
        this.unblockquoteElements(new ArrayList(elsToOutdent), doc);
    }

    private void adjustListElemsIndent(List elems, HTMLDocument doc) {
        HashSet<Element> rootLists = new HashSet<Element>();
        HashSet<Element> liElems = new HashSet<Element>();
        for (int i = 0; i < elems.size(); ++i) {
            Element liEl = HTMLUtils.getParent((Element)elems.get(i), HTML.Tag.LI);
            if (liEl == null) continue;
            liElems.add(liEl);
            Element rootList = HTMLUtils.getListParent(liEl);
            if (rootList == null) continue;
            while (HTMLUtils.getListParent(rootList.getParentElement()) != null) {
                rootList = HTMLUtils.getListParent(rootList.getParentElement());
            }
            rootLists.add(rootList);
        }
        for (Element rl : rootLists) {
            String newHtml = this.buildListHTML(rl, new ArrayList(liElems));
            System.err.println(newHtml);
            try {
                doc.setInnerHTML(rl, newHtml);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private List getItems(Element list, List selLiElems, int level) {
        int c = list.getElementCount();
        ArrayList<ListItem> items = new ArrayList<ListItem>();
        for (int i = 0; i < c; ++i) {
            Element e = list.getElement(i);
            if (e.getName().equals("li")) {
                ListItem item = new ListItem();
                item.listTag = HTML.getTag(list.getName());
                item.level = level;
                if (selLiElems.contains(e)) {
                    if (this.direction == 0) {
                        ++item.level;
                    } else if (item.level > 0) {
                        --item.level;
                    }
                }
                item.html = HTMLUtils.getElementHTML(e, true);
                items.add(item);
                continue;
            }
            if (HTMLUtils.getListParent(e) != e) continue;
            items.addAll(this.getItems(e, selLiElems, level + 1));
        }
        return items;
    }

    private String buildListHTML(Element list, List liItems) {
        List items = this.getItems(list, liItems, 0);
        ListItem lastItem = null;
        StringBuffer html = new StringBuffer();
        for (int i = 0; i < items.size(); ++i) {
            ListItem item = (ListItem)items.get(i);
            if (!(lastItem == null || lastItem.level == item.level && lastItem.listTag.equals(item.listTag))) {
                if (lastItem.level > item.level) {
                    html.append(this.openOrCloseList(lastItem.listTag, -1 * (lastItem.level - item.level)));
                    html.append(item.html);
                } else if (item.level > lastItem.level) {
                    html.append(this.openOrCloseList(item.listTag, item.level - lastItem.level));
                    html.append(item.html);
                } else {
                    html.append(item.html);
                }
            } else {
                if (lastItem == null) {
                    html.append(this.openOrCloseList(item.listTag, item.level));
                }
                html.append(item.html);
            }
            lastItem = item;
        }
        if (lastItem != null) {
            html.append(this.openOrCloseList(lastItem.listTag, -1 * lastItem.level));
        }
        return html.toString();
    }

    private String openOrCloseList(HTML.Tag ltag, int level) {
        String tag = level < 0 ? "</" + ltag + ">\n" : "<" + ltag + ">\n";
        int c = Math.abs(level);
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < c; ++i) {
            sb.append(tag);
        }
        return sb.toString();
    }

    private List getLeadingTralingListElems(List elems) {
        Element el;
        int i;
        HashSet<Element> listElems = new HashSet<Element>();
        for (i = 0; i < elems.size() && HTMLUtils.getListParent(el = (Element)elems.get(i)) != null; ++i) {
            listElems.add(el);
        }
        for (i = elems.size() - 1; i >= 0 && HTMLUtils.getListParent(el = (Element)elems.get(i)) != null; --i) {
            listElems.add(el);
        }
        return new ArrayList(listElems);
    }

    private void indent1(ActionEvent e, JEditorPane editor) {
        List elems = this.getParagraphElements(editor);
        if (elems.size() == 0) {
            return;
        }
        List listElems = this.getLeadingTralingListElems(elems);
        elems.removeAll(listElems);
        HTMLDocument doc = (HTMLDocument)editor.getDocument();
        this.blockquoteElements(elems, doc);
        this.adjustListElemsIndent(listElems, doc);
    }

    private void indent(ActionEvent e, JEditorPane editor) {
        List elems = this.getParagraphElements(editor);
        if (elems.size() == 0) {
            return;
        }
        HTMLDocument doc = (HTMLDocument)editor.getDocument();
        LinkedList<Element> nonListElems = new LinkedList<Element>();
        Iterator it = elems.iterator();
        while (it.hasNext()) {
            Element el = (Element)it.next();
            if (HTMLUtils.getListParent(el) != null) continue;
            nonListElems.add(el);
            it.remove();
        }
        this.blockquoteElements(nonListElems, doc);
        Map listEls = this.getListElems(elems);
        for (Element listParent : listEls.keySet()) {
            Element liElem;
            int i;
            List liElems = (List)listEls.get(listParent);
            StringBuffer sb = new StringBuffer();
            sb.append("<" + listParent.getName() + ">\n");
            for (i = 0; i < liElems.size(); ++i) {
                liElem = (Element)liElems.get(i);
                sb.append(HTMLUtils.getElementHTML(liElem, true));
            }
            sb.append("</" + listParent.getName() + ">\n");
            System.err.println(sb);
            for (i = liElems.size() - 1; i >= 0; --i) {
                liElem = (Element)liElems.get(i);
                try {
                    if (i == 0) {
                        doc.setOuterHTML(liElem, sb.toString());
                        continue;
                    }
                    HTMLUtils.removeElement(liElem);
                    continue;
                }
                catch (Exception ble) {
                    ble.printStackTrace();
                }
            }
        }
    }

    private void unblockquoteElements(List elems, HTMLDocument doc) {
        for (Element curE : elems) {
            if (!curE.getName().equals("blockquote")) continue;
            String eleHtml = HTMLUtils.getElementHTML(curE, false);
            HTML.Tag t = HTMLUtils.getStartTag(eleHtml);
            if (t == null || !t.breaksFlow()) {
                eleHtml = "<p>\n" + eleHtml + "</p>\n";
            }
            try {
                doc.setOuterHTML(curE, eleHtml);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private void blockquoteElements(List elems, HTMLDocument doc) {
        for (Element curE : elems) {
            String eleHtml = HTMLUtils.getElementHTML(curE, true);
            StringBuffer sb = new StringBuffer();
            sb.append("<blockquote>\n");
            sb.append(eleHtml);
            sb.append("</blockquote>\n");
            try {
                doc.setOuterHTML(curE, sb.toString());
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public List getParagraphElements(JEditorPane editor) {
        ArrayList<Element> elems = new ArrayList<Element>();
        try {
            HTMLDocument doc = (HTMLDocument)editor.getDocument();
            Element curE = this.getParaElement(doc, editor.getSelectionStart());
            Element endE = this.getParaElement(doc, editor.getSelectionEnd());
            while (curE.getEndOffset() <= endE.getEndOffset()) {
                elems.add(curE);
                if ((curE = this.getParaElement(doc, curE.getEndOffset() + 1)).getEndOffset() < doc.getLength()) continue;
                break;
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return elems;
    }

    private Element getParaElement(HTMLDocument doc, int pos) {
        Element curE = doc.getParagraphElement(pos);
        return curE;
    }

    protected void wysiwygEditPerformed(ActionEvent e, JEditorPane editor) {
        int cp = editor.getCaretPosition();
        CompoundUndoManager.beginCompoundEdit(editor.getDocument());
        if (this.direction == 0) {
            this.indent1(e, editor);
        } else {
            this.unindent(e, editor);
        }
        CompoundUndoManager.endCompoundEdit(editor.getDocument());
        editor.setCaretPosition(cp);
    }

    private class ListItem {
        String html;
        int level;
        HTML.Tag listTag;

        private ListItem() {
        }
    }
}

