/*
 * Decompiled with CFR 0.152.
 */
package net.atlanticbb.tantlinger.ui.text.actions;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Action;
import javax.swing.JEditorPane;
import javax.swing.KeyStroke;
import net.atlanticbb.tantlinger.ui.UIUtils;
import net.atlanticbb.tantlinger.ui.text.CompoundUndoManager;
import net.atlanticbb.tantlinger.ui.text.HTMLUtils;
import net.atlanticbb.tantlinger.ui.text.actions.HTMLTextEditAction;
import org.bushe.swing.action.ShouldBeEnabledDelegate;

public class PasteFormattedAction
extends HTMLTextEditAction {
    private static final long serialVersionUID = 1L;

    public PasteFormattedAction() {
        super(i18n.str("paste_formatted"));
        this.putValue("MnemonicKey", new Integer(i18n.mnem("paste_formatted")));
        this.putValue("SmallIcon", UIUtils.getIcon("resources/images/x16/", "paste.png"));
        this.putValue("LARGE_ICON", UIUtils.getIcon("resources/images/x24/", "paste.png"));
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("shift ctrl V"));
        this.addShouldBeEnabledDelegate(new ShouldBeEnabledDelegate(){

            public boolean shouldBeEnabled(Action a) {
                if (PasteFormattedAction.this.getCurrentEditor() == null) {
                    return false;
                }
                Transferable content = Toolkit.getDefaultToolkit().getSystemClipboard().getContents((Object)PasteFormattedAction.this);
                if (content == null) {
                    return false;
                }
                DataFlavor flv = DataFlavor.selectBestTextFlavor(content.getTransferDataFlavors());
                return flv != null && flv.getMimeType().startsWith("text/html");
            }
        });
        this.putValue("ShortDescription", this.getValue("Name"));
    }

    protected void updateWysiwygContextState(JEditorPane wysEditor) {
        this.updateEnabledState();
    }

    protected void updateSourceContextState(JEditorPane srcEditor) {
        this.updateEnabledState();
    }

    protected void sourceEditPerformed(ActionEvent e, JEditorPane editor) {
        String htmlFragment = null;
        try {
            htmlFragment = this.getHTMLFragment();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (htmlFragment != null) {
            CompoundUndoManager.beginCompoundEdit(editor.getDocument());
            editor.replaceSelection(htmlFragment);
            CompoundUndoManager.endCompoundEdit(editor.getDocument());
        }
    }

    protected void wysiwygEditPerformed(ActionEvent e, JEditorPane editor) {
        String htmlFragment = null;
        try {
            htmlFragment = this.getHTMLFragment();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (htmlFragment != null) {
            CompoundUndoManager.beginCompoundEdit(editor.getDocument());
            HTMLUtils.insertArbitraryHTML(htmlFragment, editor);
            CompoundUndoManager.endCompoundEdit(editor.getDocument());
        }
    }

    private String getHTMLFragment() throws IOException, UnsupportedFlavorException {
        Clipboard clip = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable c = clip.getContents((Object)this);
        if (c == null) {
            return null;
        }
        DataFlavor flv = DataFlavor.selectBestTextFlavor(c.getTransferDataFlavors());
        if (!flv.getMimeType().startsWith("text/html")) {
            return null;
        }
        String text = this.read(flv.getReaderForText(c));
        int flags = 66;
        Pattern p = Pattern.compile("<\\s*body\\b([^<>]*)>", flags);
        Matcher m = p.matcher(text);
        if (m.find()) {
            text = text.substring(m.end(), text.length());
        }
        if ((m = (p = Pattern.compile("<\\s*/\\s*body\\s*>", flags)).matcher(text)).find()) {
            text = text.substring(0, m.start());
        }
        text = text.replaceAll("<\\!\\-\\-StartFragment\\-\\->", "");
        text = text.replaceAll("<\\!\\-\\-EndFragment\\-\\->", "");
        String r = "<([^>]*)(?:class|id)\\s*=\\s*(?:'[^']*'|\"\"[^\"\"]*\"\"|[^\\s>]+)([^>]*)>";
        p = Pattern.compile(r, flags);
        m = p.matcher(text);
        text = m.replaceAll("<$1$2>");
        m = p.matcher(text);
        text = m.replaceAll("<$1$2>");
        return text;
    }

    public String read(Reader input) throws IOException {
        BufferedReader reader = new BufferedReader(input);
        StringBuffer sb = new StringBuffer();
        try {
            int ch;
            while ((ch = reader.read()) != -1) {
                sb.append((char)ch);
            }
        }
        catch (IOException ex) {
            throw ex;
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException ioe) {}
        }
        return sb.toString();
    }
}

