/*
 * Decompiled with CFR 0.152.
 */
package net.atlanticbb.tantlinger.ui.text.dialogs;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import net.atlanticbb.tantlinger.ui.text.dialogs.HTMLAttributeEditorPanel;

public class AlignmentAttributesPanel
extends HTMLAttributeEditorPanel {
    private static final long serialVersionUID = 1L;
    private static final String[] VERT_ALIGNMENTS = new String[]{"top", "middle", "bottom"};
    private static final String[] HORIZ_ALIGNMENTS = new String[]{"left", "center", "right", "justify"};
    private JCheckBox vAlignCB = null;
    private JCheckBox hAlignCB = null;
    private JComboBox vLocCombo = null;
    private JComboBox hLocCombo = null;

    public AlignmentAttributesPanel() {
        this(new Hashtable());
    }

    public AlignmentAttributesPanel(Hashtable attr) {
        super(attr);
        this.initialize();
        this.updateComponentsFromAttribs();
    }

    public void updateComponentsFromAttribs() {
        if (this.attribs.containsKey("align")) {
            this.hAlignCB.setSelected(true);
            this.hLocCombo.setEnabled(true);
            this.hLocCombo.setSelectedItem(this.attribs.get("align"));
        } else {
            this.hAlignCB.setSelected(false);
            this.hLocCombo.setEnabled(false);
        }
        if (this.attribs.containsKey("valign")) {
            this.vAlignCB.setSelected(true);
            this.vLocCombo.setEnabled(true);
            this.vLocCombo.setSelectedItem(this.attribs.get("valign"));
        } else {
            this.vAlignCB.setSelected(false);
            this.vLocCombo.setEnabled(false);
        }
    }

    public void updateAttribsFromComponents() {
        if (this.vAlignCB.isSelected()) {
            this.attribs.put("valign", this.vLocCombo.getSelectedItem().toString());
        } else {
            this.attribs.remove("valign");
        }
        if (this.hAlignCB.isSelected()) {
            this.attribs.put("align", this.hLocCombo.getSelectedItem().toString());
        } else {
            this.attribs.remove("align");
        }
    }

    public void setComponentStates(Hashtable attribs) {
        if (attribs.containsKey("align")) {
            this.hAlignCB.setSelected(true);
            this.hLocCombo.setEnabled(true);
            this.hLocCombo.setSelectedItem(attribs.get("align"));
        } else {
            this.hAlignCB.setSelected(false);
            this.hLocCombo.setEnabled(false);
        }
        if (attribs.containsKey("valign")) {
            this.vAlignCB.setSelected(true);
            this.vLocCombo.setEnabled(true);
            this.vLocCombo.setSelectedItem(attribs.get("valign"));
        } else {
            this.vAlignCB.setSelected(false);
            this.vLocCombo.setEnabled(false);
        }
    }

    private void initialize() {
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.fill = 0;
        gridBagConstraints3.gridy = 1;
        gridBagConstraints3.weightx = 1.0;
        gridBagConstraints3.anchor = 17;
        gridBagConstraints3.gridx = 1;
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.fill = 0;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.anchor = 17;
        gridBagConstraints2.insets = new Insets(0, 0, 5, 0);
        gridBagConstraints2.gridx = 1;
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.anchor = 17;
        gridBagConstraints1.insets = new Insets(0, 0, 0, 5);
        gridBagConstraints1.gridy = 1;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints.gridy = 0;
        this.setLayout(new GridBagLayout());
        this.setSize(185, 95);
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(i18n.str("content_alignment")), BorderFactory.createEmptyBorder(2, 5, 2, 5)));
        this.setPreferredSize(new Dimension(185, 95));
        this.setMaximumSize(this.getPreferredSize());
        this.setMinimumSize(this.getPreferredSize());
        this.add((Component)this.getVAlignCB(), gridBagConstraints);
        this.add((Component)this.getHAlignCB(), gridBagConstraints1);
        this.add((Component)this.getVLocCombo(), gridBagConstraints2);
        this.add((Component)this.getHLocCombo(), gridBagConstraints3);
    }

    private JCheckBox getVAlignCB() {
        if (this.vAlignCB == null) {
            this.vAlignCB = new JCheckBox();
            this.vAlignCB.setText(i18n.str("vertical"));
            this.vAlignCB.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    AlignmentAttributesPanel.this.vLocCombo.setEnabled(AlignmentAttributesPanel.this.vAlignCB.isSelected());
                }
            });
        }
        return this.vAlignCB;
    }

    private JCheckBox getHAlignCB() {
        if (this.hAlignCB == null) {
            this.hAlignCB = new JCheckBox();
            this.hAlignCB.setText(i18n.str("horizontal"));
            this.hAlignCB.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    AlignmentAttributesPanel.this.hLocCombo.setEnabled(AlignmentAttributesPanel.this.hAlignCB.isSelected());
                }
            });
        }
        return this.hAlignCB;
    }

    private JComboBox getVLocCombo() {
        if (this.vLocCombo == null) {
            this.vLocCombo = new JComboBox<String>(VERT_ALIGNMENTS);
        }
        return this.vLocCombo;
    }

    private JComboBox getHLocCombo() {
        if (this.hLocCombo == null) {
            this.hLocCombo = new JComboBox<String>(HORIZ_ALIGNMENTS);
        }
        return this.hLocCombo;
    }
}

