/*
 * Decompiled with CFR 0.152.
 */
package net.atlanticbb.tantlinger.ui.text.dialogs;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import net.atlanticbb.tantlinger.ui.text.TextEditPopupManager;
import net.atlanticbb.tantlinger.ui.text.dialogs.HTMLAttributeEditorPanel;

public class ImageAttributesPanel
extends HTMLAttributeEditorPanel {
    private static final long serialVersionUID = 1L;
    private static final String[] ALIGNMENTS = new String[]{"top", "middle", "bottom", "left", "right"};
    private JLabel imgUrlLabel = null;
    private JCheckBox altTextCB = null;
    private JCheckBox widthCB = null;
    private JCheckBox heightCB = null;
    private JCheckBox borderCB = null;
    private JSpinner widthField = null;
    private JSpinner heightField = null;
    private JSpinner borderField = null;
    private JCheckBox vSpaceCB = null;
    private JCheckBox hSpaceCB = null;
    private JCheckBox alignCB = null;
    private JSpinner vSpaceField = null;
    private JSpinner hSpaceField = null;
    private JComboBox alignCombo = null;
    private JTextField imgUrlField = null;
    private JTextField altTextField = null;
    private JPanel attribPanel = null;
    private JPanel spacerPanel = null;

    public ImageAttributesPanel() {
        this.initialize();
        this.updateComponentsFromAttribs();
    }

    public void updateComponentsFromAttribs() {
        if (this.attribs.containsKey("src")) {
            this.imgUrlField.setText(this.attribs.get("src").toString());
        }
        if (this.attribs.containsKey("alt")) {
            this.altTextCB.setSelected(true);
            this.altTextField.setEditable(true);
            this.altTextField.setText(this.attribs.get("alt").toString());
        } else {
            this.altTextCB.setSelected(false);
            this.altTextField.setEditable(false);
        }
        if (this.attribs.containsKey("width")) {
            this.widthCB.setSelected(true);
            this.widthField.setEnabled(true);
            try {
                this.widthField.getModel().setValue(new Integer(this.attribs.get("width").toString()));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        } else {
            this.widthCB.setSelected(false);
            this.widthField.setEnabled(false);
        }
        if (this.attribs.containsKey("height")) {
            this.heightCB.setSelected(true);
            this.heightField.setEnabled(true);
            try {
                this.heightField.getModel().setValue(new Integer(this.attribs.get("height").toString()));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        } else {
            this.heightCB.setSelected(false);
            this.heightField.setEnabled(false);
        }
        if (this.attribs.containsKey("hspace")) {
            this.hSpaceCB.setSelected(true);
            this.hSpaceField.setEnabled(true);
            try {
                this.hSpaceField.getModel().setValue(new Integer(this.attribs.get("hspace").toString()));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        } else {
            this.hSpaceCB.setSelected(false);
            this.hSpaceField.setEnabled(false);
        }
        if (this.attribs.containsKey("vspace")) {
            this.vSpaceCB.setSelected(true);
            this.vSpaceField.setEnabled(true);
            try {
                this.vSpaceField.getModel().setValue(new Integer(this.attribs.get("vspace").toString()));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        } else {
            this.vSpaceCB.setSelected(false);
            this.vSpaceField.setEnabled(false);
        }
        if (this.attribs.containsKey("border")) {
            this.borderCB.setSelected(true);
            this.borderField.setEnabled(true);
            try {
                this.borderField.getModel().setValue(new Integer(this.attribs.get("border").toString()));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        } else {
            this.borderCB.setSelected(false);
            this.borderField.setEnabled(false);
        }
        if (this.attribs.containsKey("align")) {
            this.alignCB.setSelected(true);
            this.alignCombo.setEnabled(true);
            this.alignCombo.setSelectedItem(this.attribs.get("align"));
        } else {
            this.alignCB.setSelected(false);
            this.alignCombo.setEnabled(false);
        }
    }

    public void updateAttribsFromComponents() {
        this.attribs.put("src", this.imgUrlField.getText());
        if (this.altTextCB.isSelected()) {
            this.attribs.put("alt", this.altTextField.getText());
        } else {
            this.attribs.remove("alt");
        }
        if (this.widthCB.isSelected()) {
            this.attribs.put("width", this.widthField.getModel().getValue().toString());
        } else {
            this.attribs.remove("width");
        }
        if (this.heightCB.isSelected()) {
            this.attribs.put("height", this.heightField.getModel().getValue().toString());
        } else {
            this.attribs.remove("height");
        }
        if (this.vSpaceCB.isSelected()) {
            this.attribs.put("vspace", this.vSpaceField.getModel().getValue().toString());
        } else {
            this.attribs.remove("vspace");
        }
        if (this.hSpaceCB.isSelected()) {
            this.attribs.put("hspace", this.hSpaceField.getModel().getValue().toString());
        } else {
            this.attribs.remove("hspace");
        }
        if (this.borderCB.isSelected()) {
            this.attribs.put("border", this.borderField.getModel().getValue().toString());
        } else {
            this.attribs.remove("border");
        }
        if (this.alignCB.isSelected()) {
            this.attribs.put("align", this.alignCombo.getSelectedItem().toString());
        } else {
            this.attribs.remove("align");
        }
    }

    private void initialize() {
        GridBagConstraints gridBagConstraints21 = new GridBagConstraints();
        gridBagConstraints21.gridx = 0;
        gridBagConstraints21.gridwidth = 2;
        gridBagConstraints21.anchor = 17;
        gridBagConstraints21.fill = 2;
        gridBagConstraints21.weighty = 1.0;
        gridBagConstraints21.gridy = 3;
        GridBagConstraints gridBagConstraints16 = new GridBagConstraints();
        gridBagConstraints16.gridx = 0;
        gridBagConstraints16.gridwidth = 2;
        gridBagConstraints16.anchor = 17;
        gridBagConstraints16.gridy = 2;
        GridBagConstraints gridBagConstraints15 = new GridBagConstraints();
        gridBagConstraints15.fill = 2;
        gridBagConstraints15.gridy = 1;
        gridBagConstraints15.weightx = 1.0;
        gridBagConstraints15.insets = new Insets(0, 0, 10, 0);
        gridBagConstraints15.gridwidth = 1;
        gridBagConstraints15.anchor = 17;
        gridBagConstraints15.gridx = 1;
        GridBagConstraints gridBagConstraints14 = new GridBagConstraints();
        gridBagConstraints14.fill = 2;
        gridBagConstraints14.gridy = 0;
        gridBagConstraints14.weightx = 1.0;
        gridBagConstraints14.insets = new Insets(0, 0, 5, 0);
        gridBagConstraints14.gridwidth = 1;
        gridBagConstraints14.anchor = 17;
        gridBagConstraints14.gridx = 1;
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.anchor = 17;
        gridBagConstraints1.insets = new Insets(0, 0, 10, 5);
        gridBagConstraints1.gridy = 1;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints.gridy = 0;
        this.imgUrlLabel = new JLabel();
        this.imgUrlLabel.setText(i18n.str("image_url"));
        this.setLayout(new GridBagLayout());
        this.setSize(365, 188);
        this.add((Component)this.imgUrlLabel, gridBagConstraints);
        this.add((Component)this.getAltTextCB(), gridBagConstraints1);
        this.add((Component)this.getImgUrlField(), gridBagConstraints14);
        this.add((Component)this.getAltTextField(), gridBagConstraints15);
        this.add((Component)this.getAttribPanel(), gridBagConstraints16);
        this.add((Component)this.getSpacerPanel(), gridBagConstraints21);
        TextEditPopupManager popupMan = TextEditPopupManager.getInstance();
        popupMan.registerJTextComponent(this.imgUrlField);
        popupMan.registerJTextComponent(this.altTextField);
    }

    private JCheckBox getAltTextCB() {
        if (this.altTextCB == null) {
            this.altTextCB = new JCheckBox();
            this.altTextCB.setText(i18n.str("alt_text"));
            this.altTextCB.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    ImageAttributesPanel.this.altTextField.setEditable(ImageAttributesPanel.this.altTextCB.isSelected());
                }
            });
        }
        return this.altTextCB;
    }

    private JCheckBox getWidthCB() {
        if (this.widthCB == null) {
            this.widthCB = new JCheckBox();
            this.widthCB.setText(i18n.str("width"));
            this.widthCB.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    ImageAttributesPanel.this.widthField.setEnabled(ImageAttributesPanel.this.widthCB.isSelected());
                }
            });
        }
        return this.widthCB;
    }

    private JCheckBox getHeightCB() {
        if (this.heightCB == null) {
            this.heightCB = new JCheckBox();
            this.heightCB.setText(i18n.str("height"));
            this.heightCB.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    ImageAttributesPanel.this.heightField.setEnabled(ImageAttributesPanel.this.heightCB.isSelected());
                }
            });
        }
        return this.heightCB;
    }

    private JCheckBox getBorderCB() {
        if (this.borderCB == null) {
            this.borderCB = new JCheckBox();
            this.borderCB.setText(i18n.str("border"));
            this.borderCB.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    ImageAttributesPanel.this.borderField.setEnabled(ImageAttributesPanel.this.borderCB.isSelected());
                }
            });
        }
        return this.borderCB;
    }

    private JSpinner getWidthField() {
        if (this.widthField == null) {
            this.widthField = new JSpinner(new SpinnerNumberModel(1, 1, 999, 1));
        }
        return this.widthField;
    }

    private JSpinner getHeightField() {
        if (this.heightField == null) {
            this.heightField = new JSpinner(new SpinnerNumberModel(1, 1, 999, 1));
        }
        return this.heightField;
    }

    private JSpinner getBorderField() {
        if (this.borderField == null) {
            this.borderField = new JSpinner(new SpinnerNumberModel(1, 0, 999, 1));
        }
        return this.borderField;
    }

    private JCheckBox getVSpaceCB() {
        if (this.vSpaceCB == null) {
            this.vSpaceCB = new JCheckBox();
            this.vSpaceCB.setText(i18n.str("vspace"));
            this.vSpaceCB.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    ImageAttributesPanel.this.vSpaceField.setEnabled(ImageAttributesPanel.this.vSpaceCB.isSelected());
                }
            });
        }
        return this.vSpaceCB;
    }

    private JCheckBox getHSpaceCB() {
        if (this.hSpaceCB == null) {
            this.hSpaceCB = new JCheckBox();
            this.hSpaceCB.setText(i18n.str("hspace"));
            this.hSpaceCB.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    ImageAttributesPanel.this.hSpaceField.setEnabled(ImageAttributesPanel.this.hSpaceCB.isSelected());
                }
            });
        }
        return this.hSpaceCB;
    }

    private JCheckBox getAlignCB() {
        if (this.alignCB == null) {
            this.alignCB = new JCheckBox();
            this.alignCB.setText(i18n.str("align"));
            this.alignCB.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    ImageAttributesPanel.this.alignCombo.setEnabled(ImageAttributesPanel.this.alignCB.isSelected());
                }
            });
        }
        return this.alignCB;
    }

    private JSpinner getVSpaceField() {
        if (this.vSpaceField == null) {
            this.vSpaceField = new JSpinner(new SpinnerNumberModel(1, 1, 999, 1));
        }
        return this.vSpaceField;
    }

    private JSpinner getHSpaceField() {
        if (this.hSpaceField == null) {
            this.hSpaceField = new JSpinner(new SpinnerNumberModel(1, 1, 999, 1));
        }
        return this.hSpaceField;
    }

    private JComboBox getAlignCombo() {
        if (this.alignCombo == null) {
            this.alignCombo = new JComboBox<String>(ALIGNMENTS);
        }
        return this.alignCombo;
    }

    private JTextField getImgUrlField() {
        if (this.imgUrlField == null) {
            this.imgUrlField = new JTextField();
        }
        return this.imgUrlField;
    }

    private JTextField getAltTextField() {
        if (this.altTextField == null) {
            this.altTextField = new JTextField();
        }
        return this.altTextField;
    }

    private JPanel getAttribPanel() {
        if (this.attribPanel == null) {
            GridBagConstraints gridBagConstraints13 = new GridBagConstraints();
            gridBagConstraints13.anchor = 17;
            gridBagConstraints13.insets = new Insets(0, 0, 10, 0);
            gridBagConstraints13.gridx = 3;
            gridBagConstraints13.gridy = 2;
            gridBagConstraints13.weightx = 1.0;
            gridBagConstraints13.fill = 0;
            GridBagConstraints gridBagConstraints12 = new GridBagConstraints();
            gridBagConstraints12.anchor = 17;
            gridBagConstraints12.insets = new Insets(0, 0, 10, 0);
            gridBagConstraints12.gridx = 3;
            gridBagConstraints12.gridy = 1;
            gridBagConstraints12.weightx = 0.0;
            gridBagConstraints12.fill = 0;
            GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
            gridBagConstraints11.anchor = 17;
            gridBagConstraints11.insets = new Insets(0, 0, 5, 0);
            gridBagConstraints11.gridx = 3;
            gridBagConstraints11.gridy = 0;
            gridBagConstraints11.weightx = 0.0;
            gridBagConstraints11.fill = 0;
            GridBagConstraints gridBagConstraints10 = new GridBagConstraints();
            gridBagConstraints10.anchor = 17;
            gridBagConstraints10.gridx = 2;
            gridBagConstraints10.gridy = 2;
            gridBagConstraints10.insets = new Insets(0, 0, 10, 5);
            GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
            gridBagConstraints9.anchor = 17;
            gridBagConstraints9.gridx = 2;
            gridBagConstraints9.gridy = 1;
            gridBagConstraints9.insets = new Insets(0, 0, 10, 5);
            GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
            gridBagConstraints8.anchor = 17;
            gridBagConstraints8.gridx = 2;
            gridBagConstraints8.gridy = 0;
            gridBagConstraints8.insets = new Insets(0, 0, 5, 5);
            GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
            gridBagConstraints7.anchor = 17;
            gridBagConstraints7.insets = new Insets(0, 0, 10, 10);
            gridBagConstraints7.gridx = 1;
            gridBagConstraints7.gridy = 2;
            gridBagConstraints7.weightx = 0.0;
            gridBagConstraints7.fill = 0;
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            gridBagConstraints6.anchor = 17;
            gridBagConstraints6.insets = new Insets(0, 0, 10, 10);
            gridBagConstraints6.gridx = 1;
            gridBagConstraints6.gridy = 1;
            gridBagConstraints6.weightx = 0.0;
            gridBagConstraints6.fill = 0;
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.anchor = 17;
            gridBagConstraints5.insets = new Insets(0, 0, 5, 10);
            gridBagConstraints5.gridx = 1;
            gridBagConstraints5.gridy = 0;
            gridBagConstraints5.weightx = 0.0;
            gridBagConstraints5.fill = 0;
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.anchor = 17;
            gridBagConstraints4.gridx = 0;
            gridBagConstraints4.gridy = 2;
            gridBagConstraints4.insets = new Insets(0, 0, 10, 5);
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.anchor = 17;
            gridBagConstraints3.gridx = 0;
            gridBagConstraints3.gridy = 1;
            gridBagConstraints3.insets = new Insets(0, 0, 10, 5);
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.anchor = 17;
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.gridy = 0;
            gridBagConstraints2.insets = new Insets(0, 0, 5, 5);
            this.attribPanel = new JPanel();
            this.attribPanel.setLayout(new GridBagLayout());
            this.attribPanel.add((Component)this.getWidthCB(), gridBagConstraints2);
            this.attribPanel.add((Component)this.getHeightCB(), gridBagConstraints3);
            this.attribPanel.add((Component)this.getBorderCB(), gridBagConstraints4);
            this.attribPanel.add((Component)this.getWidthField(), gridBagConstraints5);
            this.attribPanel.add((Component)this.getHeightField(), gridBagConstraints6);
            this.attribPanel.add((Component)this.getBorderField(), gridBagConstraints7);
            this.attribPanel.add((Component)this.getVSpaceCB(), gridBagConstraints8);
            this.attribPanel.add((Component)this.getHSpaceCB(), gridBagConstraints9);
            this.attribPanel.add((Component)this.getAlignCB(), gridBagConstraints10);
            this.attribPanel.add((Component)this.getVSpaceField(), gridBagConstraints11);
            this.attribPanel.add((Component)this.getHSpaceField(), gridBagConstraints12);
            this.attribPanel.add((Component)this.getAlignCombo(), gridBagConstraints13);
        }
        return this.attribPanel;
    }

    private JPanel getSpacerPanel() {
        if (this.spacerPanel == null) {
            this.spacerPanel = new JPanel();
        }
        return this.spacerPanel;
    }
}

