/*
 * Decompiled with CFR 0.152.
 */
package net.atlanticbb.tantlinger.ui.text.dialogs;

import java.awt.Dialog;
import java.awt.Frame;
import java.util.Map;
import javax.swing.Icon;
import net.atlanticbb.tantlinger.i18n.I18n;
import net.atlanticbb.tantlinger.ui.UIUtils;
import net.atlanticbb.tantlinger.ui.text.dialogs.HTMLOptionDialog;
import net.atlanticbb.tantlinger.ui.text.dialogs.ImagePanel;

public class ImageDialog
extends HTMLOptionDialog {
    private static final long serialVersionUID = 1L;
    private static final I18n i18n = I18n.getInstance("net.atlanticbb.tantlinger.ui.text.dialogs");
    private static Icon icon = UIUtils.getIcon("resources/images/x32/", "image.png");
    private static String title = i18n.str("image");
    private static String desc = i18n.str("image_desc");
    private ImagePanel imagePanel;

    public ImageDialog(Frame parent) {
        super(parent, title, desc, icon);
        this.init();
    }

    public ImageDialog(Dialog parent) {
        super(parent, title, desc, icon);
        this.init();
    }

    private void init() {
        this.imagePanel = new ImagePanel();
        this.setContentPane(this.imagePanel);
        this.setSize(300, 345);
        this.setResizable(false);
    }

    public void setImageAttributes(Map attr) {
        this.imagePanel.setAttributes(attr);
    }

    public Map getImageAttributes() {
        return this.imagePanel.getAttributes();
    }

    private String createImgAttributes(Map ht) {
        String html = "";
        for (Object k : ht.keySet()) {
            if (k.toString().equals("a") || k.toString().equals("name")) continue;
            html = html + " " + k + "=" + "\"" + ht.get(k) + "\"";
        }
        return html;
    }

    public String getHTML() {
        Map imgAttr = this.imagePanel.getAttributes();
        boolean hasLink = imgAttr.containsKey("a");
        String html = "";
        if (hasLink) {
            html = "<a " + imgAttr.get("a") + ">";
        }
        html = html + "<img" + this.createImgAttributes(imgAttr) + ">";
        if (hasLink) {
            html = html + "</a>";
        }
        return html;
    }
}

