/*
 * Decompiled with CFR 0.152.
 */
package net.atlanticbb.tantlinger.ui.text.dialogs;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.atlanticbb.tantlinger.ui.text.TextEditPopupManager;
import net.atlanticbb.tantlinger.ui.text.dialogs.HTMLAttributeEditorPanel;

public class LinkAttributesPanel
extends HTMLAttributeEditorPanel {
    private static final long serialVersionUID = 1L;
    private static final String NEW_WIN = "New Window";
    private static final String SAME_WIN = "Same Window";
    private static final String SAME_FRAME = "Same Frame";
    private static final String[] TARGET_LABELS = new String[]{"New Window", "Same Window", "Same Frame"};
    private static final String[] TARGETS = new String[]{"_blank", "_top", "_self"};
    private JCheckBox nameCB = null;
    private JCheckBox titleCB = null;
    private JCheckBox openInCB = null;
    private JTextField nameField = null;
    private JTextField titleField = null;
    private JComboBox openInCombo = null;
    private JPanel spacerPanel = null;

    public LinkAttributesPanel() {
        this.initialize();
        this.updateComponentsFromAttribs();
    }

    public void setEnabled(boolean b) {
        super.setEnabled(b);
        this.nameCB.setEnabled(b);
        this.titleCB.setEnabled(b);
        this.openInCB.setEnabled(b);
        this.nameField.setEditable(this.nameCB.isSelected() && b);
        this.titleField.setEditable(this.titleCB.isSelected() && b);
        this.openInCombo.setEnabled(this.openInCB.isSelected() && b);
    }

    private void initialize() {
        GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
        gridBagConstraints6.gridx = 0;
        gridBagConstraints6.fill = 2;
        gridBagConstraints6.weighty = 1.0;
        gridBagConstraints6.weightx = 0.0;
        gridBagConstraints6.anchor = 18;
        gridBagConstraints6.gridwidth = 2;
        gridBagConstraints6.gridy = 3;
        GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
        gridBagConstraints5.fill = 0;
        gridBagConstraints5.gridy = 2;
        gridBagConstraints5.weightx = 1.0;
        gridBagConstraints5.insets = new Insets(0, 0, 5, 0);
        gridBagConstraints5.anchor = 17;
        gridBagConstraints5.gridx = 1;
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.fill = 2;
        gridBagConstraints4.gridy = 1;
        gridBagConstraints4.weightx = 1.0;
        gridBagConstraints4.insets = new Insets(0, 0, 5, 0);
        gridBagConstraints4.anchor = 17;
        gridBagConstraints4.gridx = 1;
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.fill = 2;
        gridBagConstraints3.gridy = 0;
        gridBagConstraints3.weightx = 1.0;
        gridBagConstraints3.insets = new Insets(0, 0, 5, 0);
        gridBagConstraints3.anchor = 17;
        gridBagConstraints3.gridx = 1;
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.anchor = 17;
        gridBagConstraints2.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints2.gridy = 2;
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.anchor = 17;
        gridBagConstraints1.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints1.gridy = 1;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints.gridy = 0;
        this.setLayout(new GridBagLayout());
        this.setSize(new Dimension(320, 118));
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(null, i18n.str("attributes"), 0, 0, null, null), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.add((Component)this.getNameCB(), gridBagConstraints);
        this.add((Component)this.getTitleCB(), gridBagConstraints1);
        this.add((Component)this.getOpenInCB(), gridBagConstraints2);
        this.add((Component)this.getNameField(), gridBagConstraints3);
        this.add((Component)this.getTitleField(), gridBagConstraints4);
        this.add((Component)this.getOpenInCombo(), gridBagConstraints5);
        this.add((Component)this.getSpacerPanel(), gridBagConstraints6);
        TextEditPopupManager.getInstance().registerJTextComponent(this.nameField);
        TextEditPopupManager.getInstance().registerJTextComponent(this.titleField);
    }

    public void updateComponentsFromAttribs() {
        if (this.attribs.containsKey("name")) {
            this.nameCB.setSelected(true);
            this.nameField.setEditable(true);
            this.nameField.setText(this.attribs.get("name").toString());
        } else {
            this.nameCB.setSelected(false);
            this.nameField.setEditable(false);
        }
        if (this.attribs.containsKey("title")) {
            this.titleCB.setSelected(true);
            this.titleField.setEditable(true);
            this.titleField.setText(this.attribs.get("title").toString());
        } else {
            this.titleCB.setSelected(false);
            this.titleField.setEditable(false);
        }
        if (this.attribs.containsKey("target")) {
            this.openInCB.setSelected(true);
            String val = this.attribs.get("target").toString();
            this.openInCombo.setEnabled(true);
            for (int i = 0; i < TARGETS.length; ++i) {
                if (!val.equals(TARGETS[i])) continue;
                this.openInCombo.setSelectedIndex(i);
                break;
            }
        } else {
            this.openInCB.setSelected(false);
            this.openInCombo.setEnabled(false);
        }
    }

    public void updateAttribsFromComponents() {
        if (this.openInCB.isSelected()) {
            this.attribs.put("target", TARGETS[this.openInCombo.getSelectedIndex()]);
        } else {
            this.attribs.remove("target");
        }
        if (this.titleCB.isSelected()) {
            this.attribs.put("title", this.titleField.getText());
        } else {
            this.attribs.remove("title");
        }
        if (this.nameCB.isSelected()) {
            this.attribs.put("name", this.nameField.getText());
        } else {
            this.attribs.remove("name");
        }
    }

    private JCheckBox getNameCB() {
        if (this.nameCB == null) {
            this.nameCB = new JCheckBox();
            this.nameCB.setText(i18n.str("name"));
            this.nameCB.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    LinkAttributesPanel.this.nameField.setEditable(LinkAttributesPanel.this.nameCB.isSelected());
                }
            });
        }
        return this.nameCB;
    }

    private JCheckBox getTitleCB() {
        if (this.titleCB == null) {
            this.titleCB = new JCheckBox();
            this.titleCB.setText(i18n.str("title"));
            this.titleCB.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    LinkAttributesPanel.this.titleField.setEditable(LinkAttributesPanel.this.titleCB.isSelected());
                }
            });
        }
        return this.titleCB;
    }

    private JCheckBox getOpenInCB() {
        if (this.openInCB == null) {
            this.openInCB = new JCheckBox();
            this.openInCB.setText(i18n.str("open_in"));
            this.openInCB.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    LinkAttributesPanel.this.openInCombo.setEnabled(LinkAttributesPanel.this.openInCB.isSelected());
                }
            });
        }
        return this.openInCB;
    }

    private JTextField getNameField() {
        if (this.nameField == null) {
            this.nameField = new JTextField();
        }
        return this.nameField;
    }

    private JTextField getTitleField() {
        if (this.titleField == null) {
            this.titleField = new JTextField();
        }
        return this.titleField;
    }

    private JComboBox getOpenInCombo() {
        if (this.openInCombo == null) {
            this.openInCombo = new JComboBox<String>(TARGET_LABELS);
        }
        return this.openInCombo;
    }

    private JPanel getSpacerPanel() {
        if (this.spacerPanel == null) {
            this.spacerPanel = new JPanel();
        }
        return this.spacerPanel;
    }
}

