/*
 * Decompiled with CFR 0.152.
 */
package net.atlanticbb.tantlinger.ui.text.dialogs;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import net.atlanticbb.tantlinger.ui.text.dialogs.HTMLAttributeEditorPanel;

public class SizeAttributesPanel
extends HTMLAttributeEditorPanel {
    private static final long serialVersionUID = 1L;
    private static final String[] MEASUREMENTS = new String[]{"percent", "pixels"};
    private JCheckBox widthCB = null;
    private JCheckBox heightCB = null;
    private JSpinner widthField = null;
    private JSpinner heightField = null;
    private JComboBox wMeasurementCombo = null;
    private JComboBox hMeasurementCombo = null;

    public SizeAttributesPanel() {
        this(new Hashtable());
    }

    public SizeAttributesPanel(Hashtable attr) {
        super(attr);
        this.initialize();
        this.updateComponentsFromAttribs();
    }

    public void updateComponentsFromAttribs() {
        if (this.attribs.containsKey("width")) {
            this.widthCB.setSelected(true);
            String w = this.attribs.get("width").toString();
            if (w.endsWith("%")) {
                w = w.substring(0, w.length() - 1);
            } else {
                this.wMeasurementCombo.setSelectedIndex(1);
            }
            try {
                this.widthField.getModel().setValue(new Integer(w));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            this.wMeasurementCombo.setEnabled(true);
            this.widthField.setEnabled(true);
        } else {
            this.widthCB.setSelected(false);
            this.widthField.setEnabled(false);
            this.wMeasurementCombo.setEnabled(false);
        }
        if (this.attribs.containsKey("height")) {
            this.heightCB.setSelected(true);
            String h = this.attribs.get("height").toString();
            if (h.endsWith("%")) {
                h = h.substring(0, h.length() - 1);
            } else {
                this.hMeasurementCombo.setSelectedIndex(1);
            }
            try {
                this.heightField.getModel().setValue(new Integer(h));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            this.hMeasurementCombo.setEnabled(true);
            this.heightField.setEnabled(true);
        } else {
            this.heightCB.setSelected(false);
            this.heightField.setEnabled(false);
            this.hMeasurementCombo.setEnabled(false);
        }
    }

    public void updateAttribsFromComponents() {
        if (this.widthCB.isSelected()) {
            String w = this.widthField.getModel().getValue().toString();
            if (this.wMeasurementCombo.getSelectedIndex() == 0) {
                w = w + "%";
            }
            this.attribs.put("width", w);
        } else {
            this.attribs.remove("width");
        }
        if (this.heightCB.isSelected()) {
            String h = this.heightField.getModel().getValue().toString();
            if (this.hMeasurementCombo.getSelectedIndex() == 0) {
                h = h + "%";
            }
            this.attribs.put("height", h);
        } else {
            this.attribs.remove("height");
        }
    }

    public void setComponentStates(Hashtable attribs) {
        if (attribs.containsKey("width")) {
            this.widthCB.setSelected(true);
            String w = attribs.get("width").toString();
            if (w.endsWith("%")) {
                w = w.substring(0, w.length() - 1);
            } else {
                this.wMeasurementCombo.setSelectedIndex(1);
            }
            try {
                this.widthField.getModel().setValue(new Integer(w));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            this.wMeasurementCombo.setEnabled(true);
            this.widthField.setEnabled(true);
        } else {
            this.widthCB.setSelected(false);
            this.widthField.setEnabled(false);
            this.wMeasurementCombo.setEnabled(false);
        }
        if (attribs.containsKey("height")) {
            this.heightCB.setSelected(true);
            String h = attribs.get("height").toString();
            if (h.endsWith("%")) {
                h = h.substring(0, h.length() - 1);
            } else {
                this.hMeasurementCombo.setSelectedIndex(1);
            }
            try {
                this.heightField.getModel().setValue(new Integer(h));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            this.hMeasurementCombo.setEnabled(true);
            this.heightField.setEnabled(true);
        } else {
            this.heightCB.setSelected(false);
            this.heightField.setEnabled(false);
            this.hMeasurementCombo.setEnabled(false);
        }
    }

    private void initialize() {
        GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
        gridBagConstraints5.fill = 0;
        gridBagConstraints5.gridy = 1;
        gridBagConstraints5.weightx = 0.0;
        gridBagConstraints5.anchor = 17;
        gridBagConstraints5.ipadx = 0;
        gridBagConstraints5.gridx = 2;
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.fill = 0;
        gridBagConstraints4.gridy = 0;
        gridBagConstraints4.weightx = 1.0;
        gridBagConstraints4.anchor = 17;
        gridBagConstraints4.insets = new Insets(0, 0, 5, 0);
        gridBagConstraints4.gridx = 2;
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.fill = 0;
        gridBagConstraints3.gridy = 1;
        gridBagConstraints3.weightx = 0.0;
        gridBagConstraints3.anchor = 17;
        gridBagConstraints3.insets = new Insets(0, 0, 0, 5);
        gridBagConstraints3.ipadx = 0;
        gridBagConstraints3.gridx = 1;
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.fill = 0;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.weightx = 0.0;
        gridBagConstraints2.anchor = 17;
        gridBagConstraints2.insets = new Insets(0, 0, 0, 5);
        gridBagConstraints2.ipadx = 0;
        gridBagConstraints2.gridx = 1;
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.anchor = 17;
        gridBagConstraints1.insets = new Insets(0, 0, 0, 5);
        gridBagConstraints1.gridy = 1;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints.gridy = 0;
        this.setLayout(new GridBagLayout());
        this.setSize(215, 95);
        this.setPreferredSize(new Dimension(215, 95));
        this.setMaximumSize(this.getPreferredSize());
        this.setMinimumSize(this.getPreferredSize());
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(null, i18n.str("size"), 0, 0, null, null), BorderFactory.createEmptyBorder(2, 5, 2, 5)));
        this.add((Component)this.getWidthCB(), gridBagConstraints);
        this.add((Component)this.getHeightCB(), gridBagConstraints1);
        this.add((Component)this.getWidthField(), gridBagConstraints2);
        this.add((Component)this.getHeightField(), gridBagConstraints3);
        this.add((Component)this.getWMeasurementCombo(), gridBagConstraints4);
        this.add((Component)this.getHMeasurementCombo(), gridBagConstraints5);
    }

    private JCheckBox getWidthCB() {
        if (this.widthCB == null) {
            this.widthCB = new JCheckBox();
            this.widthCB.setText(i18n.str("width"));
            this.widthCB.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    SizeAttributesPanel.this.widthField.setEnabled(SizeAttributesPanel.this.widthCB.isSelected());
                    SizeAttributesPanel.this.wMeasurementCombo.setEnabled(SizeAttributesPanel.this.widthCB.isSelected());
                }
            });
        }
        return this.widthCB;
    }

    private JCheckBox getHeightCB() {
        if (this.heightCB == null) {
            this.heightCB = new JCheckBox();
            this.heightCB.setText(i18n.str("height"));
            this.heightCB.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    SizeAttributesPanel.this.heightField.setEnabled(SizeAttributesPanel.this.heightCB.isSelected());
                    SizeAttributesPanel.this.hMeasurementCombo.setEnabled(SizeAttributesPanel.this.heightCB.isSelected());
                }
            });
        }
        return this.heightCB;
    }

    private JSpinner getWidthField() {
        if (this.widthField == null) {
            this.widthField = new JSpinner(new SpinnerNumberModel(1, 1, 999, 1));
        }
        return this.widthField;
    }

    private JSpinner getHeightField() {
        if (this.heightField == null) {
            this.heightField = new JSpinner(new SpinnerNumberModel(1, 1, 999, 1));
        }
        return this.heightField;
    }

    private JComboBox getWMeasurementCombo() {
        if (this.wMeasurementCombo == null) {
            this.wMeasurementCombo = new JComboBox<String>(MEASUREMENTS);
        }
        return this.wMeasurementCombo;
    }

    private JComboBox getHMeasurementCombo() {
        if (this.hMeasurementCombo == null) {
            this.hMeasurementCombo = new JComboBox<String>(MEASUREMENTS);
        }
        return this.hMeasurementCombo;
    }
}

