/*
 * Decompiled with CFR 0.152.
 */
package net.atlanticbb.tantlinger.ui.text.dialogs;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Hashtable;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import net.atlanticbb.tantlinger.ui.text.dialogs.BGColorPanel;
import net.atlanticbb.tantlinger.ui.text.dialogs.HTMLAttributeEditorPanel;

public class TableAttributesPanel
extends HTMLAttributeEditorPanel {
    private static final long serialVersionUID = 1L;
    private static final String[] ALIGNMENTS = new String[]{"left", "center", "right"};
    private static final String[] MEASUREMENTS = new String[]{"percent", "pixels"};
    private JCheckBox widthCB = null;
    private JSpinner widthField = null;
    private JComboBox widthCombo = null;
    private JCheckBox alignCB = null;
    private JCheckBox cellSpacingCB = null;
    private JSpinner cellSpacingField = null;
    private JCheckBox borderCB = null;
    private JSpinner borderField = null;
    private JCheckBox cellPaddingCB = null;
    private JSpinner cellPaddingField = null;
    private JComboBox alignCombo = null;
    private BGColorPanel bgPanel = null;
    private JPanel expansionPanel = null;

    public TableAttributesPanel() {
        this(new Hashtable());
    }

    public TableAttributesPanel(Hashtable attribs) {
        super(attribs);
        this.initialize();
        this.updateComponentsFromAttribs();
    }

    public void updateComponentsFromAttribs() {
        if (this.attribs.containsKey("width")) {
            this.widthCB.setSelected(true);
            String w = this.attribs.get("width").toString();
            if (w.endsWith("%")) {
                w = w.substring(0, w.length() - 1);
            } else {
                this.widthCombo.setSelectedIndex(1);
            }
            this.widthField.setEnabled(true);
            try {
                this.widthField.getModel().setValue(new Integer(w));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        } else {
            this.widthCB.setSelected(false);
            this.widthField.setEnabled(false);
            this.widthCombo.setEnabled(false);
        }
        if (this.attribs.containsKey("align")) {
            this.alignCB.setSelected(true);
            this.alignCombo.setEnabled(true);
            this.alignCombo.setSelectedItem(this.attribs.get("align"));
        } else {
            this.alignCB.setSelected(false);
            this.alignCombo.setEnabled(false);
        }
        if (this.attribs.containsKey("border")) {
            this.borderCB.setSelected(true);
            this.borderField.setEnabled(true);
            try {
                this.borderField.getModel().setValue(new Integer(this.attribs.get("border").toString()));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        } else {
            this.borderCB.setSelected(false);
            this.borderField.setEnabled(false);
        }
        if (this.attribs.containsKey("cellpadding")) {
            this.cellPaddingCB.setSelected(true);
            this.cellPaddingField.setEnabled(true);
            try {
                this.cellPaddingField.getModel().setValue(new Integer(this.attribs.get("cellpadding").toString()));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        } else {
            this.cellPaddingCB.setSelected(false);
            this.cellPaddingField.setEnabled(false);
        }
        if (this.attribs.containsKey("cellspacing")) {
            this.cellSpacingCB.setSelected(true);
            this.cellSpacingField.setEnabled(true);
            try {
                this.cellSpacingField.getModel().setValue(new Integer(this.attribs.get("cellspacing").toString()));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        } else {
            this.cellSpacingCB.setSelected(false);
            this.cellSpacingField.setEnabled(false);
        }
        if (this.attribs.containsKey("bgcolor")) {
            this.bgPanel.setSelected(true);
            this.bgPanel.setColor(this.attribs.get("bgcolor").toString());
        } else {
            this.bgPanel.setSelected(false);
        }
    }

    public void updateAttribsFromComponents() {
        if (this.widthCB.isSelected()) {
            String w = this.widthField.getModel().getValue().toString();
            if (this.widthCombo.getSelectedIndex() == 0) {
                w = w + "%";
            }
            this.attribs.put("width", w);
        } else {
            this.attribs.remove("width");
        }
        if (this.alignCB.isSelected()) {
            this.attribs.put("align", this.alignCombo.getSelectedItem().toString());
        } else {
            this.attribs.remove("align");
        }
        if (this.borderCB.isSelected()) {
            this.attribs.put("border", this.borderField.getModel().getValue().toString());
        } else {
            this.attribs.remove("border");
        }
        if (this.cellSpacingCB.isSelected()) {
            this.attribs.put("cellspacing", this.cellSpacingField.getModel().getValue().toString());
        } else {
            this.attribs.remove("cellspacing");
        }
        if (this.cellPaddingCB.isSelected()) {
            this.attribs.put("cellpadding", this.cellPaddingField.getModel().getValue().toString());
        } else {
            this.attribs.remove("cellpadding");
        }
        if (this.bgPanel.isSelected()) {
            this.attribs.put("bgcolor", this.bgPanel.getColor());
        } else {
            this.attribs.remove("bgcolor");
        }
    }

    public void setComponentStates(Hashtable attribs) {
        if (attribs.containsKey("width")) {
            this.widthCB.setSelected(true);
            String w = attribs.get("width").toString();
            if (w.endsWith("%")) {
                w = w.substring(0, w.length() - 1);
            } else {
                this.widthCombo.setSelectedIndex(1);
            }
            try {
                this.widthField.getModel().setValue(new Integer(w));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        } else {
            this.widthCB.setSelected(false);
            this.widthField.setEnabled(false);
            this.widthCombo.setEnabled(false);
        }
        if (attribs.containsKey("align")) {
            this.alignCB.setSelected(true);
            this.alignCombo.setSelectedItem(attribs.get("align"));
        } else {
            this.alignCB.setSelected(false);
            this.alignCombo.setEnabled(false);
        }
        if (attribs.containsKey("border")) {
            this.borderCB.setSelected(true);
            try {
                this.borderField.getModel().setValue(new Integer(attribs.get("border").toString()));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        } else {
            this.borderCB.setSelected(false);
            this.borderField.setEnabled(false);
        }
        if (attribs.containsKey("cellpadding")) {
            this.cellPaddingCB.setSelected(true);
            try {
                this.cellPaddingField.getModel().setValue(new Integer(attribs.get("cellpadding").toString()));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        } else {
            this.cellPaddingCB.setSelected(false);
            this.cellPaddingField.setEnabled(false);
        }
        if (attribs.containsKey("cellspacing")) {
            this.cellSpacingCB.setSelected(true);
            try {
                this.cellSpacingField.getModel().setValue(new Integer(attribs.get("cellspacing").toString()));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        } else {
            this.cellSpacingCB.setSelected(false);
            this.cellSpacingField.setEnabled(false);
        }
        if (attribs.containsKey("bgcolor")) {
            this.bgPanel.setSelected(true);
            this.bgPanel.setColor(attribs.get("bgcolor").toString());
        } else {
            this.bgPanel.setSelected(false);
        }
    }

    private void initialize() {
        GridBagConstraints gridBagConstraints12 = new GridBagConstraints();
        gridBagConstraints12.gridx = 0;
        gridBagConstraints12.anchor = 17;
        gridBagConstraints12.gridwidth = 4;
        gridBagConstraints12.fill = 2;
        gridBagConstraints12.weightx = 0.0;
        gridBagConstraints12.weighty = 1.0;
        gridBagConstraints12.gridy = 4;
        GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
        gridBagConstraints11.gridx = 0;
        gridBagConstraints11.gridwidth = 4;
        gridBagConstraints11.anchor = 17;
        gridBagConstraints11.weighty = 0.0;
        gridBagConstraints11.gridy = 3;
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.fill = 0;
        gridBagConstraints4.gridy = 1;
        gridBagConstraints4.weightx = 0.0;
        gridBagConstraints4.gridwidth = 2;
        gridBagConstraints4.anchor = 17;
        gridBagConstraints4.insets = new Insets(0, 0, 5, 15);
        gridBagConstraints4.gridx = 1;
        GridBagConstraints gridBagConstraints10 = new GridBagConstraints();
        gridBagConstraints10.fill = 0;
        gridBagConstraints10.gridy = 2;
        gridBagConstraints10.weightx = 1.0;
        gridBagConstraints10.anchor = 17;
        gridBagConstraints10.insets = new Insets(0, 0, 10, 0);
        gridBagConstraints10.gridx = 4;
        GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
        gridBagConstraints9.gridx = 3;
        gridBagConstraints9.anchor = 17;
        gridBagConstraints9.insets = new Insets(0, 0, 10, 3);
        gridBagConstraints9.gridy = 2;
        GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
        gridBagConstraints8.fill = 0;
        gridBagConstraints8.gridy = 2;
        gridBagConstraints8.weightx = 0.0;
        gridBagConstraints8.anchor = 17;
        gridBagConstraints8.insets = new Insets(0, 0, 10, 15);
        gridBagConstraints8.gridx = 1;
        GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
        gridBagConstraints7.gridx = 0;
        gridBagConstraints7.anchor = 17;
        gridBagConstraints7.insets = new Insets(0, 0, 10, 3);
        gridBagConstraints7.gridy = 2;
        GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
        gridBagConstraints6.fill = 0;
        gridBagConstraints6.gridy = 1;
        gridBagConstraints6.weightx = 1.0;
        gridBagConstraints6.anchor = 17;
        gridBagConstraints6.insets = new Insets(0, 0, 2, 0);
        gridBagConstraints6.gridx = 4;
        GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
        gridBagConstraints5.gridx = 3;
        gridBagConstraints5.anchor = 17;
        gridBagConstraints5.insets = new Insets(0, 0, 2, 3);
        gridBagConstraints5.gridy = 1;
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridx = 0;
        gridBagConstraints3.anchor = 17;
        gridBagConstraints3.insets = new Insets(0, 0, 2, 3);
        gridBagConstraints3.gridy = 1;
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.fill = 0;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.weightx = 0.0;
        gridBagConstraints2.anchor = 17;
        gridBagConstraints2.gridwidth = 2;
        gridBagConstraints2.insets = new Insets(0, 0, 10, 0);
        gridBagConstraints2.gridx = 2;
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.fill = 0;
        gridBagConstraints1.gridy = 0;
        gridBagConstraints1.weightx = 0.0;
        gridBagConstraints1.anchor = 17;
        gridBagConstraints1.insets = new Insets(0, 0, 10, 0);
        gridBagConstraints1.gridx = 1;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 10, 3);
        gridBagConstraints.gridy = 0;
        this.setLayout(new GridBagLayout());
        this.setSize(320, 140);
        this.setPreferredSize(new Dimension(320, 140));
        this.add((Component)this.getWidthCB(), gridBagConstraints);
        this.add((Component)this.getWidthField(), gridBagConstraints1);
        this.add((Component)this.getWidthCombo(), gridBagConstraints2);
        this.add((Component)this.getAlignCB(), gridBagConstraints3);
        this.add((Component)this.getCellSpacingCB(), gridBagConstraints5);
        this.add((Component)this.getCellSpacingField(), gridBagConstraints6);
        this.add((Component)this.getBorderCB(), gridBagConstraints7);
        this.add((Component)this.getBorderField(), gridBagConstraints8);
        this.add((Component)this.getCellPaddingCB(), gridBagConstraints9);
        this.add((Component)this.getCellPaddingField(), gridBagConstraints10);
        this.add((Component)this.getAlignCombo(), gridBagConstraints4);
        this.add((Component)this.getBGPanel(), gridBagConstraints11);
        this.add((Component)this.getExpansionPanel(), gridBagConstraints12);
    }

    private JCheckBox getWidthCB() {
        if (this.widthCB == null) {
            this.widthCB = new JCheckBox();
            this.widthCB.setText(i18n.str("width"));
            this.widthCB.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    TableAttributesPanel.this.widthField.setEnabled(TableAttributesPanel.this.widthCB.isSelected());
                    TableAttributesPanel.this.widthCombo.setEnabled(TableAttributesPanel.this.widthCB.isSelected());
                }
            });
        }
        return this.widthCB;
    }

    private JSpinner getWidthField() {
        if (this.widthField == null) {
            this.widthField = new JSpinner(new SpinnerNumberModel(100, 1, 999, 1));
        }
        return this.widthField;
    }

    private JComboBox getWidthCombo() {
        if (this.widthCombo == null) {
            this.widthCombo = new JComboBox<String>(MEASUREMENTS);
        }
        return this.widthCombo;
    }

    private JCheckBox getAlignCB() {
        if (this.alignCB == null) {
            this.alignCB = new JCheckBox();
            this.alignCB.setText(i18n.str("align"));
            this.alignCB.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    TableAttributesPanel.this.alignCombo.setEnabled(TableAttributesPanel.this.alignCB.isSelected());
                }
            });
        }
        return this.alignCB;
    }

    private JCheckBox getCellSpacingCB() {
        if (this.cellSpacingCB == null) {
            this.cellSpacingCB = new JCheckBox();
            this.cellSpacingCB.setText(i18n.str("cellspacing"));
            this.cellSpacingCB.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    TableAttributesPanel.this.cellSpacingField.setEnabled(TableAttributesPanel.this.cellSpacingCB.isSelected());
                }
            });
        }
        return this.cellSpacingCB;
    }

    private JSpinner getCellSpacingField() {
        if (this.cellSpacingField == null) {
            this.cellSpacingField = new JSpinner(new SpinnerNumberModel(1, 0, 999, 1));
        }
        return this.cellSpacingField;
    }

    private JCheckBox getBorderCB() {
        if (this.borderCB == null) {
            this.borderCB = new JCheckBox();
            this.borderCB.setText(i18n.str("border"));
            this.borderCB.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    TableAttributesPanel.this.borderField.setEnabled(TableAttributesPanel.this.borderCB.isSelected());
                }
            });
        }
        return this.borderCB;
    }

    private JSpinner getBorderField() {
        if (this.borderField == null) {
            this.borderField = new JSpinner(new SpinnerNumberModel(1, 0, 999, 1));
        }
        return this.borderField;
    }

    private JCheckBox getCellPaddingCB() {
        if (this.cellPaddingCB == null) {
            this.cellPaddingCB = new JCheckBox();
            this.cellPaddingCB.setText(i18n.str("cellpadding"));
            this.cellPaddingCB.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    TableAttributesPanel.this.cellPaddingField.setEnabled(TableAttributesPanel.this.cellPaddingCB.isSelected());
                }
            });
        }
        return this.cellPaddingCB;
    }

    private JSpinner getCellPaddingField() {
        if (this.cellPaddingField == null) {
            this.cellPaddingField = new JSpinner(new SpinnerNumberModel(1, 0, 999, 1));
        }
        return this.cellPaddingField;
    }

    private JComboBox getAlignCombo() {
        if (this.alignCombo == null) {
            this.alignCombo = new JComboBox<String>(ALIGNMENTS);
        }
        return this.alignCombo;
    }

    private JPanel getBGPanel() {
        if (this.bgPanel == null) {
            this.bgPanel = new BGColorPanel();
        }
        return this.bgPanel;
    }

    private JPanel getExpansionPanel() {
        if (this.expansionPanel == null) {
            this.expansionPanel = new JPanel();
        }
        return this.expansionPanel;
    }
}

