/*
 * Decompiled with CFR 0.152.
 */
package org.soulwing.ssl;

import java.net.URI;
import java.net.URL;
import java.security.KeyStore;
import java.security.Provider;
import org.soulwing.ssl.KeyStoreFactory;
import org.soulwing.ssl.KeyStoreSubBuilder;
import org.soulwing.ssl.SSLContextBuilder;
import org.soulwing.ssl.SSLRuntimeException;

class ConcreteKeyStoreSubBuilder
implements KeyStoreSubBuilder {
    private final KeyStoreFactory factory = new KeyStoreFactory();
    private final EndHandler endHandler;

    public ConcreteKeyStoreSubBuilder(EndHandler endHandler) {
        this.endHandler = endHandler;
    }

    @Override
    public KeyStoreSubBuilder type(String type) {
        this.factory.setType(type);
        return this;
    }

    @Override
    public KeyStoreSubBuilder provider(String providerName) {
        this.factory.setProvider(providerName);
        return this;
    }

    @Override
    public KeyStoreSubBuilder provider(Provider provider) {
        this.factory.setProvider(provider);
        return this;
    }

    @Override
    public KeyStoreSubBuilder password(char[] password) {
        this.factory.setPassword(password);
        return this;
    }

    @Override
    public KeyStoreSubBuilder password(String password) {
        this.factory.setPassword(password);
        return this;
    }

    @Override
    public KeyStoreSubBuilder location(URL location) {
        this.factory.setLocation(location);
        return this;
    }

    @Override
    public KeyStoreSubBuilder location(String location) throws SSLRuntimeException {
        this.factory.setLocation(location);
        return this;
    }

    @Override
    public KeyStoreSubBuilder location(URI location) {
        this.factory.setLocation(location);
        return this;
    }

    @Override
    public KeyStoreSubBuilder location(String location, Class<?> relativeToClass) {
        this.factory.setLocation(location, relativeToClass);
        return this;
    }

    @Override
    public KeyStoreSubBuilder location(String location, ClassLoader classLoader) {
        this.factory.setLocation(location, classLoader);
        return this;
    }

    @Override
    public SSLContextBuilder end() {
        return this.endHandler.handleEnd(this.factory.newKeyStore(), this.factory.getPassword());
    }

    static interface EndHandler {
        public SSLContextBuilder handleEnd(KeyStore var1, char[] var2);
    }
}

