/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.cte300.webservices;

import com.fincatto.documentofiscal.DFModelo;
import com.fincatto.documentofiscal.cte.CTeConfig;
import com.fincatto.documentofiscal.cte300.classes.evento.CTeEvento;
import com.fincatto.documentofiscal.cte300.classes.evento.CTeEventoRetorno;
import com.fincatto.documentofiscal.cte300.classes.evento.comprovanteentrega.CTeEnviaEventoCancelamentoComprovanteEntrega;
import com.fincatto.documentofiscal.cte300.webservices.WSRecepcaoEvento;
import com.fincatto.documentofiscal.utils.DFAssinaturaDigital;
import com.fincatto.documentofiscal.validadores.DFXMLValidador;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import org.apache.axiom.om.OMElement;

class WSCancelamentoComprovanteEntrega
extends WSRecepcaoEvento {
    private static final String DESCRICAO_EVENTO = "Cancelamento do Comprovante de Entrega do CT-e";
    private static final BigDecimal VERSAO_LEIAUTE = new BigDecimal("3.00");
    private static final String EVENTO_COMPROVANTE_DE_ENTREGA = "110181";
    private static final List<DFModelo> modelosPermitidos = Arrays.asList(DFModelo.CTE);

    WSCancelamentoComprovanteEntrega(CTeConfig cTeConfig) {
        super(cTeConfig, modelosPermitidos);
    }

    CTeEventoRetorno cancelaComprovanteEntregaAssinado(String string, String string2) throws Exception {
        OMElement oMElement = super.efetuaEvento(string2, string, VERSAO_LEIAUTE);
        return (CTeEventoRetorno)this.config.getPersister().read(CTeEventoRetorno.class, oMElement.toString());
    }

    CTeEventoRetorno cancelaComprovanteEntrega(String string, String string2, String string3, int n) throws Exception {
        String string4 = this.getXmlAssinado(string, string2, string3, n);
        return this.cancelaComprovanteEntregaAssinado(string, string4);
    }

    String getXmlAssinado(String string, String string2, String string3, int n) throws Exception {
        String string4 = this.gerarDadosCancelamentoComprovanteEntrega(string, string2, string3, n).toString();
        return new DFAssinaturaDigital(this.config).assinarDocumento(string4);
    }

    private CTeEvento gerarDadosCancelamentoComprovanteEntrega(String string, String string2, String string3, int n) throws Exception {
        CTeEnviaEventoCancelamentoComprovanteEntrega cTeEnviaEventoCancelamentoComprovanteEntrega = new CTeEnviaEventoCancelamentoComprovanteEntrega();
        cTeEnviaEventoCancelamentoComprovanteEntrega.setDescricaoEvento(DESCRICAO_EVENTO);
        cTeEnviaEventoCancelamentoComprovanteEntrega.setProtocoloAutorizacao(string2);
        cTeEnviaEventoCancelamentoComprovanteEntrega.setProtocoloComprovanteEntrega(string3);
        DFXMLValidador.validaEventoCancelamentoComprovanteEntregaCTe300(cTeEnviaEventoCancelamentoComprovanteEntrega.toString());
        return super.gerarEvento(string, VERSAO_LEIAUTE, cTeEnviaEventoCancelamentoComprovanteEntrega, EVENTO_COMPROVANTE_DE_ENTREGA, null, n);
    }
}

