/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.cte300.webservices;

import com.fincatto.documentofiscal.DFLog;
import com.fincatto.documentofiscal.cte.CTeConfig;
import com.fincatto.documentofiscal.cte300.classes.CTAutorizador31;
import com.fincatto.documentofiscal.cte300.classes.enviolote.CTeEnvioLote;
import com.fincatto.documentofiscal.cte300.classes.enviolote.CTeEnvioLoteRetorno;
import com.fincatto.documentofiscal.cte300.classes.enviolote.CTeEnvioLoteRetornoDados;
import com.fincatto.documentofiscal.cte300.webservices.recepcao.CteRecepcaoStub;
import com.fincatto.documentofiscal.utils.DFAssinaturaDigital;
import com.fincatto.documentofiscal.validadores.DFXMLValidador;
import java.io.StringReader;
import java.util.Iterator;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;

class WSRecepcaoLote
implements DFLog {
    private static final String CTE_ELEMENTO = "CTe";
    private final CTeConfig config;

    WSRecepcaoLote(CTeConfig cTeConfig) {
        this.config = cTeConfig;
    }

    public CTeEnvioLoteRetornoDados envioRecepcao(CTeEnvioLote cTeEnvioLote) throws Exception {
        String string = new DFAssinaturaDigital(this.config).assinarDocumento(cTeEnvioLote.toString(), "infCte");
        CTeEnvioLote cTeEnvioLote2 = (CTeEnvioLote)this.config.getPersister().read(CTeEnvioLote.class, string);
        CTeEnvioLoteRetorno cTeEnvioLoteRetorno = this.comunicaLote(string);
        return new CTeEnvioLoteRetornoDados(cTeEnvioLoteRetorno, cTeEnvioLote2);
    }

    private CTeEnvioLoteRetorno comunicaLote(String string) throws Exception {
        DFXMLValidador.validaLoteCTe300(string);
        OMElement oMElement = this.cteToOMElement(string);
        CteRecepcaoStub.CteDadosMsg cteDadosMsg = new CteRecepcaoStub.CteDadosMsg();
        cteDadosMsg.setExtraElement(oMElement);
        CteRecepcaoStub.CteCabecMsgE cteCabecMsgE = this.getCabecalhoSOAP();
        this.getLogger().debug(oMElement.toString());
        CTAutorizador31 cTAutorizador31 = CTAutorizador31.valueOfTipoEmissao(this.config.getTipoEmissao(), this.config.getCUF());
        String string2 = cTAutorizador31.getCteRecepcao(this.config.getAmbiente());
        if (string2 == null) {
            throw new IllegalArgumentException("Nao foi possivel encontrar URL para Recepcao, autorizador " + cTAutorizador31.name() + ", UF " + this.config.getCUF().name());
        }
        CteRecepcaoStub.CteRecepcaoLoteResult cteRecepcaoLoteResult = new CteRecepcaoStub(string2, this.config).cteRecepcaoLote(cteDadosMsg, cteCabecMsgE);
        CTeEnvioLoteRetorno cTeEnvioLoteRetorno = (CTeEnvioLoteRetorno)this.config.getPersister().read(CTeEnvioLoteRetorno.class, cteRecepcaoLoteResult.getExtraElement().toString());
        this.getLogger().debug(cTeEnvioLoteRetorno.toString());
        return cTeEnvioLoteRetorno;
    }

    private CteRecepcaoStub.CteCabecMsgE getCabecalhoSOAP() {
        CteRecepcaoStub.CteCabecMsg cteCabecMsg = new CteRecepcaoStub.CteCabecMsg();
        cteCabecMsg.setCUF(this.config.getCUF().getCodigoIbge());
        cteCabecMsg.setVersaoDados("3.00");
        CteRecepcaoStub.CteCabecMsgE cteCabecMsgE = new CteRecepcaoStub.CteCabecMsgE();
        cteCabecMsgE.setCteCabecMsg(cteCabecMsg);
        return cteCabecMsgE;
    }

    private OMElement cteToOMElement(String string) throws XMLStreamException {
        XMLInputFactory xMLInputFactory = XMLInputFactory.newInstance();
        xMLInputFactory.setProperty("javax.xml.stream.isCoalescing", false);
        XMLStreamReader xMLStreamReader = xMLInputFactory.createXMLStreamReader(new StringReader(string));
        StAXOMBuilder stAXOMBuilder = new StAXOMBuilder(xMLStreamReader);
        OMElement oMElement = stAXOMBuilder.getDocumentElement();
        Iterator iterator = oMElement.getChildrenWithLocalName(CTE_ELEMENTO);
        while (iterator.hasNext()) {
            OMElement oMElement2 = (OMElement)iterator.next();
            if (oMElement2 == null || !CTE_ELEMENTO.equals(oMElement2.getLocalName())) continue;
            oMElement2.addAttribute("xmlns", "http://www.portalfiscal.inf.br/cte", null);
        }
        return oMElement;
    }
}

