/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.cte300.webservices;

import com.fincatto.documentofiscal.DFLog;
import com.fincatto.documentofiscal.DFUnidadeFederativa;
import com.fincatto.documentofiscal.cte.CTeConfig;
import com.fincatto.documentofiscal.cte300.classes.CTAutorizador31;
import com.fincatto.documentofiscal.cte300.classes.consultastatusservico.CTeConsStatServ;
import com.fincatto.documentofiscal.cte300.classes.consultastatusservico.CTeConsStatServRet;
import com.fincatto.documentofiscal.cte300.webservices.statusservico.CteStatusServicoStub;
import java.rmi.RemoteException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.AXIOMUtil;

class WSStatusConsulta
implements DFLog {
    private static final String NOME_SERVICO = "STATUS";
    private final CTeConfig config;

    WSStatusConsulta(CTeConfig cTeConfig) {
        this.config = cTeConfig;
    }

    CTeConsStatServRet consultaStatus(DFUnidadeFederativa dFUnidadeFederativa) throws Exception {
        OMElement oMElement = AXIOMUtil.stringToOM((String)WSStatusConsulta.gerarDadosConsulta(this.config).toString());
        this.getLogger().debug(oMElement.toString());
        OMElement oMElement2 = this.efetuaConsultaStatus(oMElement, dFUnidadeFederativa);
        this.getLogger().debug(oMElement2.toString());
        return (CTeConsStatServRet)this.config.getPersister().read(CTeConsStatServRet.class, oMElement2.toString());
    }

    private static CTeConsStatServ gerarDadosConsulta(CTeConfig cTeConfig) {
        CTeConsStatServ cTeConsStatServ = new CTeConsStatServ();
        cTeConsStatServ.setAmbiente(cTeConfig.getAmbiente());
        cTeConsStatServ.setVersao("3.00");
        cTeConsStatServ.setServico(NOME_SERVICO);
        return cTeConsStatServ;
    }

    private OMElement efetuaConsultaStatus(OMElement oMElement, DFUnidadeFederativa dFUnidadeFederativa) throws RemoteException {
        CteStatusServicoStub.CteCabecMsg cteCabecMsg = new CteStatusServicoStub.CteCabecMsg();
        cteCabecMsg.setCUF(dFUnidadeFederativa.getCodigoIbge());
        cteCabecMsg.setVersaoDados("3.00");
        CteStatusServicoStub.CteCabecMsgE cteCabecMsgE = new CteStatusServicoStub.CteCabecMsgE();
        cteCabecMsgE.setCteCabecMsg(cteCabecMsg);
        CteStatusServicoStub.CteDadosMsg cteDadosMsg = new CteStatusServicoStub.CteDadosMsg();
        cteDadosMsg.setExtraElement(oMElement);
        CTAutorizador31 cTAutorizador31 = CTAutorizador31.valueOfCodigoUF(dFUnidadeFederativa);
        String string = cTAutorizador31.getCteStatusServico(this.config.getAmbiente());
        if (string == null) {
            throw new IllegalArgumentException("Nao foi possivel encontrar URL para StatusServico, autorizador " + cTAutorizador31.name() + ", UF " + dFUnidadeFederativa.name());
        }
        return new CteStatusServicoStub(string, this.config).cteStatusServicoCT(cteDadosMsg, cteCabecMsgE).getExtraElement();
    }
}

