/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.cte400.classes.nota;

import com.fincatto.documentofiscal.DFBase;
import com.fincatto.documentofiscal.cte400.classes.CTModeloNF;
import com.fincatto.documentofiscal.cte400.classes.nota.CTeNotaInfoCTeNormalInfoDocumentosInfoUnidadeCarga;
import com.fincatto.documentofiscal.cte400.classes.nota.CTeNotaInfoCTeNormalInfoDocumentosInfoUnidadeTransporte;
import com.fincatto.documentofiscal.validadores.DFBigDecimalValidador;
import com.fincatto.documentofiscal.validadores.DFStringValidador;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Namespace;
import org.simpleframework.xml.Root;

@Root(name="infNF")
@Namespace(reference="http://www.portalfiscal.inf.br/cte")
public class CTeNotaInfoCTeNormalInfoDocumentosInfoNF
extends DFBase {
    private static final long serialVersionUID = 6286219809877808613L;
    @Element(name="nRoma", required=false)
    private String numeroRomaneio;
    @Element(name="nPed", required=false)
    private String numeroPedidoNF;
    @Element(name="mod")
    private CTModeloNF modeloNF;
    @Element(name="serie")
    private String serie;
    @Element(name="nDoc")
    private String numeroDocumento;
    @Element(name="dEmi")
    private LocalDate dataEmissao;
    @Element(name="vBC")
    private String valorBcICMS;
    @Element(name="vICMS")
    private String valorICMS;
    @Element(name="vBCST")
    private String valorBcICMSST;
    @Element(name="vST")
    private String valorICMSST;
    @Element(name="vProd")
    private String valorTotalProdutos;
    @Element(name="vNF")
    private String valorTotalNF;
    @Element(name="nCFOP")
    private String CFOP;
    @Element(name="nPeso", required=false)
    private String valorPesoTotal;
    @Element(name="PIN", required=false)
    private String pinSUFRAMA;
    @Element(name="dPrev", required=false)
    private LocalDate dataPrevistaEntrega;
    @ElementList(name="infUnidCarga", inline=true, required=false)
    private List<CTeNotaInfoCTeNormalInfoDocumentosInfoUnidadeCarga> infoUnidadeCarga;
    @ElementList(name="infUnidTransp", inline=true, required=false)
    private List<CTeNotaInfoCTeNormalInfoDocumentosInfoUnidadeTransporte> infoUnidadeTransporte;

    public String getNumeroRomaneio() {
        return this.numeroRomaneio;
    }

    public void setNumeroRomaneio(String string) {
        DFStringValidador.tamanho20(string, "N\u00famero do Romaneio da NF");
        this.numeroRomaneio = string;
    }

    public String getNumeroPedidoNF() {
        return this.numeroPedidoNF;
    }

    public void setNumeroPedidoNF(String string) {
        DFStringValidador.tamanho20(string, "N\u00famero do Pedido da NF");
        this.numeroPedidoNF = string;
    }

    public CTModeloNF getModeloNF() {
        return this.modeloNF;
    }

    public void setModeloNF(CTModeloNF cTModeloNF) {
        this.modeloNF = cTModeloNF;
    }

    public String getSerie() {
        return this.serie;
    }

    public void setSerie(String string) {
        DFStringValidador.tamanho3(string, "S\u00e9rie");
        this.serie = string;
    }

    public String getNumeroDocumento() {
        return this.numeroDocumento;
    }

    public void setNumeroDocumento(String string) {
        DFStringValidador.tamanho20(string, "N\u00famero");
        this.numeroDocumento = string;
    }

    public LocalDate getDataEmissao() {
        return this.dataEmissao;
    }

    public void setDataEmissao(LocalDate localDate) {
        this.dataEmissao = localDate;
    }

    public String getValorBcICMS() {
        return this.valorBcICMS;
    }

    public void setValorBcICMS(BigDecimal bigDecimal) {
        this.valorBcICMS = DFBigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "Valor da Base de C\u00e1lculo do ICMS");
    }

    public String getValorICMS() {
        return this.valorICMS;
    }

    public void setValorICMS(BigDecimal bigDecimal) {
        this.valorICMS = DFBigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "Valor Total do ICMS");
    }

    public String getValorBcICMSST() {
        return this.valorBcICMSST;
    }

    public void setValorBcICMSST(BigDecimal bigDecimal) {
        this.valorBcICMSST = DFBigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "Valor da Base de C\u00e1lculo do ICMS ST");
    }

    public String getValorICMSST() {
        return this.valorICMSST;
    }

    public void setValorICMSST(BigDecimal bigDecimal) {
        this.valorICMSST = DFBigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "Valor Total do ICMS ST");
    }

    public String getValorTotalProdutos() {
        return this.valorTotalProdutos;
    }

    public void setValorTotalProdutos(BigDecimal bigDecimal) {
        this.valorTotalProdutos = DFBigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "Valor Total dos Produtos");
    }

    public String getValorTotalNF() {
        return this.valorTotalNF;
    }

    public void setValorTotalNF(BigDecimal bigDecimal) {
        this.valorTotalNF = DFBigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "Valor Total da NF");
    }

    public String getCFOP() {
        return this.CFOP;
    }

    public void setCFOP(String string) {
        DFStringValidador.exatamente4N(string, "CFOP");
        this.CFOP = string;
    }

    public String getValorPesoTotal() {
        return this.valorPesoTotal;
    }

    public void setValorPesoTotal(BigDecimal bigDecimal) {
        this.valorPesoTotal = DFBigDecimalValidador.tamanho15Com3CasasDecimais(bigDecimal, "Peso total em Kg");
    }

    public String getPinSUFRAMA() {
        return this.pinSUFRAMA;
    }

    public void setPinSUFRAMA(String string) {
        DFStringValidador.tamanho2a9N(string, "PIN SUFRAMA");
        this.pinSUFRAMA = string;
    }

    public LocalDate getDataPrevistaEntrega() {
        return this.dataPrevistaEntrega;
    }

    public void setDataPrevistaEntrega(LocalDate localDate) {
        this.dataPrevistaEntrega = localDate;
    }

    public List<CTeNotaInfoCTeNormalInfoDocumentosInfoUnidadeCarga> getInfoUnidadeCarga() {
        return this.infoUnidadeCarga;
    }

    public void setInfoUnidadeCarga(List<CTeNotaInfoCTeNormalInfoDocumentosInfoUnidadeCarga> list) {
        this.infoUnidadeCarga = list;
    }

    public List<CTeNotaInfoCTeNormalInfoDocumentosInfoUnidadeTransporte> getInfoUnidadeTransporte() {
        return this.infoUnidadeTransporte;
    }

    public void setInfoUnidadeTransporte(List<CTeNotaInfoCTeNormalInfoDocumentosInfoUnidadeTransporte> list) {
        this.infoUnidadeTransporte = list;
    }
}

