/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.mdfe3.classes.nota.evento;

import com.fincatto.documentofiscal.DFAmbiente;
import com.fincatto.documentofiscal.DFBase;
import com.fincatto.documentofiscal.mdfe3.classes.nota.evento.MDFeDetalhamentoEvento;
import com.fincatto.documentofiscal.validadores.DFBigDecimalValidador;
import com.fincatto.documentofiscal.validadores.DFIntegerValidador;
import com.fincatto.documentofiscal.validadores.DFStringValidador;
import java.math.BigDecimal;
import java.time.ZonedDateTime;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.Root;

@Root(name="infEvento")
public class MDFeInfoEvento
extends DFBase {
    private static final long serialVersionUID = -9002694768514200146L;
    @Attribute(name="Id", required=false)
    private String id;
    @Element(name="cOrgao", required=false)
    private String orgao;
    @Element(name="tpAmb")
    private DFAmbiente ambiente;
    @Element(name="CNPJ", required=false)
    private String cnpj;
    @Element(name="chMDFe")
    private String chave;
    @Element(name="dhEvento")
    private ZonedDateTime dataHoraEvento;
    @Element(name="tpEvento")
    private String codigoEvento;
    @Element(name="nSeqEvento")
    private Integer numeroSequencialEvento;
    @Element(name="verEvento", required=false)
    private String versaoEvento;
    @Element(name="detEvento")
    private MDFeDetalhamentoEvento detEvento;

    public void setOrgao(String string) {
        this.orgao = string;
    }

    public void setVersaoEvento(BigDecimal bigDecimal) {
        this.versaoEvento = DFBigDecimalValidador.tamanho5Com2CasasDecimais(bigDecimal, "Versao do Evento");
    }

    public String getId() {
        return this.id;
    }

    public void setId(String string) {
        DFStringValidador.exatamente54(string, "Info Evento  ID");
        this.id = string;
    }

    public DFAmbiente getAmbiente() {
        return this.ambiente;
    }

    public void setAmbiente(DFAmbiente dFAmbiente) {
        this.ambiente = dFAmbiente;
    }

    public String getCnpj() {
        return this.cnpj;
    }

    public void setCnpj(String string) {
        DFStringValidador.cnpj(string);
        this.cnpj = string;
    }

    public String getChave() {
        return this.chave;
    }

    public void setChave(String string) {
        DFStringValidador.exatamente44N(string, "Info Evento Cancelamento Chave");
        this.chave = string;
    }

    public ZonedDateTime getDataHoraEvento() {
        return this.dataHoraEvento;
    }

    public void setDataHoraEvento(ZonedDateTime zonedDateTime) {
        this.dataHoraEvento = zonedDateTime;
    }

    public String getCodigoEvento() {
        return this.codigoEvento;
    }

    public void setCodigoEvento(String string) {
        DFStringValidador.exatamente6N(string, "Info Evento Cancelamento Codigo");
        this.codigoEvento = string;
    }

    public int getNumeroSequencialEvento() {
        return this.numeroSequencialEvento;
    }

    public void setNumeroSequencialEvento(int n) {
        DFIntegerValidador.tamanho1a2(n, "Numero Sequencial Evento");
        this.numeroSequencialEvento = n;
    }

    public String getVersaoEvento() {
        return this.versaoEvento;
    }

    public String getOrgao() {
        return this.orgao;
    }

    public void setNumeroSequencialEvento(Integer n) {
        this.numeroSequencialEvento = n;
    }

    public void setVersaoEvento(String string) {
        this.versaoEvento = string;
    }

    public MDFeDetalhamentoEvento getDetEvento() {
        return this.detEvento;
    }

    public void setDetEvento(MDFeDetalhamentoEvento mDFeDetalhamentoEvento) {
        this.detEvento = mDFeDetalhamentoEvento;
    }
}

