/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.nfe310.classes.nota;

import com.fincatto.documentofiscal.DFBase;
import com.fincatto.documentofiscal.DFUnidadeFederativa;
import com.fincatto.documentofiscal.validadores.DFBigDecimalValidador;
import com.fincatto.documentofiscal.validadores.DFStringValidador;
import java.math.BigDecimal;
import java.time.LocalDate;
import org.simpleframework.xml.Element;

public class NFNotaInfoAvulsa
extends DFBase {
    private static final long serialVersionUID = 724335920156427201L;
    @Element(name="CNPJ")
    private String cnpj;
    @Element(name="xOrgao")
    private String orgaoEmitente;
    @Element(name="matr")
    private String matriculaAgente;
    @Element(name="xAgente")
    private String nomeAgente;
    @Element(name="fone", required=false)
    private String fone;
    @Element(name="UF")
    private String uf;
    @Element(name="nDAR", required=false)
    private String numeroDocumentoArrecadacaoReceita;
    @Element(name="dEmi", required=false)
    private LocalDate dataEmissaoDocumentoArrecadacao;
    @Element(name="vDAR", required=false)
    private String valorTotalConstanteDocumentoArrecadacaoReceita;
    @Element(name="repEmi")
    private String reparticaoFiscalEmitente;
    @Element(name="dPag", required=false)
    private LocalDate dataPagamentoDocumentoArrecadacao;

    public void setCnpj(String string) {
        DFStringValidador.cnpj(string);
        this.cnpj = string;
    }

    public void setOrgaoEmitente(String string) {
        DFStringValidador.tamanho60(string, "Orgao Emitente");
        this.orgaoEmitente = string;
    }

    public void setMatriculaAgente(String string) {
        DFStringValidador.tamanho60(string, "Matricula Agente");
        this.matriculaAgente = string;
    }

    public void setNomeAgente(String string) {
        DFStringValidador.tamanho60(string, "Nome Agente");
        this.nomeAgente = string;
    }

    public void setFone(String string) {
        DFStringValidador.telefone(string);
        this.fone = string;
    }

    public void setUf(DFUnidadeFederativa dFUnidadeFederativa) {
        this.uf = dFUnidadeFederativa.getCodigo();
    }

    public void setNumeroDocumentoArrecadacaoReceita(String string) {
        DFStringValidador.tamanho60(string, "Numero Documento Arrecadacao Receita");
        this.numeroDocumentoArrecadacaoReceita = string;
    }

    public void setDataEmissaoDocumentoArrecadacao(LocalDate localDate) {
        this.dataEmissaoDocumentoArrecadacao = localDate;
    }

    public void setValorTotalConstanteDocumentoArrecadacaoReceita(BigDecimal bigDecimal) {
        this.valorTotalConstanteDocumentoArrecadacaoReceita = DFBigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "Valor Total Constante Documento Arrecadacao Receita");
    }

    public void setReparticaoFiscalEmitente(String string) {
        DFStringValidador.tamanho60(string, "Reparticao Fiscal Emitente");
        this.reparticaoFiscalEmitente = string;
    }

    public void setDataPagamentoDocumentoArrecadacao(LocalDate localDate) {
        this.dataPagamentoDocumentoArrecadacao = localDate;
    }

    public String getCnpj() {
        return this.cnpj;
    }

    public String getOrgaoEmitente() {
        return this.orgaoEmitente;
    }

    public String getMatriculaAgente() {
        return this.matriculaAgente;
    }

    public String getNomeAgente() {
        return this.nomeAgente;
    }

    public String getFone() {
        return this.fone;
    }

    public String getUf() {
        return this.uf;
    }

    public String getNumeroDocumentoArrecadacaoReceita() {
        return this.numeroDocumentoArrecadacaoReceita;
    }

    public LocalDate getDataEmissaoDocumentoArrecadacao() {
        return this.dataEmissaoDocumentoArrecadacao;
    }

    public String getValorTotalConstanteDocumentoArrecadacaoReceita() {
        return this.valorTotalConstanteDocumentoArrecadacaoReceita;
    }

    public String getReparticaoFiscalEmitente() {
        return this.reparticaoFiscalEmitente;
    }

    public LocalDate getDataPagamentoDocumentoArrecadacao() {
        return this.dataPagamentoDocumentoArrecadacao;
    }
}

