/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.nfe310.classes.nota;

import com.fincatto.documentofiscal.DFBase;
import com.fincatto.documentofiscal.nfe310.classes.NFNotaInfoImpostoTributacaoICMS;
import com.fincatto.documentofiscal.nfe310.classes.NFNotaInfoItemModalidadeBCICMS;
import com.fincatto.documentofiscal.nfe310.classes.NFNotaInfoItemModalidadeBCICMSST;
import com.fincatto.documentofiscal.nfe310.classes.NFNotaMotivoDesoneracaoICMS;
import com.fincatto.documentofiscal.nfe310.classes.NFOrigem;
import com.fincatto.documentofiscal.validadores.DFBigDecimalValidador;
import java.math.BigDecimal;
import org.simpleframework.xml.Element;

public class NFNotaInfoItemImpostoICMS90
extends DFBase {
    private static final long serialVersionUID = 5614463736855881160L;
    @Element(name="orig")
    private NFOrigem origem;
    @Element(name="CST")
    private NFNotaInfoImpostoTributacaoICMS situacaoTributaria;
    @Element(name="modBC", required=false)
    private NFNotaInfoItemModalidadeBCICMS modalidadeBCICMS;
    @Element(name="vBC", required=false)
    private String valorBC;
    @Element(name="pRedBC", required=false)
    private String percentualReducaoBC;
    @Element(name="pICMS", required=false)
    private String percentualAliquota;
    @Element(name="vICMS", required=false)
    private String valorTributo;
    @Element(name="modBCST", required=false)
    private NFNotaInfoItemModalidadeBCICMSST modalidadeBCICMSST;
    @Element(name="pMVAST", required=false)
    private String percentualMargemValorAdicionadoICMSST;
    @Element(name="pRedBCST", required=false)
    private String percentualReducaoBCICMSST;
    @Element(name="vBCST", required=false)
    private String valorBCST;
    @Element(name="pICMSST", required=false)
    private String percentualAliquotaImpostoICMSST;
    @Element(name="vICMSST", required=false)
    private String valorICMSST;
    @Element(name="vICMSDeson", required=false)
    private String valorICMSDesoneracao;
    @Element(name="motDesICMS", required=false)
    private NFNotaMotivoDesoneracaoICMS desoneracao;

    public void setOrigem(NFOrigem nFOrigem) {
        this.origem = nFOrigem;
    }

    public void setSituacaoTributaria(NFNotaInfoImpostoTributacaoICMS nFNotaInfoImpostoTributacaoICMS) {
        this.situacaoTributaria = nFNotaInfoImpostoTributacaoICMS;
    }

    public void setModalidadeBCICMS(NFNotaInfoItemModalidadeBCICMS nFNotaInfoItemModalidadeBCICMS) {
        this.modalidadeBCICMS = nFNotaInfoItemModalidadeBCICMS;
    }

    public void setValorBC(BigDecimal bigDecimal) {
        this.valorBC = DFBigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "Valor BC ICMS90 Item");
    }

    public void setPercentualReducaoBC(BigDecimal bigDecimal) {
        this.percentualReducaoBC = DFBigDecimalValidador.tamanho7ComAte4CasasDecimais(bigDecimal, "Percentual Reducao BC ICMS90 Item");
    }

    public void setPercentualAliquota(BigDecimal bigDecimal) {
        this.percentualAliquota = DFBigDecimalValidador.tamanho7ComAte4CasasDecimais(bigDecimal, "Aliquota ICMS90 Item");
    }

    public void setValorTributo(BigDecimal bigDecimal) {
        this.valorTributo = DFBigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "Valor Tributo ICMS90 Item");
    }

    public void setModalidadeBCICMSST(NFNotaInfoItemModalidadeBCICMSST nFNotaInfoItemModalidadeBCICMSST) {
        this.modalidadeBCICMSST = nFNotaInfoItemModalidadeBCICMSST;
    }

    public void setPercentualMargemValorAdicionadoICMSST(BigDecimal bigDecimal) {
        this.percentualMargemValorAdicionadoICMSST = DFBigDecimalValidador.tamanho7ComAte4CasasDecimais(bigDecimal, "Percentual Margem Valor Adicionado ICMS ST ICMS90 Item");
    }

    public void setPercentualReducaoBCICMSST(BigDecimal bigDecimal) {
        this.percentualReducaoBCICMSST = DFBigDecimalValidador.tamanho7ComAte4CasasDecimais(bigDecimal, "Percentual Reducao BC ICMS ST ICMS90 Item");
    }

    public void setValorBCST(BigDecimal bigDecimal) {
        this.valorBCST = DFBigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "Valor BC ST ICMS90 Item");
    }

    public void setPercentualAliquotaImpostoICMSST(BigDecimal bigDecimal) {
        this.percentualAliquotaImpostoICMSST = DFBigDecimalValidador.tamanho7ComAte4CasasDecimais(bigDecimal, "Aliquota Imposto ICMS ST ICMS90 Item");
    }

    public void setValorICMSST(BigDecimal bigDecimal) {
        this.valorICMSST = DFBigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "Valor ICMS ST ICMS90 Item");
    }

    public void setDesoneracao(NFNotaMotivoDesoneracaoICMS nFNotaMotivoDesoneracaoICMS) {
        this.desoneracao = nFNotaMotivoDesoneracaoICMS;
    }

    public void setValorICMSDesoneracao(BigDecimal bigDecimal) {
        this.valorICMSDesoneracao = DFBigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "Valor ICMS Desoneracao ICMS90 Item");
    }

    public NFOrigem getOrigem() {
        return this.origem;
    }

    public NFNotaInfoImpostoTributacaoICMS getSituacaoTributaria() {
        return this.situacaoTributaria;
    }

    public NFNotaInfoItemModalidadeBCICMS getModalidadeBCICMS() {
        return this.modalidadeBCICMS;
    }

    public String getValorBC() {
        return this.valorBC;
    }

    public String getPercentualReducaoBC() {
        return this.percentualReducaoBC;
    }

    public String getPercentualAliquota() {
        return this.percentualAliquota;
    }

    public String getValorTributo() {
        return this.valorTributo;
    }

    public NFNotaInfoItemModalidadeBCICMSST getModalidadeBCICMSST() {
        return this.modalidadeBCICMSST;
    }

    public String getPercentualMargemValorAdicionadoICMSST() {
        return this.percentualMargemValorAdicionadoICMSST;
    }

    public String getPercentualReducaoBCICMSST() {
        return this.percentualReducaoBCICMSST;
    }

    public String getValorBCST() {
        return this.valorBCST;
    }

    public String getPercentualAliquotaImpostoICMSST() {
        return this.percentualAliquotaImpostoICMSST;
    }

    public String getValorICMSST() {
        return this.valorICMSST;
    }

    public String getValorICMSDesoneracao() {
        return this.valorICMSDesoneracao;
    }

    public NFNotaMotivoDesoneracaoICMS getDesoneracao() {
        return this.desoneracao;
    }
}

