/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.nfe310.webservices;

import com.fincatto.documentofiscal.DFLog;
import com.fincatto.documentofiscal.DFModelo;
import com.fincatto.documentofiscal.nfe.NFeConfig;
import com.fincatto.documentofiscal.nfe310.classes.NFAutorizador31;
import com.fincatto.documentofiscal.nfe310.classes.lote.envio.NFLoteEnvio;
import com.fincatto.documentofiscal.nfe310.classes.lote.envio.NFLoteEnvioRetorno;
import com.fincatto.documentofiscal.nfe310.classes.lote.envio.NFLoteEnvioRetornoDados;
import com.fincatto.documentofiscal.nfe310.classes.nota.NFNota;
import com.fincatto.documentofiscal.nfe310.classes.nota.NFNotaInfoSuplementar;
import com.fincatto.documentofiscal.nfe310.utils.NFGeraChave;
import com.fincatto.documentofiscal.nfe310.utils.NFGeraQRCode;
import com.fincatto.documentofiscal.nfe310.webservices.gerado.NfeAutorizacaoStub;
import com.fincatto.documentofiscal.utils.DFAssinaturaDigital;
import com.fincatto.documentofiscal.validadores.DFXMLValidador;
import java.io.StringReader;
import java.util.Iterator;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.commons.lang3.StringUtils;

class WSLoteEnvio
implements DFLog {
    private static final String NFE_ELEMENTO = "NFe";
    private final NFeConfig config;

    WSLoteEnvio(NFeConfig nFeConfig) {
        this.config = nFeConfig;
    }

    NFLoteEnvioRetorno enviaLoteAssinado(String string, DFModelo dFModelo) throws Exception {
        return this.comunicaLote(string, dFModelo);
    }

    NFLoteEnvioRetornoDados enviaLote(NFLoteEnvio nFLoteEnvio) throws Exception {
        NFLoteEnvio nFLoteEnvio2 = this.getLoteAssinado(nFLoteEnvio);
        NFLoteEnvioRetorno nFLoteEnvioRetorno = this.comunicaLote(nFLoteEnvio2.toString(), nFLoteEnvio2.getNotas().get(0).getInfo().getIdentificacao().getModelo());
        return new NFLoteEnvioRetornoDados(nFLoteEnvioRetorno, nFLoteEnvio2);
    }

    NFLoteEnvio getLoteAssinado(NFLoteEnvio nFLoteEnvio) throws Exception {
        for (NFNota dFBase2 : nFLoteEnvio.getNotas()) {
            NFGeraChave n = new NFGeraChave(dFBase2);
            dFBase2.getInfo().getIdentificacao().setCodigoRandomico((String)StringUtils.defaultIfBlank((CharSequence)dFBase2.getInfo().getIdentificacao().getCodigoRandomico(), (CharSequence)n.geraCodigoRandomico()));
            dFBase2.getInfo().getIdentificacao().setDigitoVerificador(n.getDV());
            dFBase2.getInfo().setIdentificador(n.getChaveAcesso());
        }
        String string = new DFAssinaturaDigital(this.config).assinarDocumento(nFLoteEnvio.toString());
        NFLoteEnvio nFLoteEnvio2 = (NFLoteEnvio)this.config.getPersister().read(NFLoteEnvio.class, string);
        int n = 0;
        int n2 = 0;
        block5: for (NFNota nFNota : nFLoteEnvio2.getNotas()) {
            switch (nFNota.getInfo().getIdentificacao().getModelo()) {
                case NFE: {
                    ++n;
                    continue block5;
                }
                case NFCE: {
                    NFGeraQRCode nFGeraQRCode = new NFGeraQRCode(nFNota, this.config);
                    nFNota.setInfoSuplementar(new NFNotaInfoSuplementar());
                    nFNota.getInfoSuplementar().setQrCode(nFGeraQRCode.getQRCode());
                    ++n2;
                    continue block5;
                }
            }
            throw new IllegalArgumentException(String.format("Modelo de nota desconhecida: %s", new Object[]{nFNota.getInfo().getIdentificacao().getModelo()}));
        }
        if (n > 0 && n2 > 0) {
            throw new IllegalArgumentException("Lote contendo notas de modelos diferentes!");
        }
        return nFLoteEnvio2;
    }

    private NFLoteEnvioRetorno comunicaLote(String string, DFModelo dFModelo) throws Exception {
        String string2;
        DFXMLValidador.validaLote(string);
        OMElement oMElement = this.nfeToOMElement(string);
        NfeAutorizacaoStub.NfeDadosMsg nfeDadosMsg = new NfeAutorizacaoStub.NfeDadosMsg();
        nfeDadosMsg.setExtraElement(oMElement);
        NfeAutorizacaoStub.NfeCabecMsgE nfeCabecMsgE = this.getCabecalhoSOAP();
        this.getLogger().debug(oMElement.toString());
        NFAutorizador31 nFAutorizador31 = NFAutorizador31.valueOfTipoEmissao(this.config.getTipoEmissao(), this.config.getCUF());
        String string3 = string2 = DFModelo.NFE.equals((Object)dFModelo) ? nFAutorizador31.getNfeAutorizacao(this.config.getAmbiente()) : nFAutorizador31.getNfceAutorizacao(this.config.getAmbiente());
        if (string2 == null) {
            throw new IllegalArgumentException("Nao foi possivel encontrar URL para Autorizacao " + dFModelo.name() + ", autorizador " + nFAutorizador31.name());
        }
        NfeAutorizacaoStub.NfeAutorizacaoLoteResult nfeAutorizacaoLoteResult = new NfeAutorizacaoStub(string2, this.config).nfeAutorizacaoLote(nfeDadosMsg, nfeCabecMsgE);
        NFLoteEnvioRetorno nFLoteEnvioRetorno = (NFLoteEnvioRetorno)this.config.getPersister().read(NFLoteEnvioRetorno.class, nfeAutorizacaoLoteResult.getExtraElement().toString());
        this.getLogger().debug(nFLoteEnvioRetorno.toString());
        return nFLoteEnvioRetorno;
    }

    private NfeAutorizacaoStub.NfeCabecMsgE getCabecalhoSOAP() {
        NfeAutorizacaoStub.NfeCabecMsg nfeCabecMsg = new NfeAutorizacaoStub.NfeCabecMsg();
        nfeCabecMsg.setCUF(this.config.getCUF().getCodigoIbge());
        nfeCabecMsg.setVersaoDados(this.config.getVersao());
        NfeAutorizacaoStub.NfeCabecMsgE nfeCabecMsgE = new NfeAutorizacaoStub.NfeCabecMsgE();
        nfeCabecMsgE.setNfeCabecMsg(nfeCabecMsg);
        return nfeCabecMsgE;
    }

    private OMElement nfeToOMElement(String string) throws XMLStreamException {
        XMLInputFactory xMLInputFactory = XMLInputFactory.newInstance();
        xMLInputFactory.setProperty("javax.xml.stream.isCoalescing", false);
        XMLStreamReader xMLStreamReader = xMLInputFactory.createXMLStreamReader(new StringReader(string));
        StAXOMBuilder stAXOMBuilder = new StAXOMBuilder(xMLStreamReader);
        OMElement oMElement = stAXOMBuilder.getDocumentElement();
        Iterator iterator = oMElement.getChildrenWithLocalName(NFE_ELEMENTO);
        while (iterator.hasNext()) {
            OMElement oMElement2 = (OMElement)iterator.next();
            if (oMElement2 == null || !NFE_ELEMENTO.equals(oMElement2.getLocalName())) continue;
            oMElement2.addAttribute("xmlns", "http://www.portalfiscal.inf.br/nfe", null);
        }
        return oMElement;
    }
}

