/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.nfe400.classes.nota;

import com.fincatto.documentofiscal.DFBase;
import com.fincatto.documentofiscal.validadores.DFBigDecimalValidador;
import java.math.BigDecimal;
import org.simpleframework.xml.Element;

public class NFNotaInfoICMSTotal
extends DFBase {
    private static final long serialVersionUID = 1644701343314788528L;
    @Element(name="vBC")
    private String baseCalculoICMS;
    @Element(name="vICMS")
    private String valorTotalICMS;
    @Element(name="vICMSDeson")
    private String valorICMSDesonerado;
    @Element(name="vFCPUFDest", required=false)
    private String valorICMSFundoCombatePobreza;
    @Element(name="vICMSUFDest", required=false)
    private String valorICMSPartilhaDestinatario;
    @Element(name="vICMSUFRemet", required=false)
    private String valorICMSPartilhaRementente;
    @Element(name="vFCP")
    private String valorTotalFundoCombatePobreza;
    @Element(name="vBCST")
    private String baseCalculoICMSST;
    @Element(name="vST")
    private String valorTotalICMSST;
    @Element(name="vFCPST")
    private String valorTotalFundoCombatePobrezaST;
    @Element(name="vFCPSTRet")
    private String valorTotalFundoCombatePobrezaSTRetido;
    @Element(name="qBCMono", required=false)
    private String quantidadeTributadaIcmsMonofasico;
    @Element(name="vICMSMono", required=false)
    private String valorTotalIcmsMonofasico;
    @Element(name="qBCMonoReten", required=false)
    private String quantidadeTributadaMonofasicoSujeitoRetencao;
    @Element(name="vICMSMonoReten", required=false)
    private String valorTotalIcmsSujeitoRetencao;
    @Element(name="qBCMonoRet", required=false)
    private String quantidadeTributadaMonofasicoRetiroAnteriormente;
    @Element(name="vICMSMonoRet", required=false)
    private String valorTotalIcmsMonofasicoRetidoAnteriormente;
    @Element(name="vProd")
    private String valorTotalDosProdutosServicos;
    @Element(name="vFrete")
    private String valorTotalFrete;
    @Element(name="vSeg")
    private String valorTotalSeguro;
    @Element(name="vDesc")
    private String valorTotalDesconto;
    @Element(name="vII")
    private String valorTotalII;
    @Element(name="vIPI")
    private String valorTotalIPI;
    @Element(name="vIPIDevol")
    private String valorTotalIPIDevolvido;
    @Element(name="vPIS")
    private String valorPIS;
    @Element(name="vCOFINS")
    private String valorCOFINS;
    @Element(name="vOutro")
    private String outrasDespesasAcessorias;
    @Element(name="vNF")
    private String valorTotalNFe;
    @Element(name="vTotTrib", required=false)
    private String valorTotalTributos;

    public void setBaseCalculoICMS(BigDecimal bigDecimal) {
        this.baseCalculoICMS = DFBigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "Base de Calculo ICMS Total");
    }

    public void setValorTotalICMS(BigDecimal bigDecimal) {
        this.valorTotalICMS = DFBigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "Valalor Total ICMS");
    }

    public void setBaseCalculoICMSST(BigDecimal bigDecimal) {
        this.baseCalculoICMSST = DFBigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "Base de Calculo ICMS ST Total");
    }

    public void setValorTotalICMSST(BigDecimal bigDecimal) {
        this.valorTotalICMSST = DFBigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "Valor Total ICMS ST");
    }

    public void setValorTotalDosProdutosServicos(BigDecimal bigDecimal) {
        this.valorTotalDosProdutosServicos = DFBigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "Valor Total Produtos e Servicos");
    }

    public void setValorTotalFrete(BigDecimal bigDecimal) {
        this.valorTotalFrete = DFBigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "Valor Total Frete");
    }

    public void setValorTotalSeguro(BigDecimal bigDecimal) {
        this.valorTotalSeguro = DFBigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "Valor Total Seguro");
    }

    public void setValorTotalDesconto(BigDecimal bigDecimal) {
        this.valorTotalDesconto = DFBigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "Valor Total Desconto");
    }

    public void setValorTotalII(BigDecimal bigDecimal) {
        this.valorTotalII = DFBigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "Valor Total II");
    }

    public void setValorTotalIPI(BigDecimal bigDecimal) {
        this.valorTotalIPI = DFBigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "Valor Total IPI");
    }

    public void setValorPIS(BigDecimal bigDecimal) {
        this.valorPIS = DFBigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "Valor Total PIS");
    }

    public void setValorCOFINS(BigDecimal bigDecimal) {
        this.valorCOFINS = DFBigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "Valor Total COFINS");
    }

    public void setOutrasDespesasAcessorias(BigDecimal bigDecimal) {
        this.outrasDespesasAcessorias = DFBigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "Outras Despesas Acessorias");
    }

    public void setValorTotalNFe(BigDecimal bigDecimal) {
        this.valorTotalNFe = DFBigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "Valor Total NFe");
    }

    public void setValorTotalTributos(BigDecimal bigDecimal) {
        this.valorTotalTributos = DFBigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "Valor Total Tributos");
    }

    public void setValorICMSDesonerado(BigDecimal bigDecimal) {
        this.valorICMSDesonerado = DFBigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "Valor ICMS Desonerado");
    }

    public String getBaseCalculoICMS() {
        return this.baseCalculoICMS;
    }

    public String getValorTotalICMS() {
        return this.valorTotalICMS;
    }

    public String getValorICMSDesonerado() {
        return this.valorICMSDesonerado;
    }

    public String getBaseCalculoICMSST() {
        return this.baseCalculoICMSST;
    }

    public String getValorTotalICMSST() {
        return this.valorTotalICMSST;
    }

    public String getValorTotalDosProdutosServicos() {
        return this.valorTotalDosProdutosServicos;
    }

    public String getValorTotalFrete() {
        return this.valorTotalFrete;
    }

    public String getValorTotalSeguro() {
        return this.valorTotalSeguro;
    }

    public String getValorTotalDesconto() {
        return this.valorTotalDesconto;
    }

    public String getValorTotalII() {
        return this.valorTotalII;
    }

    public String getValorTotalIPI() {
        return this.valorTotalIPI;
    }

    public String getValorPIS() {
        return this.valorPIS;
    }

    public String getValorCOFINS() {
        return this.valorCOFINS;
    }

    public String getOutrasDespesasAcessorias() {
        return this.outrasDespesasAcessorias;
    }

    public String getValorTotalNFe() {
        return this.valorTotalNFe;
    }

    public String getValorTotalTributos() {
        return this.valorTotalTributos;
    }

    public String getValorICMSFundoCombatePobreza() {
        return this.valorICMSFundoCombatePobreza;
    }

    public void setValorICMSFundoCombatePobreza(BigDecimal bigDecimal) {
        this.valorICMSFundoCombatePobreza = DFBigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "Valor ICMS Fundo Combate a Pobreza");
    }

    public String getValorICMSPartilhaDestinatario() {
        return this.valorICMSPartilhaDestinatario;
    }

    public void setValorICMSPartilhaDestinatario(BigDecimal bigDecimal) {
        this.valorICMSPartilhaDestinatario = DFBigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "Valor ICMS Partilha Destinatario");
    }

    public String getValorICMSPartilhaRementente() {
        return this.valorICMSPartilhaRementente;
    }

    public void setValorICMSPartilhaRementente(BigDecimal bigDecimal) {
        this.valorICMSPartilhaRementente = DFBigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "Valor ICMS Partilha Remetente");
    }

    public void setValorTotalFundoCombatePobreza(BigDecimal bigDecimal) {
        this.valorTotalFundoCombatePobreza = DFBigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "Valor total fundo combate a pobreza");
    }

    public String getValorTotalFundoCombatePobreza() {
        return this.valorTotalFundoCombatePobreza;
    }

    public void setValorTotalFundoCombatePobrezaST(BigDecimal bigDecimal) {
        this.valorTotalFundoCombatePobrezaST = DFBigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "Valor total fundo combate a pobreza ST");
    }

    public String getValorTotalFundoCombatePobrezaST() {
        return this.valorTotalFundoCombatePobrezaST;
    }

    public void setValorTotalFundoCombatePobrezaSTRetido(BigDecimal bigDecimal) {
        this.valorTotalFundoCombatePobrezaSTRetido = DFBigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "Valor total fundo combate a pobreza ST retido");
    }

    public String getValorTotalFundoCombatePobrezaSTRetido() {
        return this.valorTotalFundoCombatePobrezaSTRetido;
    }

    public void setValorTotalIPIDevolvido(BigDecimal bigDecimal) {
        this.valorTotalIPIDevolvido = DFBigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "Valor total IPI devolvido");
    }

    public String getValorTotalIPIDevolvido() {
        return this.valorTotalIPIDevolvido;
    }

    public String getQuantidadeTributadaIcmsMonofasico() {
        return this.quantidadeTributadaIcmsMonofasico;
    }

    public void setQuantidadeTributadaIcmsMonofasico(BigDecimal bigDecimal) {
        this.quantidadeTributadaIcmsMonofasico = DFBigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "Valor total da quantidade tributada do ICMS monof\u00e1sico pr\u00f3prio");
    }

    public String getValorTotalIcmsMonofasico() {
        return this.valorTotalIcmsMonofasico;
    }

    public void setValorTotalIcmsMonofasico(BigDecimal bigDecimal) {
        this.valorTotalIcmsMonofasico = DFBigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "Valor total do ICMS monof\u00e1sico pr\u00f3prio");
    }

    public String getQuantidadeTributadaMonofasicoSujeitoRetencao() {
        return this.quantidadeTributadaMonofasicoSujeitoRetencao;
    }

    public void setQuantidadeTributadaMonofasicoSujeitoRetencao(BigDecimal bigDecimal) {
        this.quantidadeTributadaMonofasicoSujeitoRetencao = DFBigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "Valor total da quantidade tributada do ICMS monof\u00e1sico sujeito a reten\u00e7\u00e3o");
    }

    public String getValorTotalIcmsSujeitoRetencao() {
        return this.valorTotalIcmsSujeitoRetencao;
    }

    public void setValorTotalIcmsSujeitoRetencao(BigDecimal bigDecimal) {
        this.valorTotalIcmsSujeitoRetencao = DFBigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "Valor total do ICMS monof\u00e1sico sujeito a reten\u00e7\u00e3o");
    }

    public String getQuantidadeTributadaMonofasicoRetiroAnteriormente() {
        return this.quantidadeTributadaMonofasicoRetiroAnteriormente;
    }

    public void setQuantidadeTributadaMonofasicoRetiroAnteriormente(BigDecimal bigDecimal) {
        this.quantidadeTributadaMonofasicoRetiroAnteriormente = DFBigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "Valor total da quantidade tributada do ICMS monof\u00e1sico retido anteriormente");
    }

    public String getValorTotalIcmsMonofasicoRetidoAnteriormente() {
        return this.valorTotalIcmsMonofasicoRetidoAnteriormente;
    }

    public void setValorTotalIcmsMonofasicoRetidoAnteriormente(BigDecimal bigDecimal) {
        this.valorTotalIcmsMonofasicoRetidoAnteriormente = DFBigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "Valor total do ICMS monof\u00e1sico retido anteriormente");
    }
}

