/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.nfe400.classes.nota;

import com.fincatto.documentofiscal.DFBase;
import com.fincatto.documentofiscal.nfe400.classes.NFProdutoCompoeValorNota;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFIndicadorEscalaRelevante;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoItemDetalheExportacao;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoItemProdutoArmamento;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoItemProdutoCombustivel;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoItemProdutoDeclaracaoImportacao;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoItemProdutoGrupoCreditoPresumido;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoItemProdutoInfoDetalhadaEmbalagemProdutoNFF;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoItemProdutoInfoDetalhadaProdutoNFF;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoItemProdutoMedicamento;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoItemProdutoRastreabilidade;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoItemProdutoVeiculo;
import com.fincatto.documentofiscal.nfe400.converters.NFStringNullToEmptyConverter;
import com.fincatto.documentofiscal.validadores.DFBigDecimalValidador;
import com.fincatto.documentofiscal.validadores.DFIntegerValidador;
import com.fincatto.documentofiscal.validadores.DFListValidador;
import com.fincatto.documentofiscal.validadores.DFStringValidador;
import java.math.BigDecimal;
import java.util.List;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.convert.Convert;

public class NFNotaInfoItemProduto
extends DFBase {
    private static final long serialVersionUID = -2271625077897052364L;
    @Element(name="cProd")
    private String codigo;
    @Element(name="cEAN", required=false)
    @Convert(value=NFStringNullToEmptyConverter.class)
    private String codigoDeBarrasGtin;
    @Element(name="cBarra", required=false)
    private String codigoDeBarrasDiferenteGtin;
    @Element(name="xProd")
    private String descricao;
    @Element(name="NCM")
    private String ncm;
    @ElementList(entry="NVE", inline=true, required=false)
    private List<String> nomeclaturaValorAduaneiroEstatistica;
    @Element(name="CEST", required=false)
    private String codigoEspecificadorSituacaoTributaria;
    @Element(name="indEscala", required=false)
    private NFIndicadorEscalaRelevante indicadorEscalaRelevante;
    @Element(name="CNPJFab", required=false)
    private String cnpjFabricanteMercadoria;
    @Element(name="cBenef", required=false)
    private String codigoBeneficioFiscalUF;
    @Element(name="gCred", required=false)
    private NFNotaInfoItemProdutoGrupoCreditoPresumido grupoCreditoPresumido;
    @Element(name="EXTIPI", required=false)
    private String extipi;
    @Element(name="CFOP")
    private String cfop;
    @Element(name="uCom")
    private String unidadeComercial;
    @Element(name="qCom")
    private String quantidadeComercial;
    @Element(name="vUnCom")
    private String valorUnitario;
    @Element(name="vProd")
    private String valorTotalBruto;
    @Element(name="cEANTrib", required=false)
    @Convert(value=NFStringNullToEmptyConverter.class)
    private String codigoDeBarrasGtinTributavel;
    @Element(name="cBarraTrib", required=false)
    private String codigoDeBarrasDiferenteGtinTributavel;
    @Element(name="uTrib")
    private String unidadeTributavel;
    @Element(name="qTrib")
    private String quantidadeTributavel;
    @Element(name="vUnTrib")
    private String valorUnitarioTributavel;
    @Element(name="vFrete", required=false)
    private String valorFrete;
    @Element(name="vSeg", required=false)
    private String valorSeguro;
    @Element(name="vDesc", required=false)
    private String valorDesconto;
    @Element(name="vOutro", required=false)
    private String valorOutrasDespesasAcessorias;
    @Element(name="indTot")
    private NFProdutoCompoeValorNota compoeValorNota;
    @Element(name="indBemMovelUsado", required=false)
    private String indicadorBemMovelUsado;
    @ElementList(entry="DI", inline=true, required=false)
    private List<NFNotaInfoItemProdutoDeclaracaoImportacao> declaracoesImportacao;
    @ElementList(entry="detExport", inline=true, required=false)
    private List<NFNotaInfoItemDetalheExportacao> detalhesExportacao;
    @Element(name="xPed", required=false)
    private String numeroPedidoCliente;
    @Element(name="nItemPed", required=false)
    private Integer numeroPedidoItemCliente;
    @Element(name="nFCI", required=false)
    private String numeroControleFCI;
    @ElementList(entry="rastro", inline=true, required=false)
    private List<NFNotaInfoItemProdutoRastreabilidade> rastros;
    @Element(name="infProdNFF", required=false)
    private NFNotaInfoItemProdutoInfoDetalhadaProdutoNFF informacaoDetalhadaProdutoNFF;
    @Element(name="infProdEmb", required=false)
    private NFNotaInfoItemProdutoInfoDetalhadaEmbalagemProdutoNFF informacaoDetalhadaEmbalagemProdutoNFF;
    @Element(name="veicProd", required=false)
    private NFNotaInfoItemProdutoVeiculo veiculo;
    @Element(name="med", required=false)
    private NFNotaInfoItemProdutoMedicamento medicamento;
    @ElementList(entry="arma", inline=true, required=false)
    private List<NFNotaInfoItemProdutoArmamento> armamentos;
    @Element(name="comb", required=false)
    private NFNotaInfoItemProdutoCombustivel combustivel;
    @Element(name="nRECOPI", required=false)
    private String numeroRECOPI;

    public void setCodigo(String string) {
        DFStringValidador.tamanho60(string, "Codigo Produto");
        this.codigo = string;
    }

    @Deprecated
    public void setCodigoDeBarras(String string) {
        this.setCodigoDeBarrasGtin(string);
    }

    public void setCodigoDeBarrasGtin(String string) {
        DFStringValidador.codigoDeBarras(string);
        this.codigoDeBarrasGtin = string;
    }

    public void setCodigoDeBarrasDiferenteGtin(String string) {
        this.codigoDeBarrasDiferenteGtin = string;
    }

    public void setDescricao(String string) {
        DFStringValidador.tamanho120(string, "Descricao Produto");
        this.descricao = string;
    }

    public void setNcm(String string) {
        DFStringValidador.ncm(string);
        this.ncm = string;
    }

    public void setExtipi(String string) {
        DFStringValidador.tamanho2ou3N(string, "EX TIPI Produto");
        this.extipi = string;
    }

    public void setCfop(String string) {
        DFStringValidador.exatamente4N(string, "CFOP Produto");
        this.cfop = string;
    }

    public void setUnidadeComercial(String string) {
        DFStringValidador.tamanho6(string, "Unidade Comercial Produto");
        this.unidadeComercial = string;
    }

    public void setQuantidadeComercial(BigDecimal bigDecimal) {
        this.quantidadeComercial = DFBigDecimalValidador.tamanho15comAte4CasasDecimais(bigDecimal, "Qtde Comercial Produto");
    }

    public void setValorUnitario(BigDecimal bigDecimal) {
        this.valorUnitario = DFBigDecimalValidador.tamanho21ComAte10CasasDecimais(bigDecimal, "Valor Unitario Produto");
    }

    public void setValorTotalBruto(BigDecimal bigDecimal) {
        this.valorTotalBruto = DFBigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "Valor Total Bruto Produto");
    }

    @Deprecated
    public void setCodigoDeBarrasTributavel(String string) {
        this.setCodigoDeBarrasGtinTributavel(string);
    }

    public void setCodigoDeBarrasGtinTributavel(String string) {
        DFStringValidador.codigoDeBarras(string);
        this.codigoDeBarrasGtinTributavel = string;
    }

    public void setCodigoDeBarrasDiferenteGtinTributavel(String string) {
        this.codigoDeBarrasDiferenteGtinTributavel = string;
    }

    public void setUnidadeTributavel(String string) {
        DFStringValidador.tamanho6(string, "Unidade Tributavel Produto");
        this.unidadeTributavel = string;
    }

    public void setQuantidadeTributavel(BigDecimal bigDecimal) {
        this.quantidadeTributavel = DFBigDecimalValidador.tamanho15comAte4CasasDecimais(bigDecimal, "Qtde Tributavel Produto");
    }

    public void setValorUnitarioTributavel(BigDecimal bigDecimal) {
        this.valorUnitarioTributavel = DFBigDecimalValidador.tamanho21ComAte10CasasDecimais(bigDecimal, "Valor Unitario Tributavel Produto");
    }

    public void setValorFrete(BigDecimal bigDecimal) {
        this.valorFrete = DFBigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "Valor Frete Produto");
    }

    public void setValorSeguro(BigDecimal bigDecimal) {
        this.valorSeguro = DFBigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "Valor Seguro Produto");
    }

    public void setValorDesconto(BigDecimal bigDecimal) {
        this.valorDesconto = DFBigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "Valor Desconto Produto");
    }

    public void setValorOutrasDespesasAcessorias(BigDecimal bigDecimal) {
        this.valorOutrasDespesasAcessorias = DFBigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "Valor Outras Despesas Acessorias Produto");
    }

    public void setCompoeValorNota(NFProdutoCompoeValorNota nFProdutoCompoeValorNota) {
        this.compoeValorNota = nFProdutoCompoeValorNota;
    }

    public void setIndicadorBemMovelUsado(String string) {
        this.indicadorBemMovelUsado = string;
    }

    public void setDeclaracoesImportacao(List<NFNotaInfoItemProdutoDeclaracaoImportacao> list) {
        this.declaracoesImportacao = list;
    }

    public void setNumeroPedidoCliente(String string) {
        DFStringValidador.tamanho15(string, "Numero Pedido Cliente Produto");
        this.numeroPedidoCliente = string;
    }

    public void setNumeroPedidoItemCliente(Integer n) {
        DFIntegerValidador.tamanho6(n, "Numero Pedido Item Cliente Produto");
        this.numeroPedidoItemCliente = n;
    }

    public void setNumeroControleFCI(String string) {
        DFStringValidador.fci(string);
        this.numeroControleFCI = string;
    }

    public void setVeiculo(NFNotaInfoItemProdutoVeiculo nFNotaInfoItemProdutoVeiculo) {
        if (this.medicamento != null || this.armamentos != null || this.combustivel != null || this.numeroRECOPI != null) {
            throw new IllegalStateException("veiculos, medicamentos, armamentos e combustivel sao mutuamente exclusivos");
        }
        this.veiculo = nFNotaInfoItemProdutoVeiculo;
    }

    public void setMedicamento(NFNotaInfoItemProdutoMedicamento nFNotaInfoItemProdutoMedicamento) {
        if (this.veiculo != null || this.armamentos != null || this.combustivel != null || this.numeroRECOPI != null) {
            throw new IllegalStateException("veiculos, medicamentos, armamentos, RECOPI e combustivel sao mutuamente exclusivos");
        }
        this.medicamento = nFNotaInfoItemProdutoMedicamento;
    }

    public void setArmamentos(List<NFNotaInfoItemProdutoArmamento> list) {
        if (this.medicamento != null || this.veiculo != null || this.combustivel != null || this.numeroRECOPI != null) {
            throw new IllegalStateException("veiculos, medicamentos, armamentos, RECOPI e combustivel sao mutuamente exclusivos");
        }
        DFListValidador.tamanho500(list, "Armamentos Produto");
        this.armamentos = list;
    }

    public void setCombustivel(NFNotaInfoItemProdutoCombustivel nFNotaInfoItemProdutoCombustivel) {
        if (this.medicamento != null || this.armamentos != null || this.veiculo != null || this.numeroRECOPI != null) {
            throw new IllegalStateException("veiculos, medicamentos, armamentos, RECOPI e combustivel sao mutuamente exclusivos");
        }
        this.combustivel = nFNotaInfoItemProdutoCombustivel;
    }

    public void setNomeclaturaValorAduaneiroEstatistica(List<String> list) {
        for (String string : list) {
            DFStringValidador.nve(string);
        }
        this.nomeclaturaValorAduaneiroEstatistica = list;
    }

    public void setCodigoEspecificadorSituacaoTributaria(String string) {
        DFStringValidador.exatamente7N(string, "CEST Produto");
        this.codigoEspecificadorSituacaoTributaria = string;
    }

    public void setDetalhesExportacao(List<NFNotaInfoItemDetalheExportacao> list) {
        DFListValidador.tamanho500(list, "Detalhes Exportacao Produto");
        this.detalhesExportacao = list;
    }

    public void setNumeroRECOPI(String string) {
        if (this.medicamento != null || this.armamentos != null || this.veiculo != null || this.combustivel != null) {
            throw new IllegalStateException("veiculos, medicamentos, armamentos, RECOPI e combustivel sao mutuamente exclusivos");
        }
        DFStringValidador.exatamente20N(string, "Numero RECOPI Produto");
        this.numeroRECOPI = string;
    }

    public void setRastros(List<NFNotaInfoItemProdutoRastreabilidade> list) {
        DFListValidador.tamanho500(list, "Rastreios do produto");
        this.rastros = list;
    }

    public void setIndicadorEscalaRelevante(NFIndicadorEscalaRelevante nFIndicadorEscalaRelevante) {
        this.indicadorEscalaRelevante = nFIndicadorEscalaRelevante;
    }

    public void setCnpjFabricanteMercadoria(String string) {
        this.cnpjFabricanteMercadoria = string;
    }

    public void setCodigoBeneficioFiscalUF(String string) {
        this.codigoBeneficioFiscalUF = DFStringValidador.validador(string, "Codigo Beneficio Fiscal da UF", 10, false, false);
    }

    public void setGrupoCreditoPresumido(NFNotaInfoItemProdutoGrupoCreditoPresumido nFNotaInfoItemProdutoGrupoCreditoPresumido) {
        this.grupoCreditoPresumido = nFNotaInfoItemProdutoGrupoCreditoPresumido;
    }

    public String getCodigo() {
        return this.codigo;
    }

    public String getCodigoDeBarrasGtin() {
        return this.codigoDeBarrasGtin == null ? "SEM GTIN" : this.codigoDeBarrasGtin;
    }

    @Deprecated
    public String getCodigoDeBarras() {
        return this.getCodigoDeBarrasGtin();
    }

    public String getCodigoDeBarrasDiferenteGtin() {
        return this.codigoDeBarrasDiferenteGtin;
    }

    public String getDescricao() {
        return this.descricao;
    }

    public String getNcm() {
        return this.ncm;
    }

    public List<String> getNomeclaturaValorAduaneiroEstatistica() {
        return this.nomeclaturaValorAduaneiroEstatistica;
    }

    public String getCodigoEspecificadorSituacaoTributaria() {
        return this.codigoEspecificadorSituacaoTributaria;
    }

    public String getExtipi() {
        return this.extipi;
    }

    public String getCfop() {
        return this.cfop;
    }

    public String getUnidadeComercial() {
        return this.unidadeComercial;
    }

    public String getQuantidadeComercial() {
        return this.quantidadeComercial;
    }

    public String getValorUnitario() {
        return this.valorUnitario;
    }

    public String getValorTotalBruto() {
        return this.valorTotalBruto;
    }

    @Deprecated
    public String getCodigoDeBarrasTributavel() {
        return this.getCodigoDeBarrasGtinTributavel();
    }

    public String getCodigoDeBarrasGtinTributavel() {
        return this.codigoDeBarrasGtinTributavel == null ? "SEM GTIN" : this.codigoDeBarrasGtinTributavel;
    }

    public String getCodigoDeBarrasDiferenteGtinTributavel() {
        return this.codigoDeBarrasDiferenteGtinTributavel;
    }

    public String getUnidadeTributavel() {
        return this.unidadeTributavel;
    }

    public String getQuantidadeTributavel() {
        return this.quantidadeTributavel;
    }

    public String getValorUnitarioTributavel() {
        return this.valorUnitarioTributavel;
    }

    public String getValorFrete() {
        return this.valorFrete;
    }

    public String getValorSeguro() {
        return this.valorSeguro;
    }

    public String getValorDesconto() {
        return this.valorDesconto;
    }

    public String getValorOutrasDespesasAcessorias() {
        return this.valorOutrasDespesasAcessorias;
    }

    public NFProdutoCompoeValorNota getCompoeValorNota() {
        return this.compoeValorNota;
    }

    public String getIndicadorBemMovelUsado() {
        return this.indicadorBemMovelUsado;
    }

    public List<NFNotaInfoItemProdutoDeclaracaoImportacao> getDeclaracoesImportacao() {
        return this.declaracoesImportacao;
    }

    public List<NFNotaInfoItemDetalheExportacao> getDetalhesExportacao() {
        return this.detalhesExportacao;
    }

    public String getNumeroPedidoCliente() {
        return this.numeroPedidoCliente;
    }

    public Integer getNumeroPedidoItemCliente() {
        return this.numeroPedidoItemCliente;
    }

    public String getNumeroControleFCI() {
        return this.numeroControleFCI;
    }

    public NFNotaInfoItemProdutoVeiculo getVeiculo() {
        return this.veiculo;
    }

    public NFNotaInfoItemProdutoMedicamento getMedicamento() {
        return this.medicamento;
    }

    public List<NFNotaInfoItemProdutoArmamento> getArmamentos() {
        return this.armamentos;
    }

    public NFNotaInfoItemProdutoCombustivel getCombustivel() {
        return this.combustivel;
    }

    public String getNumeroRECOPI() {
        return this.numeroRECOPI;
    }

    public String getCnpjFabricanteMercadoria() {
        return this.cnpjFabricanteMercadoria;
    }

    public String getCodigoBeneficioFiscalUF() {
        return this.codigoBeneficioFiscalUF;
    }

    public NFIndicadorEscalaRelevante getIndicadorEscalaRelevante() {
        return this.indicadorEscalaRelevante;
    }

    public List<NFNotaInfoItemProdutoRastreabilidade> getRastros() {
        return this.rastros;
    }

    public NFNotaInfoItemProdutoGrupoCreditoPresumido getGrupoCreditoPresumido() {
        return this.grupoCreditoPresumido;
    }
}

