/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.nfe400.classes.nota;

import com.fincatto.documentofiscal.DFBase;
import com.fincatto.documentofiscal.DFUnidadeFederativa;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoItemProdutoCombustivelCIDE;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoItemProdutoCombustivelEncerrante;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoItemProdutoCombustivelOrigem;
import com.fincatto.documentofiscal.validadores.DFBigDecimalValidador;
import com.fincatto.documentofiscal.validadores.DFListValidador;
import com.fincatto.documentofiscal.validadores.DFStringValidador;
import java.math.BigDecimal;
import java.util.List;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementList;

public class NFNotaInfoItemProdutoCombustivel
extends DFBase {
    private static final long serialVersionUID = -2899516480924530882L;
    @Element(name="cProdANP")
    private String codigoProdutoANP = null;
    @Element(name="descANP")
    private String descricaoProdutoANP;
    @Element(name="pGLP", required=false)
    private String percentualGLPDerivadoPetroleo;
    @Element(name="pGNn", required=false)
    private String percentualGasNaturalNacional;
    @Element(name="pGNi", required=false)
    private String percentualGasNaturalImportado;
    @Element(name="vPart", required=false)
    private String valorPartida;
    @Element(name="CODIF", required=false)
    private String codigoAutorizacaoCOFIF = null;
    @Element(name="qTemp", required=false)
    private String quantidade = null;
    @Element(name="UFCons")
    private String uf = null;
    @Element(name="CIDE", required=false)
    private NFNotaInfoItemProdutoCombustivelCIDE cide = null;
    @Element(name="encerrante", required=false)
    private NFNotaInfoItemProdutoCombustivelEncerrante encerrante = null;
    @Element(name="pBio", required=false)
    private String percentualMisturaBiodiesel;
    @ElementList(entry="origComb", required=false, inline=true)
    private List<NFNotaInfoItemProdutoCombustivelOrigem> origemCombustivel;

    public void setCodigoProdutoANP(String string) {
        DFStringValidador.exatamente9(string, "Codigo Produto ANP Combustivel");
        this.codigoProdutoANP = string;
    }

    public void setDescricaoProdutoANP(String string) {
        DFStringValidador.tamanho2a95(string, "Descricao Produto ANP Combustivel");
        this.descricaoProdutoANP = string;
    }

    public void setPercentualGLPDerivadoPetroleo(BigDecimal bigDecimal) {
        this.percentualGLPDerivadoPetroleo = DFBigDecimalValidador.tamanho7ComAte4CasasDecimais(bigDecimal, "Percentual GLP derivado petr\u00f3leo");
    }

    public void setPercentualGasNaturalImportado(BigDecimal bigDecimal) {
        this.percentualGasNaturalImportado = DFBigDecimalValidador.tamanho7ComAte4CasasDecimais(bigDecimal, "Percentual gas natural importado");
    }

    public void setPercentualGasNaturalNacional(BigDecimal bigDecimal) {
        this.percentualGasNaturalNacional = DFBigDecimalValidador.tamanho7ComAte4CasasDecimais(bigDecimal, "Percentual gas natural nacional");
    }

    public void setValorPartida(BigDecimal bigDecimal) {
        this.valorPartida = DFBigDecimalValidador.tamanho13Com2CasasDecimais(bigDecimal, "Valor de partida");
    }

    public void setCodigoAutorizacaoCODIF(String string) {
        DFStringValidador.tamanho21(string, "Codigo Autorizacao CODIF Combustivel");
        this.codigoAutorizacaoCOFIF = string;
    }

    public void setQuantidade(BigDecimal bigDecimal) {
        this.quantidade = DFBigDecimalValidador.tamanho16Com4CasasDecimais(bigDecimal, "Quantidade Combustivel");
    }

    public void setUf(DFUnidadeFederativa dFUnidadeFederativa) {
        this.uf = dFUnidadeFederativa.getCodigo();
    }

    public void setCide(NFNotaInfoItemProdutoCombustivelCIDE nFNotaInfoItemProdutoCombustivelCIDE) {
        this.cide = nFNotaInfoItemProdutoCombustivelCIDE;
    }

    public void setEncerrante(NFNotaInfoItemProdutoCombustivelEncerrante nFNotaInfoItemProdutoCombustivelEncerrante) {
        this.encerrante = nFNotaInfoItemProdutoCombustivelEncerrante;
    }

    public void setOrigemCombustivel(List<NFNotaInfoItemProdutoCombustivelOrigem> list) {
        this.origemCombustivel = DFListValidador.validaListaNaoObrigatoria(list, 30, "Origem do Combust\u00edvel");
    }

    public void setPercentualMisturaBiodiesel(BigDecimal bigDecimal) {
        this.percentualMisturaBiodiesel = DFBigDecimalValidador.tamanho7ComAte4CasasDecimais(bigDecimal, "Percentual do \u00edndice de mistura do Biodiesel (B100) no \u00d3leo Diesel B institu\u00eddo pelo \u00f3rg\u00e3o regulamentador");
    }

    public String getCodigoProdutoANP() {
        return this.codigoProdutoANP;
    }

    public String getDescricaoProdutoANP() {
        return this.descricaoProdutoANP;
    }

    public String getPercentualGasNaturalImportado() {
        return this.percentualGasNaturalImportado;
    }

    public String getPercentualGasNaturalNacional() {
        return this.percentualGasNaturalNacional;
    }

    public String getPercentualGLPDerivadoPetroleo() {
        return this.percentualGLPDerivadoPetroleo;
    }

    public String getValorPartida() {
        return this.valorPartida;
    }

    public String getCodigoAutorizacaoCOFIF() {
        return this.codigoAutorizacaoCOFIF;
    }

    public String getQuantidade() {
        return this.quantidade;
    }

    public String getUf() {
        return this.uf;
    }

    public NFNotaInfoItemProdutoCombustivelCIDE getCide() {
        return this.cide;
    }

    public NFNotaInfoItemProdutoCombustivelEncerrante getEncerrante() {
        return this.encerrante;
    }

    public String getPercentualMisturaBiodiesel() {
        return this.percentualMisturaBiodiesel;
    }

    public List<NFNotaInfoItemProdutoCombustivelOrigem> getOrigemCombustivel() {
        return this.origemCombustivel;
    }
}

