/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.nfe400.webservices;

import com.fincatto.documentofiscal.DFLog;
import com.fincatto.documentofiscal.DFModelo;
import com.fincatto.documentofiscal.nfe.NFeConfig;
import com.fincatto.documentofiscal.nfe400.NotaFiscalChaveParser;
import com.fincatto.documentofiscal.nfe400.classes.NFAutorizador400;
import com.fincatto.documentofiscal.nfe400.classes.evento.NFEnviaEventoRetorno;
import com.fincatto.documentofiscal.nfe400.classes.evento.NFEventoRetorno;
import com.fincatto.documentofiscal.nfe400.classes.evento.cancelamento.NFEnviaEventoCancelamento;
import com.fincatto.documentofiscal.nfe400.classes.evento.cancelamento.NFEventoCancelamento;
import com.fincatto.documentofiscal.nfe400.classes.evento.cancelamento.NFInfoCancelamento;
import com.fincatto.documentofiscal.nfe400.classes.evento.cancelamento.NFInfoEventoCancelamento;
import com.fincatto.documentofiscal.nfe400.classes.evento.cancelamento.NFProtocoloEventoCancelamento;
import com.fincatto.documentofiscal.nfe400.classes.lote.envio.NFCancelamentoRetornoDados;
import com.fincatto.documentofiscal.nfe400.webservices.gerado.NFeRecepcaoEvento4Stub;
import com.fincatto.documentofiscal.utils.DFAssinaturaDigital;
import com.fincatto.documentofiscal.utils.DFPersister;
import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.AXIOMUtil;

class WSCancelamento
implements DFLog {
    private static final BigDecimal VERSAO_LEIAUTE = new BigDecimal("1.00");
    private static final String DESCRICAO_EVENTO = "Cancelamento";
    private static final String EVENTO_CANCELAMENTO = "110111";
    private static final String DESCRICAO_EVENTO_CANCELAMENTO_POR_SUBSTITUICAO = "Cancelamento por substituicao";
    private static final String EVENTO_CANCELAMENTO_POR_SUBSTITUICAO = "110112";
    private final NFeConfig config;

    WSCancelamento(NFeConfig nFeConfig) {
        this.config = nFeConfig;
    }

    NFEnviaEventoRetorno cancelaNotaAssinada(String string, String string2) throws Exception {
        OMElement oMElement = this.efetuaCancelamento(string2, string);
        return (NFEnviaEventoRetorno)this.config.getPersister().read(NFEnviaEventoRetorno.class, oMElement.toString());
    }

    NFCancelamentoRetornoDados cancelaNota(String string, String string2, String string3) throws Exception {
        String string4 = this.gerarDadosCancelamento(string, string2, string3).toString();
        String string5 = new DFAssinaturaDigital(this.config).assinarDocumento(string4);
        OMElement oMElement = this.efetuaCancelamento(string5, string);
        NFEnviaEventoRetorno nFEnviaEventoRetorno = (NFEnviaEventoRetorno)this.config.getPersister().read(NFEnviaEventoRetorno.class, oMElement.toString());
        NFEnviaEventoCancelamento nFEnviaEventoCancelamento = (NFEnviaEventoCancelamento)((Object)new DFPersister().read(NFEnviaEventoCancelamento.class, string5));
        List<NFEventoRetorno> list = nFEnviaEventoRetorno.getEventoRetorno() == null ? Arrays.asList(new NFEventoRetorno[0]) : nFEnviaEventoRetorno.getEventoRetorno();
        NFProtocoloEventoCancelamento nFProtocoloEventoCancelamento = new NFProtocoloEventoCancelamento();
        nFProtocoloEventoCancelamento.setVersao("1.00");
        nFProtocoloEventoCancelamento.setEvento(nFEnviaEventoCancelamento.getEvento().stream().findFirst().orElse(null));
        nFProtocoloEventoCancelamento.setEventoRetorno(list.stream().findFirst().orElse(null));
        return new NFCancelamentoRetornoDados(nFEnviaEventoRetorno, nFProtocoloEventoCancelamento);
    }

    private OMElement efetuaCancelamento(String string, String string2) throws Exception {
        String string3;
        NFeRecepcaoEvento4Stub.NfeDadosMsg nfeDadosMsg = new NFeRecepcaoEvento4Stub.NfeDadosMsg();
        OMElement oMElement = AXIOMUtil.stringToOM((String)string);
        this.getLogger().debug(oMElement.toString());
        nfeDadosMsg.setExtraElement(oMElement);
        NotaFiscalChaveParser notaFiscalChaveParser = new NotaFiscalChaveParser(string2);
        NFAutorizador400 nFAutorizador400 = NFAutorizador400.valueOfChaveAcesso(string2);
        String string4 = string3 = DFModelo.NFCE.equals((Object)notaFiscalChaveParser.getModelo()) ? nFAutorizador400.getNfceRecepcaoEvento(this.config.getAmbiente()) : nFAutorizador400.getRecepcaoEvento(this.config.getAmbiente());
        if (string3 == null) {
            throw new IllegalArgumentException("Nao foi possivel encontrar URL para RecepcaoEvento " + notaFiscalChaveParser.getModelo().name() + ", autorizador " + nFAutorizador400.name());
        }
        NFeRecepcaoEvento4Stub.NfeResultMsg nfeResultMsg = new NFeRecepcaoEvento4Stub(string3, this.config).nfeRecepcaoEvento(nfeDadosMsg);
        OMElement oMElement2 = nfeResultMsg.getExtraElement();
        this.getLogger().debug(oMElement2.toString());
        return oMElement2;
    }

    private NFEnviaEventoCancelamento gerarDadosCancelamento(String string, String string2, String string3) {
        NotaFiscalChaveParser notaFiscalChaveParser = new NotaFiscalChaveParser(string);
        NFInfoCancelamento nFInfoCancelamento = new NFInfoCancelamento();
        nFInfoCancelamento.setDescricaoEvento(DESCRICAO_EVENTO);
        nFInfoCancelamento.setVersao(VERSAO_LEIAUTE);
        nFInfoCancelamento.setJustificativa(string3);
        nFInfoCancelamento.setProtocoloAutorizacao(string2);
        NFInfoEventoCancelamento nFInfoEventoCancelamento = new NFInfoEventoCancelamento();
        nFInfoEventoCancelamento.setAmbiente(this.config.getAmbiente());
        nFInfoEventoCancelamento.setChave(string);
        if (Integer.parseInt(notaFiscalChaveParser.getSerie()) >= 920 && Integer.parseInt(notaFiscalChaveParser.getSerie()) <= 969 && notaFiscalChaveParser.isEmitentePessoaFisica()) {
            nFInfoEventoCancelamento.setCpf(notaFiscalChaveParser.getCpfEmitente());
        } else {
            nFInfoEventoCancelamento.setCnpj(notaFiscalChaveParser.getCnpjEmitente());
        }
        nFInfoEventoCancelamento.setDataHoraEvento(ZonedDateTime.now(this.config.getTimeZone().toZoneId()));
        nFInfoEventoCancelamento.setId(String.format("ID%s%s0%s", EVENTO_CANCELAMENTO, string, "1"));
        nFInfoEventoCancelamento.setNumeroSequencialEvento(1);
        nFInfoEventoCancelamento.setOrgao(notaFiscalChaveParser.getNFUnidadeFederativa());
        nFInfoEventoCancelamento.setCodigoEvento(EVENTO_CANCELAMENTO);
        nFInfoEventoCancelamento.setVersaoEvento(VERSAO_LEIAUTE);
        nFInfoEventoCancelamento.setCancelamento(nFInfoCancelamento);
        NFEventoCancelamento nFEventoCancelamento = new NFEventoCancelamento();
        nFEventoCancelamento.setInfoEvento(nFInfoEventoCancelamento);
        nFEventoCancelamento.setVersao(VERSAO_LEIAUTE);
        NFEnviaEventoCancelamento nFEnviaEventoCancelamento = new NFEnviaEventoCancelamento();
        nFEnviaEventoCancelamento.setEvento(Collections.singletonList(nFEventoCancelamento));
        nFEnviaEventoCancelamento.setIdLote(Long.toString(ZonedDateTime.now(this.config.getTimeZone().toZoneId()).toInstant().toEpochMilli()));
        nFEnviaEventoCancelamento.setVersao(VERSAO_LEIAUTE);
        return nFEnviaEventoCancelamento;
    }

    NFEnviaEventoRetorno cancelaNotaPorSubstituicao(String string, String string2, String string3, String string4, String string5) throws Exception {
        String string6 = this.gerarDadosCancelamentoPorSubstituicao(string, string2, string3, string4, string5).toString();
        String string7 = new DFAssinaturaDigital(this.config).assinarDocumento(string6);
        OMElement oMElement = this.efetuaCancelamento(string7, string);
        return (NFEnviaEventoRetorno)this.config.getPersister().read(NFEnviaEventoRetorno.class, oMElement.toString());
    }

    private NFEnviaEventoCancelamento gerarDadosCancelamentoPorSubstituicao(String string, String string2, String string3, String string4, String string5) {
        NotaFiscalChaveParser notaFiscalChaveParser = new NotaFiscalChaveParser(string);
        if (DFModelo.NFE.equals((Object)notaFiscalChaveParser.getModelo())) {
            throw new IllegalArgumentException("Evento nao permitido para modelo 55 - NFe!");
        }
        NFInfoCancelamento nFInfoCancelamento = new NFInfoCancelamento();
        nFInfoCancelamento.setDescricaoEvento(DESCRICAO_EVENTO_CANCELAMENTO_POR_SUBSTITUICAO);
        nFInfoCancelamento.setUfAutorizador(notaFiscalChaveParser.getNFUnidadeFederativa());
        nFInfoCancelamento.setTipoAutorizador("1");
        nFInfoCancelamento.setVersaoAplicativo(string4);
        nFInfoCancelamento.setVersao(VERSAO_LEIAUTE);
        nFInfoCancelamento.setJustificativa(string3);
        nFInfoCancelamento.setProtocoloAutorizacao(string2);
        nFInfoCancelamento.setChaveAcessoSubstituta(string5);
        NFInfoEventoCancelamento nFInfoEventoCancelamento = new NFInfoEventoCancelamento();
        nFInfoEventoCancelamento.setAmbiente(this.config.getAmbiente());
        nFInfoEventoCancelamento.setChave(string);
        if (Integer.parseInt(notaFiscalChaveParser.getSerie()) >= 920 && Integer.parseInt(notaFiscalChaveParser.getSerie()) <= 969) {
            nFInfoEventoCancelamento.setCpf(notaFiscalChaveParser.getCpfEmitente());
        } else {
            nFInfoEventoCancelamento.setCnpj(notaFiscalChaveParser.getCnpjEmitente());
        }
        nFInfoEventoCancelamento.setDataHoraEvento(ZonedDateTime.now(this.config.getTimeZone().toZoneId()));
        nFInfoEventoCancelamento.setId(String.format("ID%s%s0%s", EVENTO_CANCELAMENTO_POR_SUBSTITUICAO, string, "1"));
        nFInfoEventoCancelamento.setNumeroSequencialEvento(1);
        nFInfoEventoCancelamento.setOrgao(notaFiscalChaveParser.getNFUnidadeFederativa());
        nFInfoEventoCancelamento.setCodigoEvento(EVENTO_CANCELAMENTO_POR_SUBSTITUICAO);
        nFInfoEventoCancelamento.setVersaoEvento(VERSAO_LEIAUTE);
        nFInfoEventoCancelamento.setCancelamento(nFInfoCancelamento);
        NFEventoCancelamento nFEventoCancelamento = new NFEventoCancelamento();
        nFEventoCancelamento.setInfoEvento(nFInfoEventoCancelamento);
        nFEventoCancelamento.setVersao(VERSAO_LEIAUTE);
        NFEnviaEventoCancelamento nFEnviaEventoCancelamento = new NFEnviaEventoCancelamento();
        nFEnviaEventoCancelamento.setEvento(Collections.singletonList(nFEventoCancelamento));
        nFEnviaEventoCancelamento.setIdLote(Long.toString(ZonedDateTime.now(this.config.getTimeZone().toZoneId()).toInstant().toEpochMilli()));
        nFEnviaEventoCancelamento.setVersao(VERSAO_LEIAUTE);
        return nFEnviaEventoCancelamento;
    }
}

