/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.nfe400.webservices;

import com.fincatto.documentofiscal.DFBase;
import com.fincatto.documentofiscal.DFLog;
import com.fincatto.documentofiscal.DFModelo;
import com.fincatto.documentofiscal.DFUnidadeFederativa;
import com.fincatto.documentofiscal.nfe.NFTipoEmissao;
import com.fincatto.documentofiscal.nfe.NFeConfig;
import com.fincatto.documentofiscal.nfe400.classes.NFAutorizador400;
import com.fincatto.documentofiscal.nfe400.classes.evento.epec.NFDestinatarioEpec;
import com.fincatto.documentofiscal.nfe400.classes.evento.epec.NFEnviaEventoEpec;
import com.fincatto.documentofiscal.nfe400.classes.evento.epec.NFEnviaEventoEpecRetorno;
import com.fincatto.documentofiscal.nfe400.classes.evento.epec.NFEventoEpec;
import com.fincatto.documentofiscal.nfe400.classes.evento.epec.NFInfoEpec;
import com.fincatto.documentofiscal.nfe400.classes.evento.epec.NFInfoEventoEpec;
import com.fincatto.documentofiscal.nfe400.classes.lote.envio.NFLoteEnvio;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNota;
import com.fincatto.documentofiscal.nfe400.utils.NFGeraChave;
import com.fincatto.documentofiscal.nfe400.webservices.gerado.NFeRecepcaoEvento4Stub;
import com.fincatto.documentofiscal.utils.DFAssinaturaDigital;
import com.fincatto.documentofiscal.validadores.DFXMLValidador;
import java.io.StringReader;
import java.math.BigDecimal;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.commons.lang3.StringUtils;

public class WSEpec
implements DFLog {
    private static final BigDecimal VERSAO_LEIAUTE = new BigDecimal("1.00");
    public static final String TIPO_EVENTO_EPEC = "110140";
    public static final String DESCRICAO_EVENTO_EPEC = "EPEC";
    private static final String NFE_ELEMENTO = "NFe";
    private final NFeConfig config;

    public WSEpec(NFeConfig nFeConfig) {
        this.config = nFeConfig;
    }

    NFEnviaEventoEpecRetorno enviaEpecAssinado(String string) throws Exception {
        return this.comunicaEpec(string);
    }

    NFEnviaEventoEpecRetorno enviaEpec(NFLoteEnvio nFLoteEnvio) throws Exception {
        DFBase dFBase;
        NFEnviaEventoEpec nFEnviaEventoEpec = this.criaEnvioEpec(nFLoteEnvio);
        int n = 1;
        for (NFEventoEpec dFBase22 : nFEnviaEventoEpec.getEvento()) {
            dFBase = dFBase22.getNota();
            NFGeraChave nFGeraChave = new NFGeraChave((NFNota)dFBase);
            String string = nFGeraChave.getChaveAcesso();
            dFBase22.getInfoEvento().setIdentificador("ID110140" + string + String.valueOf(n < 10 ? "0" + n : Integer.valueOf(n)));
            dFBase22.getInfoEvento().setNumeroSequencialEvento(n++);
            dFBase22.getInfoEvento().setChave(string);
        }
        String string = new DFAssinaturaDigital(this.config).assinarDocumento(nFEnviaEventoEpec.toString());
        NFEnviaEventoEpec nFEnviaEventoEpec2 = (NFEnviaEventoEpec)this.config.getPersister().read(NFEnviaEventoEpec.class, string);
        dFBase = this.comunicaEpec(nFEnviaEventoEpec2.toString());
        return dFBase;
    }

    private NFEnviaEventoEpec criaEnvioEpec(NFLoteEnvio nFLoteEnvio) {
        NFEnviaEventoEpec nFEnviaEventoEpec = new NFEnviaEventoEpec();
        nFEnviaEventoEpec.setIdLote(StringUtils.isBlank((CharSequence)nFLoteEnvio.getIdLote()) ? String.valueOf(new Date().getTime()) : nFLoteEnvio.getIdLote());
        nFEnviaEventoEpec.setVersao("1.00");
        nFEnviaEventoEpec.setEvento(new ArrayList<NFEventoEpec>());
        int n = 1;
        for (NFNota nFNota : nFLoteEnvio.getNotas()) {
            NFEventoEpec nFEventoEpec = new NFEventoEpec();
            nFEventoEpec.setNota(nFNota);
            nFNota.getInfo().getIdentificacao().setTipoEmissao(NFTipoEmissao.CONTINGENCIA_EPEC);
            nFEventoEpec.setVersao("1.00");
            NFInfoEventoEpec nFInfoEventoEpec = new NFInfoEventoEpec();
            nFInfoEventoEpec.setAmbiente(this.config.getAmbiente());
            if (StringUtils.isNotBlank((CharSequence)nFNota.getInfo().getEmitente().getCnpj())) {
                nFInfoEventoEpec.setCnpj(nFNota.getInfo().getEmitente().getCnpj());
            } else {
                nFInfoEventoEpec.setCpf(nFNota.getInfo().getEmitente().getCpf());
            }
            nFInfoEventoEpec.setCodigoEvento(TIPO_EVENTO_EPEC);
            nFInfoEventoEpec.setNumeroSequencialEvento(n++);
            nFInfoEventoEpec.setOrgao(DFUnidadeFederativa.RFB);
            nFInfoEventoEpec.setVersaoEvento("1.00");
            nFInfoEventoEpec.setDataHoraEvento(ZonedDateTime.now(this.config.getTimeZone().toZoneId()));
            NFInfoEpec nFInfoEpec = new NFInfoEpec();
            nFInfoEpec.setDataHoraEmissao(ZonedDateTime.ofInstant(nFNota.getInfo().getIdentificacao().getDataHoraEmissao().toInstant(), ZoneId.systemDefault()));
            nFInfoEpec.setDescricaoEvento(DESCRICAO_EVENTO_EPEC);
            nFInfoEpec.setInscricaoEstadualEmitente(nFNota.getInfo().getEmitente().getInscricaoEstadual());
            nFInfoEpec.setOrgaoAutor(DFUnidadeFederativa.valueOfCodigo(nFNota.getInfo().getEmitente().getEndereco().getUf()).getCodigoIbge());
            nFInfoEpec.setTipoNota("1");
            nFInfoEpec.setTpAutor("1");
            nFInfoEpec.setVersao(VERSAO_LEIAUTE);
            nFInfoEpec.setVersaoAplicativo("1.0");
            nFInfoEventoEpec.setEpec(nFInfoEpec);
            if (nFNota.getInfo().getDestinatario() != null) {
                NFDestinatarioEpec nFDestinatarioEpec = new NFDestinatarioEpec();
                if (StringUtils.isNotBlank((CharSequence)nFNota.getInfo().getDestinatario().getCnpj())) {
                    nFDestinatarioEpec.setCnpj(nFNota.getInfo().getDestinatario().getCnpj());
                } else {
                    nFDestinatarioEpec.setCpf(nFNota.getInfo().getDestinatario().getCpfj());
                }
                nFDestinatarioEpec.setIdEstrangeiro(nFNota.getInfo().getDestinatario().getIdEstrangeiro());
                nFDestinatarioEpec.setInscricaoEstadualDestinatario(nFNota.getInfo().getDestinatario().getInscricaoEstadual());
                if (nFNota.getInfo().getDestinatario().getEndereco() != null) {
                    nFDestinatarioEpec.setUfDestinatario(nFNota.getInfo().getDestinatario().getEndereco().getUf());
                }
                if (nFNota.getInfo().getTotal() != null) {
                    nFDestinatarioEpec.setValorTotalIcms(nFNota.getInfo().getTotal().getIcmsTotal().getValorTotalICMS());
                    nFDestinatarioEpec.setValorTotalIcmsSubstituicaoTributaria(nFNota.getInfo().getTotal().getIcmsTotal().getValorTotalICMSST());
                    nFDestinatarioEpec.setValorTotalNFe(nFNota.getInfo().getTotal().getIcmsTotal().getValorTotalNFe());
                }
                nFInfoEpec.setDestinatario(nFDestinatarioEpec);
            }
            nFEventoEpec.setInfoEvento(nFInfoEventoEpec);
            nFEnviaEventoEpec.getEvento().add(nFEventoEpec);
        }
        return nFEnviaEventoEpec;
    }

    private NFEnviaEventoEpecRetorno comunicaEpec(String string) throws Exception {
        NFeRecepcaoEvento4Stub.NfeResultMsg nfeResultMsg = this.comunicaLoteRaw(string, DFModelo.NFE);
        OMElement oMElement = nfeResultMsg.getExtraElement();
        String string2 = oMElement.toString();
        return (NFEnviaEventoEpecRetorno)this.config.getPersister().read(NFEnviaEventoEpecRetorno.class, string2);
    }

    public NFeRecepcaoEvento4Stub.NfeResultMsg comunicaLoteRaw(String string, DFModelo dFModelo) throws Exception {
        String string2;
        DFXMLValidador.validaEpec(string);
        OMElement oMElement = this.nfeToOMElement(string);
        NFeRecepcaoEvento4Stub.NfeDadosMsg nfeDadosMsg = new NFeRecepcaoEvento4Stub.NfeDadosMsg();
        nfeDadosMsg.setExtraElement(oMElement);
        NFAutorizador400 nFAutorizador400 = NFAutorizador400.valueOfTipoEmissao(this.config.getTipoEmissao(), this.config.getCUF());
        String string3 = string2 = DFModelo.NFE.equals((Object)dFModelo) ? nFAutorizador400.getRecepcaoEvento(this.config.getAmbiente()) : nFAutorizador400.getNfceAutorizacao(this.config.getAmbiente());
        if (string2 == null) {
            throw new IllegalArgumentException("Nao foi possivel encontrar URL para Autorizacao " + dFModelo.name() + ", autorizador " + nFAutorizador400.name());
        }
        return new NFeRecepcaoEvento4Stub(string2, this.config).nfeRecepcaoEvento(nfeDadosMsg);
    }

    private OMElement nfeToOMElement(String string) throws XMLStreamException {
        XMLInputFactory xMLInputFactory = XMLInputFactory.newInstance();
        xMLInputFactory.setProperty("javax.xml.stream.isCoalescing", false);
        XMLStreamReader xMLStreamReader = xMLInputFactory.createXMLStreamReader(new StringReader(string));
        StAXOMBuilder stAXOMBuilder = new StAXOMBuilder(xMLStreamReader);
        OMElement oMElement = stAXOMBuilder.getDocumentElement();
        Iterator iterator = oMElement.getChildrenWithLocalName(NFE_ELEMENTO);
        while (iterator.hasNext()) {
            OMElement oMElement2 = (OMElement)iterator.next();
            if (oMElement2 == null || !NFE_ELEMENTO.equals(oMElement2.getLocalName())) continue;
            oMElement2.addAttribute("xmlns", "http://www.portalfiscal.inf.br/nfe", null);
        }
        return oMElement;
    }
}

