/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.nfe400.webservices;

import com.fincatto.documentofiscal.DFModelo;
import com.fincatto.documentofiscal.DFUnidadeFederativa;
import com.fincatto.documentofiscal.nfe.NFeConfig;
import com.fincatto.documentofiscal.nfe.classes.distribuicao.NFDistribuicaoIntRetorno;
import com.fincatto.documentofiscal.nfe.webservices.distribuicao.WSDistribuicaoNFe;
import com.fincatto.documentofiscal.nfe400.classes.cadastro.NFRetornoConsultaCadastro;
import com.fincatto.documentofiscal.nfe400.classes.evento.NFEnviaEventoRetorno;
import com.fincatto.documentofiscal.nfe400.classes.evento.cartacorrecao.NFProtocoloEventoCartaCorrecao;
import com.fincatto.documentofiscal.nfe400.classes.evento.epec.NFEnviaEventoEpecRetorno;
import com.fincatto.documentofiscal.nfe400.classes.evento.inutilizacao.NFRetornoEventoInutilizacao;
import com.fincatto.documentofiscal.nfe400.classes.evento.manifestacaodestinatario.NFProtocoloEventoManifestacaoDestinatario;
import com.fincatto.documentofiscal.nfe400.classes.evento.manifestacaodestinatario.NFTipoEventoManifestacaoDestinatario;
import com.fincatto.documentofiscal.nfe400.classes.lote.consulta.NFLoteConsultaRetorno;
import com.fincatto.documentofiscal.nfe400.classes.lote.envio.NFCancelamentoRetornoDados;
import com.fincatto.documentofiscal.nfe400.classes.lote.envio.NFLoteEnvio;
import com.fincatto.documentofiscal.nfe400.classes.lote.envio.NFLoteEnvioRetorno;
import com.fincatto.documentofiscal.nfe400.classes.lote.envio.NFLoteEnvioRetornoDados;
import com.fincatto.documentofiscal.nfe400.classes.lote.envio.NFLoteIndicadorProcessamento;
import com.fincatto.documentofiscal.nfe400.classes.nota.consulta.NFNotaConsultaRetorno;
import com.fincatto.documentofiscal.nfe400.classes.statusservico.consulta.NFStatusServicoConsultaRetorno;
import com.fincatto.documentofiscal.nfe400.webservices.WSCancelamento;
import com.fincatto.documentofiscal.nfe400.webservices.WSCartaCorrecao;
import com.fincatto.documentofiscal.nfe400.webservices.WSConsultaCadastro;
import com.fincatto.documentofiscal.nfe400.webservices.WSEpec;
import com.fincatto.documentofiscal.nfe400.webservices.WSInutilizacao;
import com.fincatto.documentofiscal.nfe400.webservices.WSLoteConsulta;
import com.fincatto.documentofiscal.nfe400.webservices.WSLoteEnvio;
import com.fincatto.documentofiscal.nfe400.webservices.WSManifestacaoDestinatario;
import com.fincatto.documentofiscal.nfe400.webservices.WSNotaConsulta;
import com.fincatto.documentofiscal.nfe400.webservices.WSStatusConsulta;
import com.fincatto.documentofiscal.nfe400.webservices.gerado.NFeAutorizacao4Stub;
import com.fincatto.documentofiscal.utils.DFSocketFactory;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;

public class WSFacade {
    private final WSLoteEnvio wsLoteEnvio;
    private final WSLoteConsulta wsLoteConsulta;
    private final WSStatusConsulta wsStatusConsulta;
    private final WSNotaConsulta wsNotaConsulta;
    private final WSCartaCorrecao wsCartaCorrecao;
    private final WSCancelamento wsCancelamento;
    private final WSConsultaCadastro wsConsultaCadastro;
    private final WSInutilizacao wsInutilizacao;
    private final WSManifestacaoDestinatario wSManifestacaoDestinatario;
    private final WSDistribuicaoNFe wSDistribuicaoNFe;
    private final WSEpec wsEpec;

    public WSFacade(NFeConfig nFeConfig) throws KeyManagementException, UnrecoverableKeyException, KeyStoreException, NoSuchAlgorithmException {
        Protocol.registerProtocol((String)"https", (Protocol)new Protocol("https", (ProtocolSocketFactory)new DFSocketFactory(nFeConfig), 443));
        this.wsLoteEnvio = new WSLoteEnvio(nFeConfig);
        this.wsLoteConsulta = new WSLoteConsulta(nFeConfig);
        this.wsStatusConsulta = new WSStatusConsulta(nFeConfig);
        this.wsNotaConsulta = new WSNotaConsulta(nFeConfig);
        this.wsCartaCorrecao = new WSCartaCorrecao(nFeConfig);
        this.wsCancelamento = new WSCancelamento(nFeConfig);
        this.wsConsultaCadastro = new WSConsultaCadastro(nFeConfig);
        this.wsInutilizacao = new WSInutilizacao(nFeConfig);
        this.wSManifestacaoDestinatario = new WSManifestacaoDestinatario(nFeConfig);
        this.wSDistribuicaoNFe = new WSDistribuicaoNFe(nFeConfig);
        this.wsEpec = new WSEpec(nFeConfig);
    }

    public NFLoteEnvioRetornoDados enviaLote(NFLoteEnvio nFLoteEnvio, boolean bl) throws Exception {
        if (nFLoteEnvio.getIndicadorProcessamento().equals((Object)NFLoteIndicadorProcessamento.PROCESSAMENTO_SINCRONO) && nFLoteEnvio.getNotas().size() > 1) {
            throw new IllegalArgumentException("Apenas uma nota permitida no modo sincrono!");
        }
        if (nFLoteEnvio.getNotas().size() == 0) {
            throw new IllegalArgumentException("Nenhuma nota informada no envio do Lote!");
        }
        return this.wsLoteEnvio.enviaLote(nFLoteEnvio, bl);
    }

    public NFLoteEnvioRetornoDados enviaLote(NFLoteEnvio nFLoteEnvio) throws Exception {
        return this.enviaLote(nFLoteEnvio, true);
    }

    public NFLoteEnvio getLoteAssinado(NFLoteEnvio nFLoteEnvio) throws Exception {
        return this.wsLoteEnvio.getLoteAssinado(nFLoteEnvio);
    }

    public NFLoteEnvioRetorno enviaLoteAssinado(String string, DFModelo dFModelo) throws Exception {
        return this.wsLoteEnvio.enviaLoteAssinado(string, dFModelo);
    }

    public NFeAutorizacao4Stub.NfeResultMsg getNfeResultMsg(String string, DFModelo dFModelo) throws Exception {
        return this.wsLoteEnvio.comunicaLoteRaw(string, dFModelo, true);
    }

    public NFLoteConsultaRetorno consultaLote(String string, DFModelo dFModelo) throws Exception {
        return this.wsLoteConsulta.consultaLote(string, dFModelo);
    }

    public NFStatusServicoConsultaRetorno consultaStatus(DFUnidadeFederativa dFUnidadeFederativa, DFModelo dFModelo) throws Exception {
        return this.wsStatusConsulta.consultaStatus(dFUnidadeFederativa, dFModelo);
    }

    public NFNotaConsultaRetorno consultaNota(String string) throws Exception {
        return this.wsNotaConsulta.consultaNota(string);
    }

    public String consultaNotaAsString(String string) throws Exception {
        return this.wsNotaConsulta.consultaNotaAsString(string);
    }

    public NFEnviaEventoRetorno corrigeNota(String string, String string2, int n) throws Exception {
        return this.wsCartaCorrecao.corrigeNota(string, string2, n);
    }

    public NFEnviaEventoRetorno corrigeNotaAssinada(String string, String string2) throws Exception {
        return this.wsCartaCorrecao.corrigeNotaAssinada(string, string2);
    }

    public NFEnviaEventoRetorno corrigeNotaAssinada(String string) throws Exception {
        return this.wsCartaCorrecao.corrigeNotaAssinada(string);
    }

    public NFProtocoloEventoCartaCorrecao corrigeNotaAssinadaProtocolo(String string) throws Exception {
        return this.wsCartaCorrecao.corrigeNotaAssinadaProtocolo(string);
    }

    public NFProtocoloEventoCartaCorrecao corrigeNotaAssinadaProtocolo(String string, String string2, int n) throws Exception {
        return this.wsCartaCorrecao.corrigeNotaAssinadaProtocolo(this.getXmlAssinado(string, string2, n));
    }

    public String getXmlAssinado(String string, String string2, int n) throws Exception {
        return this.wsCartaCorrecao.getXmlAssinado(string, string2, n);
    }

    public NFCancelamentoRetornoDados cancelaNota(String string, String string2, String string3) throws Exception {
        return this.wsCancelamento.cancelaNota(string, string2, string3);
    }

    public NFEnviaEventoRetorno cancelaNotaAssinada(String string, String string2) throws Exception {
        return this.wsCancelamento.cancelaNotaAssinada(string, string2);
    }

    public NFEnviaEventoRetorno cancelaNotaPorSubstituicao(String string, String string2, String string3, String string4, String string5) throws Exception {
        return this.wsCancelamento.cancelaNotaPorSubstituicao(string, string2, string3, string4, string5);
    }

    public NFRetornoEventoInutilizacao inutilizaNotaAssinada(String string, DFModelo dFModelo) throws Exception {
        return this.wsInutilizacao.inutilizaNotaAssinada(string, dFModelo);
    }

    public NFRetornoEventoInutilizacao inutilizaNota(int n, String string, String string2, String string3, String string4, String string5, DFModelo dFModelo) throws Exception {
        return this.wsInutilizacao.inutilizaNota(n, string, string2, string3, string4, string5, dFModelo);
    }

    public NFRetornoConsultaCadastro consultaCadastro(String string, DFUnidadeFederativa dFUnidadeFederativa) throws Exception {
        return this.wsConsultaCadastro.consultaCadastro(string, dFUnidadeFederativa);
    }

    public NFRetornoConsultaCadastro consultaCadastroInscEst(String string, DFUnidadeFederativa dFUnidadeFederativa) throws Exception {
        return this.wsConsultaCadastro.consultaCadastroInscEst(string, dFUnidadeFederativa);
    }

    public NFEnviaEventoRetorno manifestaDestinatarioNota(String string, NFTipoEventoManifestacaoDestinatario nFTipoEventoManifestacaoDestinatario, String string2, String string3) throws Exception {
        return this.wSManifestacaoDestinatario.manifestaDestinatarioNota(string, nFTipoEventoManifestacaoDestinatario, string2, string3);
    }

    public NFProtocoloEventoManifestacaoDestinatario manifestaDestinatarioNotaProtocolo(String string, NFTipoEventoManifestacaoDestinatario nFTipoEventoManifestacaoDestinatario, String string2, String string3) throws Exception {
        return this.wSManifestacaoDestinatario.manifestaDestinatarioNotaProtocolo(string, nFTipoEventoManifestacaoDestinatario, string2, string3);
    }

    public NFEnviaEventoRetorno manifestaDestinatarioNotaAssinada(String string, String string2) throws Exception {
        return this.wSManifestacaoDestinatario.manifestaDestinatarioNotaAssinada(string, string2);
    }

    public NFDistribuicaoIntRetorno consultarDistribuicaoDFe(String string, DFUnidadeFederativa dFUnidadeFederativa, String string2, String string3, String string4) throws Exception {
        return this.wSDistribuicaoNFe.consultar(string, dFUnidadeFederativa, string2, string3, string4);
    }

    public NFEnviaEventoEpecRetorno enviaLoteEpec(NFLoteEnvio nFLoteEnvio) throws Exception {
        return this.wsEpec.enviaEpec(nFLoteEnvio);
    }

    public NFEnviaEventoEpecRetorno enviaEpec(NFLoteEnvio nFLoteEnvio) throws Exception {
        return this.wsEpec.enviaEpec(nFLoteEnvio);
    }

    public NFEnviaEventoEpecRetorno enviaEpecAssinado(String string) throws Exception {
        return this.wsEpec.enviaEpecAssinado(string);
    }
}

