/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.nfe400.webservices;

import com.fincatto.documentofiscal.DFLog;
import com.fincatto.documentofiscal.DFModelo;
import com.fincatto.documentofiscal.nfe.NFeConfig;
import com.fincatto.documentofiscal.nfe400.classes.NFAutorizador400;
import com.fincatto.documentofiscal.nfe400.classes.evento.inutilizacao.NFEnviaEventoInutilizacao;
import com.fincatto.documentofiscal.nfe400.classes.evento.inutilizacao.NFEventoInutilizacaoDados;
import com.fincatto.documentofiscal.nfe400.classes.evento.inutilizacao.NFRetornoEventoInutilizacao;
import com.fincatto.documentofiscal.nfe400.webservices.gerado.NFeInutilizacao4Stub;
import com.fincatto.documentofiscal.utils.DFAssinaturaDigital;
import java.math.BigDecimal;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.AXIOMUtil;
import org.apache.commons.lang3.StringUtils;

class WSInutilizacao
implements DFLog {
    private static final String VERSAO_SERVICO = "4.00";
    private static final String NOME_SERVICO = "INUTILIZAR";
    private final NFeConfig config;

    WSInutilizacao(NFeConfig nFeConfig) {
        this.config = nFeConfig;
    }

    NFRetornoEventoInutilizacao inutilizaNotaAssinada(String string, DFModelo dFModelo) throws Exception {
        OMElement oMElement = this.efetuaInutilizacao(string, dFModelo);
        return (NFRetornoEventoInutilizacao)this.config.getPersister().read(NFRetornoEventoInutilizacao.class, oMElement.toString());
    }

    NFRetornoEventoInutilizacao inutilizaNota(int n, String string, String string2, String string3, String string4, String string5, DFModelo dFModelo) throws Exception {
        String string6 = this.geraDadosInutilizacao(n, string, string2, string3, string4, string5, dFModelo).toString();
        String string7 = new DFAssinaturaDigital(this.config).assinarDocumento(string6);
        OMElement oMElement = this.efetuaInutilizacao(string7, dFModelo);
        return (NFRetornoEventoInutilizacao)this.config.getPersister().read(NFRetornoEventoInutilizacao.class, oMElement.toString());
    }

    private OMElement efetuaInutilizacao(String string, DFModelo dFModelo) throws Exception {
        NFeInutilizacao4Stub.NfeDadosMsg nfeDadosMsg = new NFeInutilizacao4Stub.NfeDadosMsg();
        OMElement oMElement = AXIOMUtil.stringToOM((String)string);
        this.getLogger().debug(oMElement.toString());
        nfeDadosMsg.setExtraElement(oMElement);
        NFAutorizador400 nFAutorizador400 = NFAutorizador400.valueOfCodigoUF(this.config.getCUF());
        String string2 = DFModelo.NFE.equals((Object)dFModelo) ? nFAutorizador400.getNfeInutilizacao(this.config.getAmbiente()) : nFAutorizador400.getNfceInutilizacao(this.config.getAmbiente());
        NFeInutilizacao4Stub.NfeResultMsg nfeResultMsg = new NFeInutilizacao4Stub(string2, this.config).nfeInutilizacaoNF(nfeDadosMsg);
        OMElement oMElement2 = nfeResultMsg.getExtraElement();
        this.getLogger().debug(oMElement2.toString());
        return oMElement2;
    }

    private NFEnviaEventoInutilizacao geraDadosInutilizacao(int n, String string, String string2, String string3, String string4, String string5, DFModelo dFModelo) {
        NFEnviaEventoInutilizacao nFEnviaEventoInutilizacao = new NFEnviaEventoInutilizacao();
        NFEventoInutilizacaoDados nFEventoInutilizacaoDados = new NFEventoInutilizacaoDados();
        nFEventoInutilizacaoDados.setAmbiente(this.config.getAmbiente());
        nFEventoInutilizacaoDados.setAno(n);
        nFEventoInutilizacaoDados.setCnpj(string);
        nFEventoInutilizacaoDados.setJustificativa(string5);
        nFEventoInutilizacaoDados.setModeloDocumentoFiscal(dFModelo.getCodigo());
        nFEventoInutilizacaoDados.setNomeServico(NOME_SERVICO);
        nFEventoInutilizacaoDados.setNumeroNFInicial(string3);
        nFEventoInutilizacaoDados.setNumeroNFFinal(string4);
        nFEventoInutilizacaoDados.setSerie(string2);
        nFEventoInutilizacaoDados.setUf(this.config.getCUF());
        String string6 = StringUtils.leftPad((String)string3, (int)9, (String)"0");
        String string7 = StringUtils.leftPad((String)string4, (int)9, (String)"0");
        String string8 = StringUtils.leftPad((String)string2, (int)3, (String)"0");
        nFEventoInutilizacaoDados.setIdentificador("ID" + this.config.getCUF().getCodigoIbge() + n + string + dFModelo.getCodigo() + string8 + string6 + string7);
        nFEnviaEventoInutilizacao.setVersao(new BigDecimal(VERSAO_SERVICO));
        nFEnviaEventoInutilizacao.setDados(nFEventoInutilizacaoDados);
        return nFEnviaEventoInutilizacao;
    }
}

