/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.nfe400.webservices;

import com.fincatto.documentofiscal.DFLog;
import com.fincatto.documentofiscal.DFModelo;
import com.fincatto.documentofiscal.nfe.NFeConfig;
import com.fincatto.documentofiscal.nfe400.classes.NFAutorizador400;
import com.fincatto.documentofiscal.nfe400.classes.lote.consulta.NFLoteConsulta;
import com.fincatto.documentofiscal.nfe400.classes.lote.consulta.NFLoteConsultaRetorno;
import com.fincatto.documentofiscal.nfe400.webservices.gerado.NFeRetAutorizacao4Stub;
import java.math.BigDecimal;
import java.rmi.RemoteException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.AXIOMUtil;

class WSLoteConsulta
implements DFLog {
    private final NFeConfig config;

    WSLoteConsulta(NFeConfig nFeConfig) {
        this.config = nFeConfig;
    }

    NFLoteConsultaRetorno consultaLote(String string, DFModelo dFModelo) throws Exception {
        OMElement oMElement = AXIOMUtil.stringToOM((String)this.gerarDadosConsulta(string).toString());
        this.getLogger().debug(oMElement.toString());
        OMElement oMElement2 = this.efetuaConsulta(oMElement, dFModelo);
        this.getLogger().debug(oMElement2.toString());
        return (NFLoteConsultaRetorno)this.config.getPersister().read(NFLoteConsultaRetorno.class, oMElement2.toString());
    }

    private OMElement efetuaConsulta(OMElement oMElement, DFModelo dFModelo) throws RemoteException {
        String string;
        NFeRetAutorizacao4Stub.NfeDadosMsg nfeDadosMsg = new NFeRetAutorizacao4Stub.NfeDadosMsg();
        nfeDadosMsg.setExtraElement(oMElement);
        NFAutorizador400 nFAutorizador400 = NFAutorizador400.valueOfTipoEmissao(this.config.getTipoEmissao(), this.config.getCUF());
        String string2 = string = DFModelo.NFCE.equals((Object)dFModelo) ? nFAutorizador400.getNfceRetAutorizacao(this.config.getAmbiente()) : nFAutorizador400.getNfeRetAutorizacao(this.config.getAmbiente());
        if (string == null) {
            throw new IllegalArgumentException("Nao foi possivel encontrar URL para RetAutorizacao " + dFModelo.name() + ", autorizador " + nFAutorizador400.name());
        }
        NFeRetAutorizacao4Stub.NfeResultMsg nfeResultMsg = new NFeRetAutorizacao4Stub(string, this.config).nfeRetAutorizacaoLote(nfeDadosMsg);
        return nfeResultMsg.getExtraElement();
    }

    private NFLoteConsulta gerarDadosConsulta(String string) {
        NFLoteConsulta nFLoteConsulta = new NFLoteConsulta();
        nFLoteConsulta.setRecibo(string);
        nFLoteConsulta.setAmbiente(this.config.getAmbiente());
        nFLoteConsulta.setVersao(new BigDecimal(this.config.getVersao()));
        return nFLoteConsulta;
    }
}

