/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.utils;

import com.fincatto.documentofiscal.DFAmbiente;
import com.fincatto.documentofiscal.DFLog;
import com.fincatto.documentofiscal.cte300.classes.CTAutorizador31;
import com.fincatto.documentofiscal.cte400.classes.CTAutorizador400;
import com.fincatto.documentofiscal.mdfe3.classes.MDFAutorizador3;
import com.fincatto.documentofiscal.nfe400.classes.NFAutorizador400;
import java.io.ByteArrayOutputStream;
import java.net.Socket;
import java.net.URI;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.lang3.StringUtils;

public abstract class DFCadeiaCertificados
implements DFLog {
    private static final int PORT = 443;
    private static final String PROTOCOL = "TLSv1.2";

    /*
     * WARNING - void declaration
     */
    public static byte[] geraCadeiaCertificados(DFAmbiente dFAmbiente, String string) throws Exception {
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        keyStore.load(null, string.toCharArray());
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            String string2;
            String string3;
            String string4;
            void objectArray;
            NFAutorizador400[] object = NFAutorizador400.values();
            int string6 = object.length;
            boolean string7 = false;
            while (objectArray < string6) {
                String string5;
                NFAutorizador400 nFAutorizador400 = object[objectArray];
                String string8 = nFAutorizador400.getNfeStatusServico(dFAmbiente);
                if (StringUtils.isNotBlank((CharSequence)string8)) {
                    String string9 = new URI(string8).getHost();
                    DFCadeiaCertificados.get(keyStore, string9);
                }
                if (StringUtils.isNotBlank((CharSequence)(string5 = nFAutorizador400.getNfceStatusServico(dFAmbiente)))) {
                    string4 = new URI(string5).getHost();
                    DFCadeiaCertificados.get(keyStore, string4);
                }
                ++objectArray;
            }
            String string10 = NFAutorizador400.AN.getRecepcaoEventoAN(dFAmbiente);
            if (StringUtils.isNotBlank((CharSequence)string10)) {
                String string32 = new URI(string10).getHost();
                DFCadeiaCertificados.get(keyStore, string32);
            }
            if (StringUtils.isNotBlank((CharSequence)(string3 = NFAutorizador400.AN.getNFeDistribuicaoDFe(dFAmbiente)))) {
                String string11 = new URI(string3).getHost();
                DFCadeiaCertificados.get(keyStore, string11);
            }
            for (MDFAutorizador3 mDFAutorizador3 : MDFAutorizador3.values()) {
                string4 = mDFAutorizador3.getMDFeStatusServico(dFAmbiente);
                if (!StringUtils.isNotBlank((CharSequence)string4)) continue;
                string2 = new URI(string4).getHost();
                DFCadeiaCertificados.get(keyStore, string2);
            }
            for (CTAutorizador31 cTAutorizador31 : CTAutorizador31.values()) {
                string4 = cTAutorizador31.getCteStatusServico(dFAmbiente);
                if (!StringUtils.isNotBlank((CharSequence)string4)) continue;
                string2 = new URI(string4).getHost();
                DFCadeiaCertificados.get(keyStore, string2);
            }
            for (CTAutorizador400 cTAutorizador400 : CTAutorizador400.values()) {
                string4 = cTAutorizador400.getCteStatusServico(dFAmbiente);
                if (!StringUtils.isNotBlank((CharSequence)string4)) continue;
                string2 = new URI(string4).getHost();
                DFCadeiaCertificados.get(keyStore, string2);
            }
            keyStore.store(byteArrayOutputStream, string.toCharArray());
            byte[] byArray = byteArrayOutputStream.toByteArray();
            return byArray;
        }
    }

    private static void get(KeyStore keyStore, String string) throws Exception {
        Object object;
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init(keyStore);
        X509TrustManager x509TrustManager = (X509TrustManager)trustManagerFactory.getTrustManagers()[0];
        SavingTrustManager savingTrustManager = new SavingTrustManager(x509TrustManager);
        SSLContext sSLContext = SSLContext.getInstance(PROTOCOL);
        sSLContext.init(null, new TrustManager[]{savingTrustManager}, null);
        DFLog.getLogger(DFCadeiaCertificados.class).debug("Abrindo conexao para o servidor: {}:{}", (Object)string, (Object)443);
        try {
            object = (SSLSocket)sSLContext.getSocketFactory().createSocket(string, 443);
            try {
                ((Socket)object).setSoTimeout(10000);
                ((SSLSocket)object).startHandshake();
            }
            finally {
                if (object != null) {
                    ((Socket)object).close();
                }
            }
        }
        catch (Exception exception) {
            DFLog.getLogger(DFCadeiaCertificados.class).error(String.format("[%s] %s", string, exception.toString()));
        }
        if (savingTrustManager.chain != null) {
            DFLog.getLogger(DFCadeiaCertificados.class).debug("Certificados enviados pelo servidor: {}", (Object)savingTrustManager.chain.length);
            object = MessageDigest.getInstance("SHA1");
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            for (int i = 0; i < savingTrustManager.chain.length; ++i) {
                X509Certificate x509Certificate = savingTrustManager.chain[i];
                ((MessageDigest)object).update(x509Certificate.getEncoded());
                messageDigest.update(x509Certificate.getEncoded());
                String string2 = String.format("%s.%s", string, i + 1);
                keyStore.setCertificateEntry(string2, x509Certificate);
                DFLog.getLogger(DFCadeiaCertificados.class).debug("Adicionado certificado no keystore com o alias: {}", (Object)string2);
            }
        }
    }

    private static class SavingTrustManager
    implements X509TrustManager {
        private final X509TrustManager trustManager;
        private X509Certificate[] chain;

        SavingTrustManager(X509TrustManager x509TrustManager) {
            this.trustManager = x509TrustManager;
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return this.trustManager.getAcceptedIssuers();
        }

        @Override
        public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
            this.trustManager.checkClientTrusted(x509CertificateArray, string);
        }

        @Override
        public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
            this.chain = x509CertificateArray;
            this.trustManager.checkServerTrusted(x509CertificateArray, string);
        }
    }
}

