/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.validadores;

import java.io.IOException;
import java.io.StringReader;
import java.net.URISyntaxException;
import java.net.URL;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.xml.sax.SAXException;

public final class DFXMLValidador {
    private static boolean valida(String string, String string2) throws IOException, SAXException, URISyntaxException {
        URL uRL = DFXMLValidador.class.getClassLoader().getResource(String.format("schemas/PL_008i2/%s", string2));
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema schema = schemaFactory.newSchema(new StreamSource(uRL.toURI().toString()));
        schema.newValidator().validate(new StreamSource(new StringReader(string)));
        return true;
    }

    public static boolean validaLote(String string) throws Exception {
        return DFXMLValidador.valida(string, "enviNFe_v3.10.xsd");
    }

    public static boolean validaNota(String string) throws Exception {
        return DFXMLValidador.valida(string, "nfe_v3.10.xsd");
    }

    public static boolean valida400(String string, String string2) throws IOException, SAXException, URISyntaxException {
        URL uRL = DFXMLValidador.class.getClassLoader().getResource(String.format("schemas/PL_010b_NT2025_002_v1.00/%s", string2));
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema schema = schemaFactory.newSchema(new StreamSource(uRL.toURI().toString()));
        schema.newValidator().validate(new StreamSource(new StringReader(string)));
        return true;
    }

    public static boolean validaLote400(String string) throws Exception {
        return DFXMLValidador.valida400(string, "enviNFe_v4.00.xsd");
    }

    public static boolean validaNota400(String string) throws Exception {
        return DFXMLValidador.valida400(string, "nfe_v4.00.xsd");
    }

    private static boolean validaMDF(String string, String string2) throws IOException, SAXException, URISyntaxException {
        System.setProperty("jdk.xml.maxOccurLimit", "20000");
        URL uRL = DFXMLValidador.class.getClassLoader().getResource(String.format("schemas/PL_MDFe_300b_NT022024/%s", string2));
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema schema = schemaFactory.newSchema(new StreamSource(uRL.toURI().toString()));
        schema.newValidator().validate(new StreamSource(new StringReader(string)));
        return true;
    }

    public static boolean validaLoteMDFe(String string) throws Exception {
        return DFXMLValidador.validaMDF(string, "enviMDFe_v3.00.xsd");
    }

    public static boolean validaMDFe(String string) throws Exception {
        return DFXMLValidador.validaMDF(string, "mdfe_v3.00.xsd");
    }

    public static boolean validaMDFeProcessado(String string) throws Exception {
        return DFXMLValidador.validaMDF(string, "procMDFe_v3.00.xsd");
    }

    public static boolean validaEventoMDFe(String string) throws Exception {
        return DFXMLValidador.validaMDF(string, "eventoMDFe_v3.00.xsd");
    }

    public static boolean validaEventoPagamentoOperacaoMDFe(String string) throws Exception {
        return DFXMLValidador.validaMDF(string, "evPagtoOperMDFe_v3.00.xsd");
    }

    private static boolean validaCTe(String string, String string2) throws IOException, SAXException, URISyntaxException {
        URL uRL = DFXMLValidador.class.getClassLoader().getResource(String.format("schemas/PL_CTe_300a_NT2022.001/%s", string2));
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema schema = schemaFactory.newSchema(new StreamSource(uRL.toURI().toString()));
        schema.newValidator().validate(new StreamSource(new StringReader(string)));
        return true;
    }

    public static boolean validaLoteCTe300(String string) throws Exception {
        return DFXMLValidador.validaCTe(string, "enviCTe_v3.00.xsd");
    }

    public static boolean validaCTeOS300(String string) throws Exception {
        return DFXMLValidador.validaCTe(string, "cteOS_v3.00.xsd");
    }

    public static boolean validaNotaCte(String string) throws Exception {
        return DFXMLValidador.validaCTe(string, "cte_v3.00.xsd");
    }

    public static boolean validaEventoCTe300(String string) throws Exception {
        return DFXMLValidador.validaCTe(string, "eventoCTe_v3.00.xsd");
    }

    public static boolean validaEventoCancelamentoCTe300(String string) throws Exception {
        return DFXMLValidador.validaCTe(string, "evCancCTe_v3.00.xsd");
    }

    public static boolean validaEventoCancelamentoComprovanteEntregaCTe300(String string) throws Exception {
        return DFXMLValidador.validaCTe(string, "evCancCECTe_v3.00.xsd");
    }

    public static boolean validaEventoCartaCorrecaoCTe300(String string) throws Exception {
        return DFXMLValidador.validaCTe(string, "evCCeCTe_v3.00.xsd");
    }

    public static boolean validaEventoComprovanteEntregaCTe300(String string) throws Exception {
        return DFXMLValidador.validaCTe(string, "evCECTe_v3.00.xsd");
    }

    public static boolean validaEventoEpecCTe300(String string) throws Exception {
        return DFXMLValidador.validaCTe(string, "evEPECCTe_v3.00.xsd");
    }

    public static boolean validaEventoGtvCTe300(String string) throws Exception {
        return DFXMLValidador.validaCTe(string, "evGTV_v3.00.xsd");
    }

    public static boolean validaEventoPrestacaoEmDesacordoCTe300(String string) throws Exception {
        return DFXMLValidador.validaCTe(string, "evPrestDesacordo_v3.00.xsd");
    }

    public static boolean validaEventoRegistroMultimodalCTe300(String string) throws Exception {
        return DFXMLValidador.validaCTe(string, "evRegMultimodal_v3.00.xsd");
    }

    private static boolean validaCTe400(String string, String string2) throws IOException, SAXException, URISyntaxException {
        URL uRL = DFXMLValidador.class.getClassLoader().getResource(String.format("schemas/PL_CTe_400_NT2025.001_RTC_1.05/%s", string2));
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema schema = schemaFactory.newSchema(new StreamSource(uRL.toURI().toString()));
        schema.newValidator().validate(new StreamSource(new StringReader(string)));
        return true;
    }

    public static boolean validaNotaCte400(String string) throws Exception {
        return DFXMLValidador.validaCTe400(string, "cte_v4.00.xsd");
    }

    public static boolean validaNotaCTeOS400(String string) throws Exception {
        return DFXMLValidador.validaCTe400(string, "cteOS_v4.00.xsd");
    }

    public static boolean validaEventoCTe400(String string) throws Exception {
        return DFXMLValidador.validaCTe400(string, "eventoCTe_v4.00.xsd");
    }

    public static boolean validaEventoCancelamentoCTe400(String string) throws Exception {
        return DFXMLValidador.validaCTe400(string, "evCancCTe_v4.00.xsd");
    }

    public static boolean validaEventoCancelamentoComprovanteEntregaCTe400(String string) throws Exception {
        return DFXMLValidador.validaCTe400(string, "evCancCECTe_v4.00.xsd");
    }

    public static boolean validaEventoCartaCorrecaoCTe400(String string) throws Exception {
        return DFXMLValidador.validaCTe400(string, "evCCeCTe_v4.00.xsd");
    }

    public static boolean validaEventoComprovanteEntregaCTe400(String string) throws Exception {
        return DFXMLValidador.validaCTe400(string, "evCECTe_v4.00.xsd");
    }

    public static boolean validaEventoEpecCTe400(String string) throws Exception {
        return DFXMLValidador.validaCTe400(string, "evEPECCTe_v4.00.xsd");
    }

    public static boolean validaEventoGtvCTe400(String string) throws Exception {
        return DFXMLValidador.validaCTe400(string, "evGTV_v4.00.xsd");
    }

    public static boolean validaEventoPrestacaoEmDesacordoCTe400(String string) throws Exception {
        return DFXMLValidador.validaCTe400(string, "evPrestDesacordo_v4.00.xsd");
    }

    public static boolean validaEventoRegistroMultimodalCTe400(String string) throws Exception {
        return DFXMLValidador.validaCTe400(string, "evRegMultimodal_v4.00.xsd");
    }

    public static boolean validaEventoCancelamentoPrestacaoEmDesacordoCTe400(String string) throws Exception {
        return DFXMLValidador.validaCTe400(string, "evCancPrestDesacordo_v4.00.xsd");
    }

    public static boolean validaEventoCancelamentoInsucessoEntregaCTe400(String string) throws Exception {
        return DFXMLValidador.validaCTe400(string, "evCancIECTe_v4.00.xsd");
    }

    public static boolean validaEventoInsucessoEntregaCTe400(String string) throws Exception {
        return DFXMLValidador.validaCTe400(string, "evIECTe_v4.00.xsd");
    }

    private static boolean validaDfe(String string, String string2) throws IOException, SAXException, URISyntaxException {
        URL uRL = DFXMLValidador.class.getClassLoader().getResource(String.format("schemas/PL_NFeDistDFe_102/%s", string2));
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema schema = schemaFactory.newSchema(new StreamSource(uRL.toURI().toString()));
        schema.newValidator().validate(new StreamSource(new StringReader(string)));
        return true;
    }

    private static boolean validaDistribuicaoCTe(String string, String string2) throws IOException, SAXException, URISyntaxException {
        URL uRL = DFXMLValidador.class.getClassLoader().getResource(String.format("schemas/PL_CTeDistDFe_100/%s", string2));
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema schema = schemaFactory.newSchema(new StreamSource(uRL.toURI().toString()));
        schema.newValidator().validate(new StreamSource(new StringReader(string)));
        return true;
    }

    public static boolean validaDistribuicaoCTe(String string) throws IOException, SAXException, URISyntaxException {
        return DFXMLValidador.validaDistribuicaoCTe(string, "distDFeInt_v1.00.xsd");
    }

    private static boolean validaDistribuicaoMDFe(String string, String string2) throws IOException, SAXException, URISyntaxException {
        URL uRL = DFXMLValidador.class.getClassLoader().getResource(String.format("schemas/PL_MDFeDistDFe_100/%s", string2));
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema schema = schemaFactory.newSchema(new StreamSource(uRL.toURI().toString()));
        schema.newValidator().validate(new StreamSource(new StringReader(string)));
        return true;
    }

    public static boolean validaDistribuicaoMDFe(String string) throws IOException, SAXException, URISyntaxException {
        return DFXMLValidador.validaDistribuicaoMDFe(string, "distDFeInt_v1.00.xsd");
    }

    public static boolean validaConsultaDfe(String string) throws Exception {
        return DFXMLValidador.validaDfe(string, "distDFeInt_v1.01.xsd");
    }

    private static boolean validaEpec(String string, String string2) throws IOException, SAXException, URISyntaxException {
        URL uRL = DFXMLValidador.class.getClassLoader().getResource(String.format("schemas/Evento_EPEC_PL_v1.01/%s", string2));
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema schema = schemaFactory.newSchema(new StreamSource(uRL.toURI().toString()));
        schema.newValidator().validate(new StreamSource(new StringReader(string)));
        return true;
    }

    public static boolean validaEpec(String string) throws Exception {
        return DFXMLValidador.validaEpec(string, "envEPEC_v1.00.xsd");
    }

    public static boolean validaEventoEpec(String string) throws Exception {
        return DFXMLValidador.validaEpec(string, "EPEC_v1.00.xsd");
    }
}

