/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.cte300.classes.os;

import com.fincatto.documentofiscal.DFBase;
import com.fincatto.documentofiscal.validadores.DFBigDecimalValidador;
import com.fincatto.documentofiscal.validadores.DFStringValidador;
import java.math.BigDecimal;
import java.time.LocalDate;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.Namespace;
import org.simpleframework.xml.Root;

@Root(name="infDocRef")
@Namespace(reference="http://www.portalfiscal.inf.br/cte")
public class CTeOSInfoCTeNormalInfoDocumentos
extends DFBase {
    private static final long serialVersionUID = 8490041070801837687L;
    @Element(name="nDoc", required=false)
    private String numeroDocumento;
    @Element(name="serie", required=false)
    private String serie;
    @Element(name="subserie", required=false)
    private String subserie;
    @Element(name="dEmi", required=false)
    private LocalDate dataEmissao;
    @Element(name="vDoc", required=false)
    private String valorDocumento;
    @Element(name="chBPe", required=false)
    private String chaveBilhetePassagem;

    public String getNumeroDocumento() {
        return this.numeroDocumento;
    }

    public void setNumeroDocumento(String string) {
        DFStringValidador.tamanho20(string, "Numero Documento");
        this.numeroDocumento = string;
    }

    public String getSerie() {
        return this.serie;
    }

    public void setSerie(String string) {
        DFStringValidador.tamanho3(string, "Serie");
        this.serie = string;
    }

    public String getSubserie() {
        return this.subserie;
    }

    public void setSubserie(String string) {
        DFStringValidador.tamanho3(string, "Subserie");
        this.subserie = string;
    }

    public LocalDate getDataEmissao() {
        return this.dataEmissao;
    }

    public void setDataEmissao(LocalDate localDate) {
        this.dataEmissao = localDate;
    }

    public String getValorDocumento() {
        return this.valorDocumento;
    }

    public void setValorDocumento(BigDecimal bigDecimal) {
        this.valorDocumento = DFBigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "Valor Documento");
    }

    public String getChaveBilhetePassagem() {
        return this.chaveBilhetePassagem;
    }

    public void setChaveBilhetePassagem(String string) {
        DFStringValidador.exatamente44N(string, "Chave de acesso do Bilhete de Passagem Eletr\u00f4nico");
        this.chaveBilhetePassagem = string;
    }
}

