/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.cte300.webservices;

import com.fincatto.documentofiscal.DFLog;
import com.fincatto.documentofiscal.cte.CTeConfig;
import com.fincatto.documentofiscal.cte300.classes.CTAutorizador31;
import com.fincatto.documentofiscal.cte300.classes.envio.CTeOSEnvioRetorno;
import com.fincatto.documentofiscal.cte300.classes.envio.CTeOSEnvioRetornoDados;
import com.fincatto.documentofiscal.cte300.classes.os.CTeOS;
import com.fincatto.documentofiscal.cte300.webservices.recepcaoOS.CteRecepcaoOSStub;
import com.fincatto.documentofiscal.utils.DFAssinaturaDigital;
import com.fincatto.documentofiscal.validadores.DFXMLValidador;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.AXIOMUtil;

class WSRecepcaoCTeOS
implements DFLog {
    private final CTeConfig config;

    WSRecepcaoCTeOS(CTeConfig cTeConfig) {
        this.config = cTeConfig;
    }

    public CTeOSEnvioRetornoDados envioRecepcao(CTeOS cTeOS) throws Exception {
        String string = new DFAssinaturaDigital(this.config).assinarDocumento(cTeOS.toString(), "infCte");
        CTeOS cTeOS2 = (CTeOS)this.config.getPersister().read(CTeOS.class, string);
        CTeOSEnvioRetorno cTeOSEnvioRetorno = this.comunicaLote(string);
        return new CTeOSEnvioRetornoDados(cTeOSEnvioRetorno, cTeOS2);
    }

    private CTeOSEnvioRetorno comunicaLote(String string) throws Exception {
        DFXMLValidador.validaCTeOS300(string);
        OMElement oMElement = AXIOMUtil.stringToOM((String)string);
        CteRecepcaoOSStub.CteDadosMsg cteDadosMsg = new CteRecepcaoOSStub.CteDadosMsg();
        cteDadosMsg.setExtraElement(oMElement);
        CteRecepcaoOSStub.CteCabecMsgE cteCabecMsgE = this.getCabecalhoSOAP();
        this.getLogger().debug(oMElement.toString());
        CTAutorizador31 cTAutorizador31 = CTAutorizador31.valueOfTipoEmissao(this.config.getTipoEmissao(), this.config.getCUF());
        String string2 = cTAutorizador31.getCteRecepcaoOS(this.config.getAmbiente());
        if (string2 == null) {
            throw new IllegalArgumentException("Nao foi possivel encontrar URL para Recepcao OS, autorizador " + cTAutorizador31.name() + ", UF " + this.config.getCUF().name());
        }
        CteRecepcaoOSStub.CteRecepcaoOSResult cteRecepcaoOSResult = new CteRecepcaoOSStub(string2, this.config).cteRecepcaoOS(cteDadosMsg, cteCabecMsgE);
        CTeOSEnvioRetorno cTeOSEnvioRetorno = (CTeOSEnvioRetorno)this.config.getPersister().read(CTeOSEnvioRetorno.class, cteRecepcaoOSResult.getExtraElement().toString());
        this.getLogger().debug(cTeOSEnvioRetorno.toString());
        return cTeOSEnvioRetorno;
    }

    private CteRecepcaoOSStub.CteCabecMsgE getCabecalhoSOAP() {
        CteRecepcaoOSStub.CteCabecMsg cteCabecMsg = new CteRecepcaoOSStub.CteCabecMsg();
        cteCabecMsg.setCUF(this.config.getCUF().getCodigoIbge());
        cteCabecMsg.setVersaoDados("3.00");
        CteRecepcaoOSStub.CteCabecMsgE cteCabecMsgE = new CteRecepcaoOSStub.CteCabecMsgE();
        cteCabecMsgE.setCteCabecMsg(cteCabecMsg);
        return cteCabecMsgE;
    }
}

