/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.cte400.classes;

import com.fincatto.documentofiscal.DFAmbiente;
import com.fincatto.documentofiscal.DFUnidadeFederativa;
import com.fincatto.documentofiscal.cte.CTTipoEmissao;
import com.fincatto.documentofiscal.cte400.parsers.CTChaveParser;
import java.util.Arrays;

public enum CTAutorizador400 {
    MT{

        @Override
        public String getCteRecepcaoSinc(DFAmbiente dFAmbiente) {
            return DFAmbiente.HOMOLOGACAO.equals((Object)dFAmbiente) ? "https://homologacao.sefaz.mt.gov.br/ctews2/services/CTeRecepcaoSincV4" : "https://cte.sefaz.mt.gov.br/ctews2/services/CTeRecepcaoSincV4";
        }

        @Override
        public String getCteRecepcaoOS(DFAmbiente dFAmbiente) {
            return DFAmbiente.HOMOLOGACAO.equals((Object)dFAmbiente) ? "https://homologacao.sefaz.mt.gov.br/ctews/services/CTeRecepcaoOSV4" : "https://cte.sefaz.mt.gov.br/ctews/services/CTeRecepcaoOSV4";
        }

        @Override
        public String getCteRecepcaoGTVe(DFAmbiente dFAmbiente) {
            return DFAmbiente.HOMOLOGACAO.equals((Object)dFAmbiente) ? "https://homologacao.sefaz.mt.gov.br/ctews2/services/CTeRecepcaoGTVeV4" : "https://cte.sefaz.mt.gov.br/ctews2/services/CTeRecepcaoGTVeV4";
        }

        @Override
        public String getCteConsultaProtocolo(DFAmbiente dFAmbiente) {
            return DFAmbiente.HOMOLOGACAO.equals((Object)dFAmbiente) ? "https://homologacao.sefaz.mt.gov.br/ctews2/services/CTeConsultaV4" : "https://cte.sefaz.mt.gov.br/ctews2/services/CTeConsultaV4";
        }

        @Override
        public String getCteStatusServico(DFAmbiente dFAmbiente) {
            return DFAmbiente.HOMOLOGACAO.equals((Object)dFAmbiente) ? "https://homologacao.sefaz.mt.gov.br/ctews2/services/CTeStatusServicoV4" : "https://cte.sefaz.mt.gov.br/ctews2/services/CTeStatusServicoV4";
        }

        @Override
        public String getCteQrCode(DFAmbiente dFAmbiente) {
            return DFAmbiente.HOMOLOGACAO.equals((Object)dFAmbiente) ? "https://homologacao.sefaz.mt.gov.br/cte/qrcode" : "https://www.sefaz.mt.gov.br/cte/qrcode";
        }

        @Override
        public String getRecepcaoEvento(DFAmbiente dFAmbiente) {
            return DFAmbiente.HOMOLOGACAO.equals((Object)dFAmbiente) ? "https://homologacao.sefaz.mt.gov.br/ctews2/services/CTeRecepcaoEventoV4" : "https://cte.sefaz.mt.gov.br/ctews2/services/CTeRecepcaoEventoV4";
        }

        @Override
        public DFUnidadeFederativa[] getUFs() {
            return new DFUnidadeFederativa[]{DFUnidadeFederativa.MT};
        }
    }
    ,
    MS{

        @Override
        public String getCteRecepcaoSinc(DFAmbiente dFAmbiente) {
            return DFAmbiente.HOMOLOGACAO.equals((Object)dFAmbiente) ? "https://homologacao.cte.ms.gov.br/ws/CTeRecepcaoSincV4" : "https://producao.cte.ms.gov.br/ws/CTeRecepcaoSincV4";
        }

        @Override
        public String getCteRecepcaoOS(DFAmbiente dFAmbiente) {
            return DFAmbiente.HOMOLOGACAO.equals((Object)dFAmbiente) ? "https://homologacao.cte.ms.gov.br/ws/CTeRecepcaoOSV4" : "https://producao.cte.ms.gov.br/ws/CTeRecepcaoOSV4";
        }

        @Override
        public String getCteRecepcaoGTVe(DFAmbiente dFAmbiente) {
            return DFAmbiente.HOMOLOGACAO.equals((Object)dFAmbiente) ? "https://homologacao.cte.ms.gov.br/ws/CTeRecepcaoGTVeV4" : "https://producao.cte.ms.gov.br/ws/CTeRecepcaoGTVeV4";
        }

        @Override
        public String getCteConsultaProtocolo(DFAmbiente dFAmbiente) {
            return DFAmbiente.HOMOLOGACAO.equals((Object)dFAmbiente) ? "https://homologacao.cte.ms.gov.br/ws/CTeConsultaV4" : "https://producao.cte.ms.gov.br/ws/CTeConsultaV4";
        }

        @Override
        public String getCteStatusServico(DFAmbiente dFAmbiente) {
            return DFAmbiente.HOMOLOGACAO.equals((Object)dFAmbiente) ? "https://homologacao.cte.ms.gov.br/ws/CTeStatusServicoV4" : "https://producao.cte.ms.gov.br/ws/CTeStatusServicoV4";
        }

        @Override
        public String getCteQrCode(DFAmbiente dFAmbiente) {
            return "http://www.dfe.ms.gov.br/cte/qrcode";
        }

        @Override
        public String getRecepcaoEvento(DFAmbiente dFAmbiente) {
            return DFAmbiente.HOMOLOGACAO.equals((Object)dFAmbiente) ? "https://homologacao.cte.ms.gov.br/ws/CTeRecepcaoEventoV4" : "https://producao.cte.ms.gov.br/ws/CTeRecepcaoEventoV4";
        }

        @Override
        public DFUnidadeFederativa[] getUFs() {
            return new DFUnidadeFederativa[]{DFUnidadeFederativa.MS};
        }
    }
    ,
    MG{

        @Override
        public String getCteRecepcaoSinc(DFAmbiente dFAmbiente) {
            return DFAmbiente.HOMOLOGACAO.equals((Object)dFAmbiente) ? "https://hcte.fazenda.mg.gov.br/cte/services/CTeRecepcaoSincV4" : "https://cte.fazenda.mg.gov.br/cte/services/CTeRecepcaoSincV4";
        }

        @Override
        public String getCteRecepcaoOS(DFAmbiente dFAmbiente) {
            return DFAmbiente.HOMOLOGACAO.equals((Object)dFAmbiente) ? "https://hcte.fazenda.mg.gov.br/cte/services/CTeRecepcaoOSV4" : "https://cte.fazenda.mg.gov.br/cte/services/CTeRecepcaoOSV4";
        }

        @Override
        public String getCteRecepcaoGTVe(DFAmbiente dFAmbiente) {
            return DFAmbiente.HOMOLOGACAO.equals((Object)dFAmbiente) ? "https://hcte.fazenda.mg.gov.br/cte/services/CTeRecepcaoGTVeV4" : "https://cte.fazenda.mg.gov.br/cte/services/CTeRecepcaoGTVeV4";
        }

        @Override
        public String getCteConsultaProtocolo(DFAmbiente dFAmbiente) {
            return DFAmbiente.HOMOLOGACAO.equals((Object)dFAmbiente) ? "https://hcte.fazenda.mg.gov.br/cte/services/CTeConsultaV4" : "https://cte.fazenda.mg.gov.br/cte/services/CTeConsultaV4";
        }

        @Override
        public String getCteStatusServico(DFAmbiente dFAmbiente) {
            return DFAmbiente.HOMOLOGACAO.equals((Object)dFAmbiente) ? "https://hcte.fazenda.mg.gov.br/cte/services/CTeStatusServicoV4" : "https://cte.fazenda.mg.gov.br/cte/services/CTeStatusServicoV4";
        }

        @Override
        public String getCteQrCode(DFAmbiente dFAmbiente) {
            return "https://portalcte.fazenda.mg.gov.br/portalcte/sistema/qrcode.xhtml";
        }

        @Override
        public String getRecepcaoEvento(DFAmbiente dFAmbiente) {
            return DFAmbiente.HOMOLOGACAO.equals((Object)dFAmbiente) ? "https://hcte.fazenda.mg.gov.br/cte/services/CTeRecepcaoEventoV4" : "https://cte.fazenda.mg.gov.br/cte/services/CTeRecepcaoEventoV4";
        }

        @Override
        public DFUnidadeFederativa[] getUFs() {
            return new DFUnidadeFederativa[]{DFUnidadeFederativa.MG};
        }
    }
    ,
    PR{

        @Override
        public String getCteRecepcaoSinc(DFAmbiente dFAmbiente) {
            return DFAmbiente.HOMOLOGACAO.equals((Object)dFAmbiente) ? "https://homologacao.cte.fazenda.pr.gov.br/cte4/CTeRecepcaoSincV4" : "https://cte.fazenda.pr.gov.br/cte4/CTeRecepcaoSincV4";
        }

        @Override
        public String getCteRecepcaoOS(DFAmbiente dFAmbiente) {
            return DFAmbiente.HOMOLOGACAO.equals((Object)dFAmbiente) ? "https://homologacao.cte.fazenda.pr.gov.br/cte4/CTeRecepcaoOSV4" : "https://cte.fazenda.pr.gov.br/cte4/CTeRecepcaoOSV4";
        }

        @Override
        public String getCteRecepcaoGTVe(DFAmbiente dFAmbiente) {
            return DFAmbiente.HOMOLOGACAO.equals((Object)dFAmbiente) ? "https://homologacao.cte.fazenda.pr.gov.br/cte4/CTeRecepcaoGTVeV4" : "https://cte.fazenda.pr.gov.br/cte4/CTeRecepcaoGTVeV4";
        }

        @Override
        public String getCteConsultaProtocolo(DFAmbiente dFAmbiente) {
            return DFAmbiente.HOMOLOGACAO.equals((Object)dFAmbiente) ? "https://homologacao.cte.fazenda.pr.gov.br/cte4/CTeConsultaV4" : "https://cte.fazenda.pr.gov.br/cte4/CTeConsultaV4";
        }

        @Override
        public String getCteStatusServico(DFAmbiente dFAmbiente) {
            return DFAmbiente.HOMOLOGACAO.equals((Object)dFAmbiente) ? "https://homologacao.cte.fazenda.pr.gov.br/cte4/CTeStatusServicoV4" : "https://cte.fazenda.pr.gov.br/cte4/CTeStatusServicoV4";
        }

        @Override
        public String getCteQrCode(DFAmbiente dFAmbiente) {
            return "http://www.fazenda.pr.gov.br/cte/qrcode";
        }

        @Override
        public String getRecepcaoEvento(DFAmbiente dFAmbiente) {
            return DFAmbiente.HOMOLOGACAO.equals((Object)dFAmbiente) ? "https://homologacao.cte.fazenda.pr.gov.br/cte4/CTeRecepcaoEventoV4" : "https://cte.fazenda.pr.gov.br/cte4/CTeRecepcaoEventoV4";
        }

        @Override
        public DFUnidadeFederativa[] getUFs() {
            return new DFUnidadeFederativa[]{DFUnidadeFederativa.PR};
        }
    }
    ,
    RS{

        @Override
        public String getCteRecepcaoSinc(DFAmbiente dFAmbiente) {
            return DFAmbiente.HOMOLOGACAO.equals((Object)dFAmbiente) ? "https://cte-homologacao.svrs.rs.gov.br/ws/CTeRecepcaoSincV4/CTeRecepcaoSincV4.asmx" : "https://cte.svrs.rs.gov.br/ws/CTeRecepcaoSincV4/CTeRecepcaoSincV4.asmx";
        }

        @Override
        public String getCteRecepcaoOS(DFAmbiente dFAmbiente) {
            return DFAmbiente.HOMOLOGACAO.equals((Object)dFAmbiente) ? "https://cte-homologacao.svrs.rs.gov.br/ws/CTeRecepcaoOSV4/CTeRecepcaoOSV4.asmx" : "https://cte.svrs.rs.gov.br/ws/CTeRecepcaoOSV4/CTeRecepcaoOSV4.asmx";
        }

        @Override
        public String getCteRecepcaoGTVe(DFAmbiente dFAmbiente) {
            return DFAmbiente.HOMOLOGACAO.equals((Object)dFAmbiente) ? "https://cte-homologacao.svrs.rs.gov.br/ws/CTeRecepcaoGTVeV4/CTeRecepcaoGTVeV4.asmx" : "https://cte.svrs.rs.gov.br/ws/CTeRecepcaoGTVeV4/CTeRecepcaoGTVeV4.asmx";
        }

        @Override
        public String getCteConsultaProtocolo(DFAmbiente dFAmbiente) {
            return DFAmbiente.HOMOLOGACAO.equals((Object)dFAmbiente) ? "https://cte-homologacao.svrs.rs.gov.br/ws/CTeConsultaV4/CTeConsultaV4.asmx" : "https://cte.svrs.rs.gov.br/ws/CTeConsultaV4/CTeConsultaV4.asmx";
        }

        @Override
        public String getCteStatusServico(DFAmbiente dFAmbiente) {
            return DFAmbiente.HOMOLOGACAO.equals((Object)dFAmbiente) ? "https://cte-homologacao.svrs.rs.gov.br/ws/CTeStatusServicoV4/CTeStatusServicoV4.asmx" : "https://cte.svrs.rs.gov.br/ws/CTeStatusServicoV4/CTeStatusServicoV4.asmx";
        }

        @Override
        public String getCteQrCode(DFAmbiente dFAmbiente) {
            return "https://dfe-portal.svrs.rs.gov.br/cte/qrCode";
        }

        @Override
        public String getRecepcaoEvento(DFAmbiente dFAmbiente) {
            return DFAmbiente.HOMOLOGACAO.equals((Object)dFAmbiente) ? "https://cte-homologacao.svrs.rs.gov.br/ws/CTeRecepcaoEventoV4/CTeRecepcaoEventoV4.asmx" : "https://cte.svrs.rs.gov.br/ws/CTeRecepcaoEventoV4/CTeRecepcaoEventoV4.asmx";
        }

        @Override
        public DFUnidadeFederativa[] getUFs() {
            return new DFUnidadeFederativa[]{DFUnidadeFederativa.RS};
        }
    }
    ,
    SP{

        @Override
        public String getCteRecepcaoSinc(DFAmbiente dFAmbiente) {
            return DFAmbiente.HOMOLOGACAO.equals((Object)dFAmbiente) ? "https://homologacao.nfe.fazenda.sp.gov.br/CTeWS/WS/CTeRecepcaoSincV4.asmx" : "https://nfe.fazenda.sp.gov.br/CTeWS/WS/CTeRecepcaoSincV4.asmx";
        }

        @Override
        public String getCteRecepcaoOS(DFAmbiente dFAmbiente) {
            return DFAmbiente.HOMOLOGACAO.equals((Object)dFAmbiente) ? "https://homologacao.nfe.fazenda.sp.gov.br/CTeWS/WS/CTeRecepcaoOSV4.asmx" : "https://nfe.fazenda.sp.gov.br/CTeWS/WS/CTeRecepcaoOSV4.asmx";
        }

        @Override
        public String getCteRecepcaoGTVe(DFAmbiente dFAmbiente) {
            return DFAmbiente.HOMOLOGACAO.equals((Object)dFAmbiente) ? "https://homologacao.nfe.fazenda.sp.gov.br/CTeWS/WS/CTeRecepcaoGTVeV4.asmx" : "https://nfe.fazenda.sp.gov.br/CTeWS/WS/CTeRecepcaoGTVeV4.asmx";
        }

        @Override
        public String getCteConsultaProtocolo(DFAmbiente dFAmbiente) {
            return DFAmbiente.HOMOLOGACAO.equals((Object)dFAmbiente) ? "https://homologacao.nfe.fazenda.sp.gov.br/CTeWS/WS/CTeConsultaV4.asmx" : "https://nfe.fazenda.sp.gov.br/CTeWS/WS/CTeConsultaV4.asmx";
        }

        @Override
        public String getCteStatusServico(DFAmbiente dFAmbiente) {
            return DFAmbiente.HOMOLOGACAO.equals((Object)dFAmbiente) ? "https://homologacao.nfe.fazenda.sp.gov.br/CTeWS/WS/CTeStatusServicoV4.asmx" : "https://nfe.fazenda.sp.gov.br/CTeWS/WS/CTeStatusServicoV4.asmx";
        }

        @Override
        public String getCteQrCode(DFAmbiente dFAmbiente) {
            return DFAmbiente.HOMOLOGACAO.equals((Object)dFAmbiente) ? "https://homologacao.nfe.fazenda.sp.gov.br/CTeConsulta/qrCode" : "https://nfe.fazenda.sp.gov.br/CTeConsulta/qrCode";
        }

        @Override
        public String getRecepcaoEvento(DFAmbiente dFAmbiente) {
            return DFAmbiente.HOMOLOGACAO.equals((Object)dFAmbiente) ? "https://homologacao.nfe.fazenda.sp.gov.br/CTeWS/WS/CTeRecepcaoEventoV4.asmx" : "https://nfe.fazenda.sp.gov.br/CTeWS/WS/CTeRecepcaoEventoV4.asmx";
        }

        @Override
        public DFUnidadeFederativa[] getUFs() {
            return new DFUnidadeFederativa[]{DFUnidadeFederativa.SP};
        }
    }
    ,
    SVRS{

        @Override
        public String getCteRecepcaoSinc(DFAmbiente dFAmbiente) {
            return DFAmbiente.HOMOLOGACAO.equals((Object)dFAmbiente) ? "https://cte-homologacao.svrs.rs.gov.br/ws/CTeRecepcaoSincV4/CTeRecepcaoSincV4.asmx" : "https://cte.svrs.rs.gov.br/ws/CTeRecepcaoSincV4/CTeRecepcaoSincV4.asmx";
        }

        @Override
        public String getCteRecepcaoOS(DFAmbiente dFAmbiente) {
            return DFAmbiente.HOMOLOGACAO.equals((Object)dFAmbiente) ? "https://cte-homologacao.svrs.rs.gov.br/ws/CTeRecepcaoOSV4/CTeRecepcaoOSV4.asmx" : "https://cte.svrs.rs.gov.br/ws/CTeRecepcaoOSV4/CTeRecepcaoOSV4.asmx";
        }

        @Override
        public String getCteRecepcaoGTVe(DFAmbiente dFAmbiente) {
            return DFAmbiente.HOMOLOGACAO.equals((Object)dFAmbiente) ? "https://cte-homologacao.svrs.rs.gov.br/ws/CTeRecepcaoGTVeV4/CTeRecepcaoGTVeV4.asmx" : "https://cte.svrs.rs.gov.br/ws/CTeRecepcaoGTVeV4/CTeRecepcaoGTVeV4.asmx";
        }

        @Override
        public String getCteConsultaProtocolo(DFAmbiente dFAmbiente) {
            return DFAmbiente.HOMOLOGACAO.equals((Object)dFAmbiente) ? "https://cte-homologacao.svrs.rs.gov.br/ws/CTeConsultaV4/CTeConsultaV4.asmx" : "https://cte.svrs.rs.gov.br/ws/CTeConsultaV4/CTeConsultaV4.asmx";
        }

        @Override
        public String getCteStatusServico(DFAmbiente dFAmbiente) {
            return DFAmbiente.HOMOLOGACAO.equals((Object)dFAmbiente) ? "https://cte-homologacao.svrs.rs.gov.br/ws/CTeStatusServicoV4/CTeStatusServicoV4.asmx" : "https://cte.svrs.rs.gov.br/ws/CTeStatusServicoV4/CTeStatusServicoV4.asmx";
        }

        @Override
        public String getCteQrCode(DFAmbiente dFAmbiente) {
            return "https://dfe-portal.svrs.rs.gov.br/cte/qrCode";
        }

        @Override
        public String getRecepcaoEvento(DFAmbiente dFAmbiente) {
            return DFAmbiente.HOMOLOGACAO.equals((Object)dFAmbiente) ? "https://cte-homologacao.svrs.rs.gov.br/ws/CTeRecepcaoEventoV4/CTeRecepcaoEventoV4.asmx" : "https://cte.svrs.rs.gov.br/ws/CTeRecepcaoEventoV4/CTeRecepcaoEventoV4.asmx";
        }

        @Override
        public DFUnidadeFederativa[] getUFs() {
            return new DFUnidadeFederativa[]{DFUnidadeFederativa.AC, DFUnidadeFederativa.AL, DFUnidadeFederativa.AM, DFUnidadeFederativa.BA, DFUnidadeFederativa.CE, DFUnidadeFederativa.DF, DFUnidadeFederativa.ES, DFUnidadeFederativa.GO, DFUnidadeFederativa.MA, DFUnidadeFederativa.PA, DFUnidadeFederativa.PB, DFUnidadeFederativa.PI, DFUnidadeFederativa.RJ, DFUnidadeFederativa.RN, DFUnidadeFederativa.RO, DFUnidadeFederativa.SC, DFUnidadeFederativa.SE, DFUnidadeFederativa.TO};
        }
    }
    ,
    SVSP{

        @Override
        public String getCteRecepcaoSinc(DFAmbiente dFAmbiente) {
            return DFAmbiente.HOMOLOGACAO.equals((Object)dFAmbiente) ? "https://homologacao.nfe.fazenda.sp.gov.br/CTeWS/WS/CTeRecepcaoSincV4.asmx" : "https://nfe.fazenda.sp.gov.br/CTeWS/WS/CTeRecepcaoSincV4.asmx";
        }

        @Override
        public String getCteRecepcaoOS(DFAmbiente dFAmbiente) {
            return DFAmbiente.HOMOLOGACAO.equals((Object)dFAmbiente) ? "https://homologacao.nfe.fazenda.sp.gov.br/CTeWS/WS/CTeRecepcaoOSV4.asmx" : "https://nfe.fazenda.sp.gov.br/CTeWS/WS/CTeRecepcaoOSV4.asmx";
        }

        @Override
        public String getCteRecepcaoGTVe(DFAmbiente dFAmbiente) {
            return DFAmbiente.HOMOLOGACAO.equals((Object)dFAmbiente) ? "https://homologacao.nfe.fazenda.sp.gov.br/CTeWS/WS/CTeRecepcaoGTVeV4.asmx" : "https://nfe.fazenda.sp.gov.br/CTeWS/WS/CTeRecepcaoGTVeV4.asmx";
        }

        @Override
        public String getCteConsultaProtocolo(DFAmbiente dFAmbiente) {
            return DFAmbiente.HOMOLOGACAO.equals((Object)dFAmbiente) ? "https://homologacao.nfe.fazenda.sp.gov.br/CTeWS/WS/CTeConsultaV4.asmx" : "https://nfe.fazenda.sp.gov.br/CTeWS/WS/CTeConsultaV4.asmx";
        }

        @Override
        public String getCteStatusServico(DFAmbiente dFAmbiente) {
            return DFAmbiente.HOMOLOGACAO.equals((Object)dFAmbiente) ? "https://homologacao.nfe.fazenda.sp.gov.br/CTeWS/WS/CTeStatusServicoV4.asmx" : "https://nfe.fazenda.sp.gov.br/CTeWS/WS/CTeStatusServicoV4.asmx";
        }

        @Override
        public String getCteQrCode(DFAmbiente dFAmbiente) {
            return DFAmbiente.HOMOLOGACAO.equals((Object)dFAmbiente) ? "https://homologacao.nfe.fazenda.sp.gov.br/CTeConsulta/qrCode" : "https://nfe.fazenda.sp.gov.br/CTeConsulta/qrCode";
        }

        @Override
        public String getRecepcaoEvento(DFAmbiente dFAmbiente) {
            return DFAmbiente.HOMOLOGACAO.equals((Object)dFAmbiente) ? "https://homologacao.nfe.fazenda.sp.gov.br/CTeWS/WS/CTeRecepcaoEventoV4.asmx" : "https://nfe.fazenda.sp.gov.br/CTeWS/WS/CTeRecepcaoEventoV4.asmx";
        }

        @Override
        public DFUnidadeFederativa[] getUFs() {
            return new DFUnidadeFederativa[]{DFUnidadeFederativa.AP, DFUnidadeFederativa.PE, DFUnidadeFederativa.RR};
        }
    };


    public abstract String getCteRecepcaoSinc(DFAmbiente var1);

    public abstract String getCteRecepcaoOS(DFAmbiente var1);

    public abstract String getCteRecepcaoGTVe(DFAmbiente var1);

    public abstract String getCteConsultaProtocolo(DFAmbiente var1);

    public abstract String getCteStatusServico(DFAmbiente var1);

    public abstract String getCteQrCode(DFAmbiente var1);

    public abstract String getRecepcaoEvento(DFAmbiente var1);

    public abstract DFUnidadeFederativa[] getUFs();

    public static CTAutorizador400 valueOfCodigoUF(DFUnidadeFederativa dFUnidadeFederativa) {
        for (CTAutorizador400 cTAutorizador400 : CTAutorizador400.values()) {
            if (!Arrays.asList(cTAutorizador400.getUFs()).contains((Object)dFUnidadeFederativa)) continue;
            return cTAutorizador400;
        }
        throw new IllegalStateException(String.format("N\u00e3o existe autorizador para a UF %s", dFUnidadeFederativa.getCodigo()));
    }

    public static CTAutorizador400 valueOfChaveAcesso(String string) {
        CTChaveParser cTChaveParser = new CTChaveParser(string);
        if (cTChaveParser.isEmitidaContingenciaSCVRS()) {
            return SVRS;
        }
        if (cTChaveParser.isEmitidaContingenciaSCVSP()) {
            return SVSP;
        }
        return CTAutorizador400.valueOfCodigoUF(cTChaveParser.getNFUnidadeFederativa());
    }

    public static CTAutorizador400 valueOfTipoEmissao(CTTipoEmissao cTTipoEmissao, DFUnidadeFederativa dFUnidadeFederativa) {
        switch (cTTipoEmissao) {
            case EMISSAO_NORMAL: {
                return CTAutorizador400.valueOfCodigoUF(dFUnidadeFederativa);
            }
            case CONTINGENCIA_SVCSP: {
                return SVSP;
            }
            case CONTINGENCIA_SVCRS: {
                return SVRS;
            }
        }
        throw new IllegalArgumentException("N\u00e3o ha implementac\u00e3o para o tipo de emiss\u00e3o: " + cTTipoEmissao.getDescricao());
    }
}

