/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.cte400.classes.nota.consulta;

import com.fincatto.documentofiscal.DFBase;
import com.fincatto.documentofiscal.cte400.classes.evento.CTeEvento;
import com.fincatto.documentofiscal.cte400.classes.evento.CTeEventoRetorno;
import com.fincatto.documentofiscal.validadores.DFBigDecimalValidador;
import java.math.BigDecimal;
import java.time.ZonedDateTime;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.Namespace;
import org.simpleframework.xml.Root;

@Root(name="procEventoCTe")
@Namespace(reference="http://www.portalfiscal.inf.br/cte")
public class CTeProtocoloEvento
extends DFBase {
    private static final long serialVersionUID = -5921322695285609605L;
    @Attribute(name="versao")
    private String versao;
    @Attribute(name="ipTransmissor", required=false)
    private String ipTransmissor;
    @Attribute(name="nPortaCon", required=false)
    private String portaConexao;
    @Attribute(name="dhConexao", required=false)
    private ZonedDateTime dataHoraConexao;
    @Element(name="eventoCTe")
    private CTeEvento evento;
    @Element(name="retEventoCTe", required=false)
    private CTeEventoRetorno eventoRetorno;

    public String getVersao() {
        return this.versao;
    }

    public void setVersao(BigDecimal bigDecimal) {
        this.versao = DFBigDecimalValidador.tamanho4Com2CasasDecimais(bigDecimal, "Versao");
    }

    public String getIpTransmissor() {
        return this.ipTransmissor;
    }

    public void setIpTransmissor(String string) {
        this.ipTransmissor = string;
    }

    public String getPortaConexao() {
        return this.portaConexao;
    }

    public void setPortaConexao(String string) {
        this.portaConexao = string;
    }

    public ZonedDateTime getDataHoraConexao() {
        return this.dataHoraConexao;
    }

    public void setDataHoraConexao(ZonedDateTime zonedDateTime) {
        this.dataHoraConexao = zonedDateTime;
    }

    public CTeEvento getEvento() {
        return this.evento;
    }

    public void setEvento(CTeEvento cTeEvento) {
        this.evento = cTeEvento;
    }

    public void setEventoRetorno(CTeEventoRetorno cTeEventoRetorno) {
        this.eventoRetorno = cTeEventoRetorno;
    }

    public CTeEventoRetorno getEventoRetorno() {
        return this.eventoRetorno;
    }
}

