/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.cte400.webservices;

import com.fincatto.documentofiscal.DFLog;
import com.fincatto.documentofiscal.cte.CTeConfig;
import com.fincatto.documentofiscal.cte400.classes.CTAutorizador400;
import com.fincatto.documentofiscal.cte400.classes.nota.consulta.CTeNotaConsulta;
import com.fincatto.documentofiscal.cte400.classes.nota.consulta.CTeNotaConsultaRetorno;
import com.fincatto.documentofiscal.cte400.webservices.gerado.CTeConsultaV4Stub;
import java.math.BigDecimal;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.AXIOMUtil;

public class WSConsulta
implements DFLog {
    private static final String NOME_SERVICO = "CONSULTAR";
    private final CTeConfig config;

    WSConsulta(CTeConfig cTeConfig) {
        this.config = cTeConfig;
    }

    public CTeNotaConsultaRetorno consultaNota(String string) throws Exception {
        OMElement oMElement = AXIOMUtil.stringToOM((String)this.gerarDadosConsulta(string).toString());
        this.getLogger().debug(oMElement.toString());
        OMElement oMElement2 = this.efetuaConsulta(oMElement, string);
        this.getLogger().debug(oMElement2.toString());
        CTeNotaConsultaRetorno cTeNotaConsultaRetorno = (CTeNotaConsultaRetorno)this.config.getPersister().read(CTeNotaConsultaRetorno.class, oMElement2.toString());
        this.getLogger().debug(cTeNotaConsultaRetorno.toString());
        return cTeNotaConsultaRetorno;
    }

    private OMElement efetuaConsulta(OMElement oMElement, String string) throws Exception {
        CTeConsultaV4Stub.CteDadosMsg cteDadosMsg = new CTeConsultaV4Stub.CteDadosMsg();
        cteDadosMsg.setExtraElement(oMElement);
        CTAutorizador400 cTAutorizador400 = CTAutorizador400.valueOfChaveAcesso(string);
        String string2 = cTAutorizador400.getCteConsultaProtocolo(this.config.getAmbiente());
        if (string2 == null) {
            throw new IllegalArgumentException("Nao foi possivel encontrar URL para Consulta, autorizador " + cTAutorizador400.name() + ", UF " + this.config.getCUF().name());
        }
        this.getLogger().debug(string2);
        CTeConsultaV4Stub.CteConsultaCTResult cteConsultaCTResult = new CTeConsultaV4Stub(string2, this.config).cteConsultaCT(cteDadosMsg);
        return cteConsultaCTResult.getExtraElement();
    }

    private CTeNotaConsulta gerarDadosConsulta(String string) {
        CTeNotaConsulta cTeNotaConsulta = new CTeNotaConsulta();
        cTeNotaConsulta.setAmbiente(this.config.getAmbiente());
        cTeNotaConsulta.setChave(string);
        cTeNotaConsulta.setServico(NOME_SERVICO);
        cTeNotaConsulta.setVersao(new BigDecimal("4.00"));
        return cTeNotaConsulta;
    }
}

