/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.mdfe3.classes.nota;

import com.fincatto.documentofiscal.mdfe3.classes.def.MDFTipoIndAltoDesempenho;
import com.fincatto.documentofiscal.mdfe3.classes.def.MDFTipoIndicadorAntecipacaoPagamento;
import com.fincatto.documentofiscal.mdfe3.classes.def.MDFTipoInfPag;
import com.fincatto.documentofiscal.mdfe3.classes.def.MDFTipoPermissaoAntecipacao;
import com.fincatto.documentofiscal.mdfe3.classes.nota.MDFInfoModalRodoviarioInfPagBanco;
import com.fincatto.documentofiscal.mdfe3.classes.nota.MDFInfoModalRodoviarioInfPagComp;
import com.fincatto.documentofiscal.mdfe3.classes.nota.MDFInfoModalRodoviarioInfPagPrazo;
import com.fincatto.documentofiscal.validadores.DFBigDecimalValidador;
import com.fincatto.documentofiscal.validadores.DFStringValidador;
import java.math.BigDecimal;
import java.util.List;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementList;

public class MDFInfoModalRodoviarioInfPag {
    @Element(name="xNome", required=false)
    private String xNome;
    @Element(name="CPF", required=false)
    private String cpf;
    @Element(name="CNPJ", required=false)
    private String cnpj;
    @Element(name="idEstrangeiro", required=false)
    private String idEstrangeiro;
    @ElementList(entry="Comp", inline=true, required=true)
    private List<MDFInfoModalRodoviarioInfPagComp> comp;
    @Element(name="vContrato", required=true)
    private BigDecimal vContrato;
    @Element(name="indAltoDesemp", required=false)
    private MDFTipoIndAltoDesempenho indAltoDesemp;
    @Element(name="indPag", required=true)
    private MDFTipoInfPag indPag;
    @Element(name="vAdiant", required=false)
    private BigDecimal vAdiant;
    @Element(name="indAntecipaAdiant", required=false)
    private MDFTipoIndicadorAntecipacaoPagamento indicadorAtencipacaoAdiantamento;
    @ElementList(entry="infPrazo", inline=true, required=false)
    private List<MDFInfoModalRodoviarioInfPagPrazo> infPrazo;
    @Element(name="tpAntecip", required=false)
    private MDFTipoPermissaoAntecipacao tipoPermissaoAntecipacao;
    @Element(name="infBanc", required=true)
    private MDFInfoModalRodoviarioInfPagBanco infBanc;

    public String getXNome() {
        return this.xNome;
    }

    public void setXNome(String string) {
        this.xNome = string;
    }

    public String getCpf() {
        return this.cpf;
    }

    public void setCpf(String string) {
        if (this.cnpj != null || this.idEstrangeiro != null) {
            throw new IllegalStateException("Nao deve setar CPF se CNPJ/IdEstrangeiro esteja setado");
        }
        DFStringValidador.cpf(string);
        this.cpf = string;
    }

    public String getCnpj() {
        return this.cnpj;
    }

    public void setCnpj(String string) {
        if (this.cpf != null || this.idEstrangeiro != null) {
            throw new IllegalStateException("Nao deve setar CNPJ se CPF/IdEstrangeiro esteja setado");
        }
        DFStringValidador.cnpj(string);
        this.cnpj = string;
    }

    public String getIdEstrangeiro() {
        return this.idEstrangeiro;
    }

    public void setIdEstrangeiro(String string) {
        if (this.cpf != null || this.cnpj != null) {
            throw new IllegalStateException("Nao deve setar IdEstrangeiro se CPF/CNPJ esteja setado");
        }
        this.idEstrangeiro = string;
    }

    public List<MDFInfoModalRodoviarioInfPagComp> getComp() {
        return this.comp;
    }

    public void setComp(List<MDFInfoModalRodoviarioInfPagComp> list) {
        this.comp = list;
    }

    public BigDecimal getVContrato() {
        return this.vContrato;
    }

    public void setVContrato(BigDecimal bigDecimal) {
        this.vContrato = bigDecimal;
    }

    public MDFTipoIndAltoDesempenho getIndAltoDesemp() {
        return this.indAltoDesemp;
    }

    public void setIndAltoDesemp(MDFTipoIndAltoDesempenho mDFTipoIndAltoDesempenho) {
        this.indAltoDesemp = mDFTipoIndAltoDesempenho;
    }

    public MDFTipoInfPag getIndPag() {
        return this.indPag;
    }

    public void setIndPag(MDFTipoInfPag mDFTipoInfPag) {
        this.indPag = mDFTipoInfPag;
    }

    public BigDecimal getVAdiant() {
        return this.vAdiant;
    }

    public void setVAdiant(BigDecimal bigDecimal) {
        DFBigDecimalValidador.tamanho13Com2CasasDecimais(bigDecimal, "Valor do Adiantamento");
        this.vAdiant = bigDecimal;
    }

    public MDFTipoIndicadorAntecipacaoPagamento getIndicadorAtencipacaoAdiantamento() {
        return this.indicadorAtencipacaoAdiantamento;
    }

    public void setIndicadorAtencipacaoAdiantamento(MDFTipoIndicadorAntecipacaoPagamento mDFTipoIndicadorAntecipacaoPagamento) {
        this.indicadorAtencipacaoAdiantamento = mDFTipoIndicadorAntecipacaoPagamento;
    }

    public List<MDFInfoModalRodoviarioInfPagPrazo> getInfPrazo() {
        return this.infPrazo;
    }

    public void setInfPrazo(List<MDFInfoModalRodoviarioInfPagPrazo> list) {
        this.infPrazo = list;
    }

    public MDFTipoPermissaoAntecipacao getTipoPermissaoAntecipacao() {
        return this.tipoPermissaoAntecipacao;
    }

    public void setTipoPermissaoAntecipacao(MDFTipoPermissaoAntecipacao mDFTipoPermissaoAntecipacao) {
        this.tipoPermissaoAntecipacao = mDFTipoPermissaoAntecipacao;
    }

    public MDFInfoModalRodoviarioInfPagBanco getInfBanc() {
        return this.infBanc;
    }

    public void setInfBanc(MDFInfoModalRodoviarioInfPagBanco mDFInfoModalRodoviarioInfPagBanco) {
        this.infBanc = mDFInfoModalRodoviarioInfPagBanco;
    }
}

