/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.mdfe3.classes.nota;

import com.fincatto.documentofiscal.DFBase;
import com.fincatto.documentofiscal.mdfe3.classes.def.MDFTipoCategoriaCombinacaoVeicular;
import com.fincatto.documentofiscal.mdfe3.classes.def.MDFTipoValePedagio;
import com.fincatto.documentofiscal.validadores.DFBigDecimalValidador;
import com.fincatto.documentofiscal.validadores.DFStringValidador;
import java.math.BigDecimal;
import org.simpleframework.xml.Element;

public class MDFInfoModalRodoviarioPedagioDisp
extends DFBase {
    private static final long serialVersionUID = 2437667548944630950L;
    @Element(name="CNPJForn")
    private String cnpjFornecedora;
    @Element(name="CNPJPg", required=false)
    private String cnpjPagadora;
    @Element(name="CPFPg", required=false)
    protected String cpfPagadora;
    @Element(name="nCompra", required=false)
    private String numeroComprovante;
    @Element(name="vValePed")
    private String valor;
    @Element(name="tpValePed", required=false)
    private MDFTipoValePedagio tipoValePedagio;
    @Element(name="categCombVeic", required=false)
    private MDFTipoCategoriaCombinacaoVeicular categoriaCombinacaoVeicular;

    public String getCnpjFornecedora() {
        return this.cnpjFornecedora;
    }

    public void setCnpjFornecedora(String string) {
        DFStringValidador.cnpj(string);
        this.cnpjFornecedora = string;
    }

    public String getNumeroComprovante() {
        return this.numeroComprovante;
    }

    public void setNumeroComprovante(String string) {
        DFStringValidador.tamanho20N(string, "Numero do comprovante de compra");
        this.numeroComprovante = string;
    }

    public String getCnpjPagadora() {
        return this.cnpjPagadora;
    }

    public void setCnpjPagadora(String string) {
        if (this.cpfPagadora != null) {
            throw new IllegalStateException("Nao deve setar CNPJ se CPF esteja setado em PedagioDisp ");
        }
        DFStringValidador.cnpj(string);
        this.cnpjPagadora = string;
    }

    public String getValor() {
        return this.valor;
    }

    public void setValor(BigDecimal bigDecimal) {
        this.valor = DFBigDecimalValidador.tamanho13Com2CasasDecimais(bigDecimal, "Valor do pedagio");
    }

    public String getCpfPagadora() {
        return this.cpfPagadora;
    }

    public void setCpfPagadora(String string) {
        if (this.cnpjPagadora != null) {
            throw new IllegalStateException("Nao deve setar CPF se CNPJ esteja setado em PedagioDisp ");
        }
        DFStringValidador.cpf(string);
        this.cpfPagadora = string;
    }

    public MDFTipoValePedagio getTipoValePedagio() {
        return this.tipoValePedagio;
    }

    public void setTipoValePedagio(MDFTipoValePedagio mDFTipoValePedagio) {
        this.tipoValePedagio = mDFTipoValePedagio;
    }

    public MDFTipoCategoriaCombinacaoVeicular getCategoriaCombinacaoVeicular() {
        return this.categoriaCombinacaoVeicular;
    }

    public void setCategoriaCombinacaoVeicular(MDFTipoCategoriaCombinacaoVeicular mDFTipoCategoriaCombinacaoVeicular) {
        this.categoriaCombinacaoVeicular = mDFTipoCategoriaCombinacaoVeicular;
    }
}

